/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.communities;

import com.adobe.aem.demomachine.Hostname;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@SlingServlet(paths={"/bin/SetupCommunities"}, methods={"GET"}, metatype=false)
public class SetupCommunities
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 2891656166255468489L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServerException, IOException {
        PrintWriter out = response.getWriter();
        ResourceResolver resourceResolver = request.getResourceResolver();
        String userId = resourceResolver.getUserID();
        if (userId == null || !userId.equals("admin")) {
            out.println("Permission denied: admin user requested to access this feature");
            return;
        }
        String csvPath = request.getParameter("contentPath");
        if (csvPath == null) {
            csvPath = "";
        }
        String coralVersion = "3";
        Resource resCoral = resourceResolver.getResource("/etc/clientlibs/granite/coralui3.js");
        if (resCoral == null) {
            coralVersion = "2";
        }
        response.setContentType("text/html");
        out.println("<html><head>");
        out.println("<link rel=\"stylesheet\" href=\"/etc/clientlibs/granite/coralui" + coralVersion + ".css\" type=\"text/css\">");
        out.println("<script type=\"text/javascript\" src=\"/etc/clientlibs/granite/typekit.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"/etc/clientlibs/granite/jquery.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"/etc/clientlibs/granite/utils.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"/etc/clientlibs/granite/moment.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"/etc/clientlibs/granite/coralui" + coralVersion + ".js\"></script>");
        out.println("</head><body class=\"coral--light u-coral-clearFix\" style=\"margin:40px\">");
        out.println("<script language=\"JavaScript\">if(window.frameElement){window.top.location=window.location.href;}</script>");
        out.println("<a name=\"top\"/>");
        out.println("<div><h1>AEM Communities - Demo Setup</h1>");
        out.println("<form action=\"/bin/CreateCommunities\" method=\"GET\" class=\"coral-Form coral-Form--vertical\" style=\"width:700px\">");
        out.println("<section class=\"coral-Form-fieldset\">");
        out.println("<span>All the fun takes place on the Publish instance with AEM - please ensure yours is available at the following coordinates</spanl>");
        out.println("<label class=\"coral-Form-fieldlabel\">Path to configuration files</label>");
        out.println("<input is=\"coral-textfield\" name=\"contentPath\" type=\"text\" value=\"" + csvPath + "\" class=\"coral-Form-field coral-Textfield\">");
        out.println("<label class=\"coral-Form-fieldlabel\">Author instance</label>");
        out.println("<div class=\"coral-Form--aligned\">");
        String hostname_author = "localhost";
        String port_author = "4502";
        if (!Hostname.isReachable(hostname_author, port_author)) {
            hostname_author = "";
            port_author = "";
        }
        out.println("<input is=\"coral-textfield\" name=\"hostname_author\" type=\"text\" value=\"" + hostname_author + "\" class=\"coral-Textfield\">");
        out.println("<input is=\"coral-textfield\" name=\"port_author\" type=\"text\" value=\"" + port_author + "\" class=\"coral-Textfield\">");
        out.println("</div>");
        out.println("<label class=\"coral-Form-fieldlabel\">Publish instance</label>");
        String hostname_publish = "localhost";
        String port_publish = "4503";
        if (!Hostname.isReachable(hostname_publish, port_publish)) {
            hostname_publish = "";
            port_publish = "";
            out.println("<coral-alert>");
            out.println("<coral-alert-header>WARNING</coral-alert-header>");
            out.println("<coral-alert-content>Using an AEM Publish instance is strongly recommended. If not using a Publish instance, all UGC will be posted against the Author instance, which might fail if the demo members are not granted appropriate permissions on Author.</coral-alert-content>");
            out.println("</coral-alert>");
        }
        out.println("<div class=\"coral-Form--aligned\">");
        out.println("<input is=\"coral-textfield\" name=\"hostname\" type=\"text\" value=\"" + hostname_publish + "\" class=\"coral-Textfield\">");
        out.println("<input is=\"coral-textfield\" name=\"port\" type=\"text\" value=\"" + port_publish + "\" class=\"coral-Textfield\">");
        out.println("</div>");
        out.println("<label class=\"coral-Form-fieldlabel\">Admin password</label>");
        out.println("<input is=\"coral-textfield\" name=\"password\" type=\"text\" value=\"admin\" class=\"coral-Form-field coral-Textfield\">");
        out.println("<label class=\"coral-Form-fieldlabel\">Please select from the following options</label>");
        int intOptions = 0;
        Resource resConfigFiles = resourceResolver.getResource(csvPath);
        if (!csvPath.equals("") && resConfigFiles != null) {
            ArrayList<String[]> configOptions = new ArrayList<String[]>();
            for (Resource resConfigFile : resConfigFiles.getChildren()) {
                if (resConfigFile == null || !resConfigFile.getName().endsWith(".csv")) continue;
                String[] resConfigSettings = resConfigFile.getName().split("-");
                configOptions.add(resConfigSettings);
            }
            Collections.sort(configOptions, new Comparator<String[]>(){

                @Override
                public int compare(String[] strings, String[] otherStrings) {
                    return strings[0].compareTo(otherStrings[0]);
                }
            });
            for (String[] configOption : configOptions) {
                String title = configOption[2];
                String description = configOption[0] + "-" + configOption[1] + "-" + configOption[2];
                Resource resConfigFile = resourceResolver.getResource(csvPath + "/" + description + "/jcr:content");
                if (resConfigFile != null) {
                    InputStream stream = (InputStream)resConfigFile.adaptTo(InputStream.class);
                    InputStreamReader inConfigFile = new InputStreamReader(stream);
                    CSVParser records = CSVFormat.EXCEL.parse((Reader)inConfigFile);
                    for (CSVRecord record : records) {
                        String rDescription = "# Description: ";
                        if (record.get(0).startsWith(rDescription)) {
                            description = record.get(0).replace(rDescription, "").trim() + " (" + description + ")";
                        }
                        String rTitle = "# Title: ";
                        if (!record.get(0).startsWith(rTitle)) continue;
                        title = record.get(0).replace(rTitle, "").trim();
                    }
                    ++intOptions;
                    try {
                        ((Reader)inConfigFile).close();
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                SetupCommunities.printCheckbox(out, "setup-" + configOption[0], title, description);
            }
        }
        if (intOptions > 0) {
            out.println("<div class=\"coral-Form-fieldwrapper coral-Form-fieldwrapper--alignRight\">");
            out.println("<button class=\"coral-Form-field coral-Button coral-Button--primary\">Submit</button>");
            out.println("</div>");
        } else {
            out.println("<p>No configuration file to process</p>");
        }
        String returnURL = request.getParameter("returnURL");
        if (returnURL != null) {
            out.println("<input type=\"hidden\" name=\"returnURL\" value=\"" + returnURL + "\">");
        }
        out.println("</section></form>");
        out.println("</body></html>");
    }

    private static void printCheckbox(PrintWriter out, String fieldName, String fieldLabel, String fieldTooltip) {
        out.println("<div class=\"coral-Form-fieldwrapper coral-Form-fieldwrapper--singleline\">");
        out.println("<label class=\"coral-Form-field coral-Checkbox\">");
        out.println("<input class=\"coral-Checkbox-input\" type=\"checkbox\" name=\"" + fieldName + "\" checked=\"\">");
        out.println("<span class=\"coral-Checkbox-checkmark\"></span>");
        out.println("<span class=\"coral-Checkbox-description\">" + fieldLabel + "</span>");
        out.println("</label>");
        out.println("<span id=\"coral-Form-Vertical-Checkbox-" + fieldName + "\" class=\"coral-Form-fieldinfo coral-Icon coral-Icon--infoCircle coral-Icon--sizeS\"></span>");
        out.println("<coral-tooltip variant=\"info\" placement=\"right\" target=\"#coral-Form-Vertical-Checkbox-" + fieldName + "\" class=\"coral3-Tooltip coral3-Tooltip--info\" aria-hidden=\"true\" tabindex=\"-1\" role=\"tooltip\" style=\"display: none;\"><coral-tooltip-content>" + fieldTooltip + "</coral-tooltip-content></coral-tooltip>");
        out.println("</div>");
    }
}

