/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.gui.AemDemoDownload;
import com.adobe.aem.demomachine.gui.AemDemoMarquee;
import com.adobe.aem.demomachine.gui.AemDemoNew;
import com.adobe.aem.demomachine.gui.AemDemoOptions;
import com.adobe.aem.demomachine.gui.AemDemoOutputStream;
import com.adobe.aem.demomachine.gui.AemDemoRebuild;
import com.adobe.aem.demomachine.gui.AemDemoUtils;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class AemDemo {
    static Logger logger = Logger.getLogger(AemDemo.class);
    private Properties defaultProperties;
    private Properties personalProperties;
    private static File buildFile;
    private JFrame frameMain;
    private DefaultListModel<String> listModelDemoMachines;
    private JList<String> listDemoMachines;
    private boolean buildInProgress = false;
    private boolean downloadInProgress = false;
    private static String aemDemoMachineVersion;

    public static void main(String[] args) {
        String demoMachineRootFolder = null;
        Options options = new Options();
        options.addOption("f", true, "Path to Demo Machine root folder");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("f")) {
                demoMachineRootFolder = cmd.getOptionValue("f");
            }
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage());
        }
        String mavenFilePath = (demoMachineRootFolder != null ? demoMachineRootFolder : System.getProperty("user.dir")) + File.separator + "java" + File.separator + "core" + File.separator + "pom.xml";
        File mavenFile = new File(mavenFilePath);
        if (mavenFile.exists() && !mavenFile.isDirectory()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(mavenFile);
                NodeList list = document.getElementsByTagName("version");
                if (list != null && list.getLength() > 0) {
                    aemDemoMachineVersion = list.item(0).getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Can't parse Maven pom.xml file");
            }
        }
        String buildFilePath = (demoMachineRootFolder != null ? demoMachineRootFolder : System.getProperty("user.dir")) + File.separator + "build.xml";
        logger.debug((Object)("Trying to load build file from " + buildFilePath));
        buildFile = new File(buildFilePath);
        if (buildFile.exists() && !buildFile.isDirectory()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.getLookAndFeelDefaults().put("defaultFont", new Font("Arial", 1, 14));
                        AemDemo window = new AemDemo();
                        window.frameMain.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            logger.error((Object)"No valid build.xml file to work with");
            System.exit(-1);
        }
    }

    public AemDemo() {
        this.initialize();
    }

    private void initialize() {
        this.setDefaultProperties(AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "build.properties"));
        this.setPersonalProperties(AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties"));
        this.frameMain = new JFrame();
        this.frameMain.setBounds(100, 100, 700, 530);
        this.frameMain.getContentPane().setLayout(null);
        this.frameMain.setDefaultCloseOperation(0);
        this.frameMain.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AemDemo.this.onExit();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu mnAbout = new JMenu("AEM Demo Machine");
        mnAbout.setMnemonic(65);
        menuBar.add(mnAbout);
        JMenuItem mntmUpdates = new JMenuItem("Check for Updates");
        mntmUpdates.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "demo_update");
            }
        });
        mnAbout.add(mntmUpdates);
        JMenuItem mntmDoc = new JMenuItem("Help and Documentation");
        mntmDoc.setAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.openWebpage(AemDemoUtils.getActualPropertyValue(AemDemo.this.defaultProperties, AemDemo.this.personalProperties, "demo.documentation"));
            }
        });
        mnAbout.add(mntmDoc);
        JMenuItem mntmScripts = new JMenuItem("Demo Scripts (VPN)");
        mntmScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.openWebpage(AemDemoUtils.getActualPropertyValue(AemDemo.this.defaultProperties, AemDemo.this.personalProperties, "demo.scripts"));
            }
        });
        mnAbout.add(mntmScripts);
        JMenuItem mntmDiagnostics = new JMenuItem("Diagnostics");
        mntmDiagnostics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map<String, String> env = System.getenv();
                System.out.println("====== System Environment Variables ======");
                for (String envName : env.keySet()) {
                    System.out.format("%s=%s%n", envName, env.get(envName));
                }
                System.out.println("====== JVM Properties ======");
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = runtimeMXBean.getInputArguments();
                for (String arg : jvmArgs) {
                    System.out.println(arg);
                }
                System.out.println("====== Runtime Properties ======");
                Properties props = System.getProperties();
                props.list(System.out);
            }
        });
        mnAbout.add(mntmDiagnostics);
        JMenuItem mntmQuit = new JMenuItem("Quit");
        mntmQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemo.this.onExit();
            }
        });
        mnAbout.add(mntmQuit);
        JMenu mnNew = new JMenu("New");
        menuBar.add(mnNew);
        JMenuItem mntmNewDemo = new JMenuItem("Demo Environment");
        mntmNewDemo.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmNewDemo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AemDemo.this.getBuildInProgress()) {
                    JOptionPane.showMessageDialog(null, "A Demo Environment is currently being built. Please wait until it is finished.");
                } else {
                    AemDemoNew dialogNew = new AemDemoNew(AemDemo.this);
                    dialogNew.setModal(true);
                    dialogNew.setVisible(true);
                    dialogNew.getDemoBuildName().requestFocus();
                }
            }
        });
        mnNew.add(mntmNewDemo);
        JMenuItem mntmNewOptions = new JMenuItem("Demo Properties");
        mntmNewOptions.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmNewOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoOptions dialogOptions = new AemDemoOptions(AemDemo.this);
                dialogOptions.setModal(true);
                dialogOptions.setVisible(true);
            }
        });
        mnNew.add(mntmNewOptions);
        JMenu mnUpdate = new JMenu("Add-ons");
        menuBar.add(mnUpdate);
        JMenu mnSites = new JMenu("Sites");
        mnUpdate.add(mnSites);
        JMenuItem mntmSitesDownloadAddOn = new JMenuItem("Download Demo Add-on");
        mntmSitesDownloadAddOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_sites");
            }
        });
        mnSites.add(mntmSitesDownloadAddOn);
        JMenuItem mntmSitesDownloadFP = new JMenuItem("Download Packages (PackageShare)");
        mntmSitesDownloadFP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_sites_packages");
            }
        });
        mnSites.add(mntmSitesDownloadFP);
        JMenu mnAssets = new JMenu("Assets");
        mnUpdate.add(mnAssets);
        JMenuItem mntmAssetsDownloadAddOn = new JMenuItem("Download Demo Add-on");
        mntmAssetsDownloadAddOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_assets");
            }
        });
        mnAssets.add(mntmAssetsDownloadAddOn);
        JMenuItem mntmAssetsDownloadFP = new JMenuItem("Download Packages (PackageShare)");
        mntmAssetsDownloadFP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_assets_packages");
            }
        });
        mnAssets.add(mntmAssetsDownloadFP);
        JMenu mnCommunities = new JMenu("Communities/Livefyre");
        mnUpdate.add(mnCommunities);
        JMenuItem mntmAemCommunitiesFeaturePacks = new JMenuItem("Download Packages (PackageShare)");
        mntmAemCommunitiesFeaturePacks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_communities_packages");
            }
        });
        mnCommunities.add(mntmAemCommunitiesFeaturePacks);
        JMenu mnForms = new JMenu("Forms");
        mnUpdate.add(mnForms);
        JMenuItem mntmAemFormsAddon = new JMenuItem("Download Demo Add-on");
        mntmAemFormsAddon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_forms");
            }
        });
        mnForms.add(mntmAemFormsAddon);
        JMenuItem mntmAemFormsFP = new JMenuItem("Download Packages (PackageShare)");
        mntmAemFormsFP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_forms_packages");
            }
        });
        mnForms.add(mntmAemFormsFP);
        JMenu mnApps = new JMenu("Mobile");
        mnUpdate.add(mnApps);
        JMenuItem mntmAemAppsAddon = new JMenuItem("Download Demo Add-on");
        mntmAemAppsAddon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_apps");
            }
        });
        mnApps.add(mntmAemAppsAddon);
        JMenuItem mntmAemApps = new JMenuItem("Download Packages (PackageShare)");
        mntmAemApps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_apps_packages");
            }
        });
        mnApps.add(mntmAemApps);
        JMenu mnCommerce = new JMenu("Commerce");
        mnUpdate.add(mnCommerce);
        JMenu mnCommerceDownload = new JMenu("Download Packages");
        mnCommerce.add(mnCommerceDownload);
        JMenuItem mnCommerceDownloadEP = new JMenuItem("ElasticPath (PackageShare)");
        mnCommerceDownloadEP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_commerce_ep");
            }
        });
        mnCommerceDownload.add(mnCommerceDownloadEP);
        JMenuItem mnCommerceDownloadWAS = new JMenuItem("WebSphere (PackageShare)");
        mnCommerceDownloadWAS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_commerce_websphere");
            }
        });
        mnCommerceDownload.add(mnCommerceDownloadWAS);
        JMenu mnWeRetail = new JMenu("We-Retail");
        mnUpdate.add(mnWeRetail);
        JMenuItem mnWeRetailAddon = new JMenuItem("Download Demo Add-on");
        mnWeRetailAddon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_weretail");
            }
        });
        mnWeRetail.add(mnWeRetailAddon);
        mnUpdate.addSeparator();
        JMenuItem mntmAemDownloadAll = new JMenuItem("Download All Add-ons");
        mntmAemDownloadAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_all");
            }
        });
        mnUpdate.add(mntmAemDownloadAll);
        JMenu mnInfrastructure = new JMenu("Infrastructure");
        menuBar.add(mnInfrastructure);
        JMenu mnMongo = new JMenu("MongoDB");
        JMenuItem mntmInfraMongoDB = new JMenuItem("Download");
        mntmInfraMongoDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_mongo");
            }
        });
        mnMongo.add(mntmInfraMongoDB);
        JMenuItem mntmInfraMongoDBInstall = new JMenuItem("Install");
        mntmInfraMongoDBInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "install_mongo");
            }
        });
        mnMongo.add(mntmInfraMongoDBInstall);
        mnMongo.addSeparator();
        JMenuItem mntmInfraMongoDBStart = new JMenuItem("Start");
        mntmInfraMongoDBStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "mongo_start");
            }
        });
        mnMongo.add(mntmInfraMongoDBStart);
        JMenuItem mntmInfraMongoDBStop = new JMenuItem("Stop");
        mntmInfraMongoDBStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "mongo_stop");
            }
        });
        mnMongo.add(mntmInfraMongoDBStop);
        mnInfrastructure.add(mnMongo);
        JMenu mnSOLR = new JMenu("SOLR");
        JMenuItem mntmInfraSOLR = new JMenuItem("Download");
        mntmInfraSOLR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_solr");
            }
        });
        mnSOLR.add(mntmInfraSOLR);
        JMenuItem mntmInfraSOLRInstall = new JMenuItem("Install");
        mntmInfraSOLRInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "install_solr");
            }
        });
        mnSOLR.add(mntmInfraSOLRInstall);
        mnSOLR.addSeparator();
        JMenuItem mntmInfraSOLRStart = new JMenuItem("Start");
        mntmInfraSOLRStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "solr_start");
            }
        });
        mnSOLR.add(mntmInfraSOLRStart);
        JMenuItem mntmInfraSOLRStop = new JMenuItem("Stop");
        mntmInfraSOLRStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "solr_stop");
            }
        });
        mnSOLR.add(mntmInfraSOLRStop);
        mnInfrastructure.add(mnSOLR);
        JMenu mnMySQL = new JMenu("MySQL");
        JMenuItem mntmInfraMysql = new JMenuItem("Download");
        mntmInfraMysql.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_mysql");
            }
        });
        mnMySQL.add(mntmInfraMysql);
        JMenuItem mntmInfraMysqlInstall = new JMenuItem("Install");
        mntmInfraMysqlInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "install_mysql");
            }
        });
        mnMySQL.add(mntmInfraMysqlInstall);
        mnMySQL.addSeparator();
        JMenuItem mntmInfraMysqlStart = new JMenuItem("Start");
        mntmInfraMysqlStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "mysql_start");
            }
        });
        mnMySQL.add(mntmInfraMysqlStart);
        JMenuItem mntmInfraMysqlStop = new JMenuItem("Stop");
        mntmInfraMysqlStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "mysql_stop");
            }
        });
        mnMySQL.add(mntmInfraMysqlStop);
        mnInfrastructure.add(mnMySQL);
        JMenu mnJames = new JMenu("James SMTP/POP");
        JMenuItem mntmInfraJames = new JMenuItem("Download");
        mntmInfraJames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_james");
            }
        });
        mnJames.add(mntmInfraJames);
        JMenuItem mntmInfraJamesInstall = new JMenuItem("Install");
        mntmInfraJamesInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "install_james");
            }
        });
        mnJames.add(mntmInfraJamesInstall);
        mnJames.addSeparator();
        JMenuItem mntmInfraJamesStart = new JMenuItem("Start");
        mntmInfraJamesStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "james_start");
            }
        });
        mnJames.add(mntmInfraJamesStart);
        JMenuItem mntmInfraJamesStop = new JMenuItem("Stop");
        mntmInfraJamesStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "james_stop");
            }
        });
        mnJames.add(mntmInfraJamesStop);
        mnInfrastructure.add(mnJames);
        JMenu mnFFMPEG = new JMenu("FFMPEG");
        JMenuItem mntmInfraFFMPEG = new JMenuItem("Download");
        mntmInfraFFMPEG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_ffmpeg");
            }
        });
        mnFFMPEG.add(mntmInfraFFMPEG);
        JMenuItem mntmInfraFFMPEGInstall = new JMenuItem("Install");
        mntmInfraFFMPEGInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "install_ffmpeg");
            }
        });
        mnFFMPEG.add(mntmInfraFFMPEGInstall);
        mnInfrastructure.add(mnFFMPEG);
        mnInfrastructure.addSeparator();
        JMenu mnInDesignServer = new JMenu("InDesign Server");
        JMenuItem mntmInfraInDesignServerDownload = new JMenuItem("Download");
        mntmInfraInDesignServerDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_indesignserver");
            }
        });
        mnInDesignServer.add(mntmInfraInDesignServerDownload);
        mnInDesignServer.addSeparator();
        JMenuItem mntmInfraInDesignServerStart = new JMenuItem("Start");
        mntmInfraInDesignServerStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "start_indesignserver");
            }
        });
        mnInDesignServer.add(mntmInfraInDesignServerStart);
        JMenuItem mntmInfraInDesignServerStop = new JMenuItem("Stop");
        mntmInfraInDesignServerStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "stop_indesignserver");
            }
        });
        mnInDesignServer.add(mntmInfraInDesignServerStop);
        mnInfrastructure.add(mnInDesignServer);
        mnInfrastructure.addSeparator();
        JMenu mnDocker = new JMenu("Docker");
        menuBar.add(mnDocker);
        JMenuItem mntmDockerListImages = new JMenuItem("List all images");
        mntmDockerListImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "docker_list_images");
            }
        });
        mnDocker.add(mntmDockerListImages);
        JMenuItem mntmDockerListContainers = new JMenuItem("List all containers");
        mntmDockerListContainers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "docker_list_containers");
            }
        });
        mnDocker.add(mntmDockerListContainers);
        JMenuItem mntmDockerRemoveImages = new JMenuItem("Remove all container images");
        mntmDockerRemoveImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "docker_remove_images");
            }
        });
        mnDocker.add(mntmDockerRemoveImages);
        mnInfrastructure.add(mnDocker);
        mnInfrastructure.addSeparator();
        JMenuItem mntmInfraInstall = new JMenuItem("All in One Setup");
        mntmInfraInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "infrastructure");
            }
        });
        mnInfrastructure.add(mntmInfraInstall);
        JMenu mnOther = new JMenu("Other");
        menuBar.add(mnOther);
        JMenu mntmAemDownload = new JMenu("AEM & License files (VPN)");
        JMenuItem mntmAemLoad = new JMenuItem("Download Latest AEM Load");
        mntmAemLoad.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmAemLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_load");
            }
        });
        mntmAemDownload.add(mntmAemLoad);
        JMenuItem mntmAemSnapshot = new JMenuItem("Download Latest AEM Snapshot");
        mntmAemSnapshot.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmAemSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_snapshot");
            }
        });
        mntmAemDownload.add(mntmAemSnapshot);
        JMenuItem mntmAemDownloadAEM63 = new JMenuItem("Download AEM 6.3");
        mntmAemDownloadAEM63.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_aem63");
            }
        });
        mntmAemDownload.add(mntmAemDownloadAEM63);
        JMenuItem mntmAemDownloadAEM62 = new JMenuItem("Download AEM 6.2");
        mntmAemDownloadAEM62.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_aem62");
            }
        });
        mntmAemDownload.add(mntmAemDownloadAEM62);
        JMenuItem mntmAemDownloadAEM61 = new JMenuItem("Download AEM 6.1");
        mntmAemDownloadAEM61.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_aem61");
            }
        });
        mntmAemDownload.add(mntmAemDownloadAEM61);
        JMenuItem mntmAemDownloadAEM60 = new JMenuItem("Download AEM 6.0");
        mntmAemDownloadAEM60.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_aem60");
            }
        });
        mntmAemDownload.add(mntmAemDownloadAEM60);
        JMenuItem mntmAemDownloadCQ561 = new JMenuItem("Download CQ 5.6.1");
        mntmAemDownloadCQ561.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_cq561");
            }
        });
        mntmAemDownload.add(mntmAemDownloadCQ561);
        JMenuItem mntmAemDownloadCQ56 = new JMenuItem("Download CQ 5.6");
        mntmAemDownloadCQ56.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_cq56");
            }
        });
        mntmAemDownload.add(mntmAemDownloadCQ56);
        JMenuItem mntmAemDownloadOthers = new JMenuItem("Other Releases & License files");
        mntmAemDownloadOthers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.openWebpage(AemDemoUtils.getActualPropertyValue(AemDemo.this.defaultProperties, AemDemo.this.personalProperties, "demo.download"));
            }
        });
        mntmAemDownload.add(mntmAemDownloadOthers);
        mnOther.add(mntmAemDownload);
        JMenuItem mntmAemHotfix = new JMenuItem("Download Latest Hotfixes (PackageShare)");
        mntmAemHotfix.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmAemHotfix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_hotfixes_packages");
            }
        });
        mnOther.add(mntmAemHotfix);
        JMenuItem mntmAemAcs = new JMenuItem("Download Latest ACS Commons and Tools");
        mntmAemAcs.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmAemAcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "download_acs");
            }
        });
        mnOther.add(mntmAemAcs);
        this.frameMain.setJMenuBar(menuBar);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(24, 163, 650, 230);
        this.frameMain.getContentPane().add(scrollPane);
        final JTextArea textArea = new JTextArea("");
        textArea.setEditable(false);
        scrollPane.setViewportView(textArea);
        JScrollPane scrollDemoList = new JScrollPane();
        scrollDemoList.setBounds(24, 34, 208, 100);
        this.frameMain.getContentPane().add(scrollDemoList);
        this.listModelDemoMachines = AemDemoUtils.listDemoMachines(buildFile.getParentFile().getAbsolutePath());
        this.listDemoMachines = new JList<String>(this.listModelDemoMachines);
        this.listDemoMachines.setSelectionMode(0);
        this.listDemoMachines.setSelectedIndex(AemDemoUtils.getSelectedIndex(this.listDemoMachines, this.getDefaultProperties(), this.getPersonalProperties(), "demo.build"));
        scrollDemoList.setViewportView(this.listDemoMachines);
        AemDemoOutputStream out = new AemDemoOutputStream(textArea);
        System.setOut(new PrintStream(out));
        JButton btnStart = new JButton("Start");
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "start");
            }
        });
        btnStart.setBounds(250, 29, 117, 29);
        this.frameMain.getContentPane().add(btnStart);
        JRootPane rootPane = SwingUtilities.getRootPane(btnStart);
        rootPane.setDefaultButton(btnStart);
        JButton btnInfo = new JButton("Details");
        btnInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "details");
            }
        });
        btnInfo.setBounds(250, 59, 117, 29);
        this.frameMain.getContentPane().add(btnInfo);
        JButton btnRebuild = new JButton("Rebuild");
        btnRebuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AemDemo.this.getBuildInProgress()) {
                    JOptionPane.showMessageDialog(null, "A Demo Environment is currently being built. Please wait until it is finished.");
                } else {
                    AemDemoRebuild dialogRebuild = new AemDemoRebuild(AemDemo.this);
                    dialogRebuild.setModal(true);
                    dialogRebuild.setVisible(true);
                    dialogRebuild.getDemoBuildName().requestFocus();
                }
            }
        });
        btnRebuild.setBounds(250, 89, 117, 29);
        this.frameMain.getContentPane().add(btnRebuild);
        JButton btnStop = new JButton("Stop");
        btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogResult = JOptionPane.showConfirmDialog(null, "Are you sure you really want to stop the running instances?", "Warning", 0);
                if (dialogResult == 1) {
                    return;
                }
                AemDemoUtils.antTarget(AemDemo.this, "stop");
            }
        });
        btnStop.setBounds(375, 29, 117, 29);
        this.frameMain.getContentPane().add(btnStop);
        JButton btnKill = new JButton("Kill");
        btnKill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogResult = JOptionPane.showConfirmDialog(null, "Are you sure you really want to kill the running instances? This might leave your AEM instances in unstable state.", "Warning", 0);
                if (dialogResult == 1) {
                    return;
                }
                AemDemoUtils.antTarget(AemDemo.this, "kill");
            }
        });
        btnKill.setBounds(500, 29, 117, 29);
        this.frameMain.getContentPane().add(btnKill);
        JButton btnExit = new JButton("Exit");
        btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemo.this.onExit();
            }
        });
        btnExit.setBounds(550, 408, 117, 29);
        this.frameMain.getContentPane().add(btnExit);
        JButton btnClear = new JButton("Clear");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.setText("");
            }
        });
        btnClear.setBounds(40, 408, 117, 29);
        this.frameMain.getContentPane().add(btnClear);
        JButton btnBackup = new JButton("Backup");
        btnBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "backup");
            }
        });
        btnBackup.setBounds(500, 59, 117, 29);
        this.frameMain.getContentPane().add(btnBackup);
        JButton btnRestore = new JButton("Restore");
        btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoUtils.antTarget(AemDemo.this, "restore");
            }
        });
        btnRestore.setBounds(500, 89, 117, 29);
        this.frameMain.getContentPane().add(btnRestore);
        JButton btnDelete = new JButton("Delete");
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogResult = JOptionPane.showConfirmDialog(null, "Are you sure you really want to permanently delete the selected demo configuration?", "Warning", 0);
                if (dialogResult == 1) {
                    return;
                }
                AemDemoUtils.antTarget(AemDemo.this, "uninstall");
            }
        });
        btnDelete.setBounds(500, 119, 117, 29);
        this.frameMain.getContentPane().add(btnDelete);
        JLabel lblSelectYourDemo = new JLabel("Select your Demo Environment");
        lblSelectYourDemo.setBounds(24, 10, 219, 16);
        this.frameMain.getContentPane().add(lblSelectYourDemo);
        JLabel lblCommandOutput = new JLabel("Command Output");
        lblCommandOutput.setBounds(24, 143, 160, 16);
        this.frameMain.getContentPane().add(lblCommandOutput);
        String tickerOn = AemDemoUtils.getPropertyValue(buildFile, "demo.ticker");
        if (tickerOn == null || tickerOn != null && tickerOn.equals("true")) {
            AemDemoMarquee mp = new AemDemoMarquee("Welcome to the AEM Demo Machine! Everyone knows there isn't any good demo without a bouncing scrolltext... The AEM Demo Machine is an OpenSource project. You are welcome to contribute as did the people listed later. Don't forget to \"git pull\" the latest changes often. Also make sure to check the latest updates to the Wiki documentation at https://github.com/Adobe-Marketing-Cloud/aem-demo-machine/wiki . Many thanks to the following people for contributing, one way or the other, to the AEM Demo Machine: Gerd Handke, Cedric Huesler, Greg Klebus, Gabriel Walt, Mathias Siegel, Martin Buergi, Scott Date, Randah McKinnie, Don Walling, Abhinav Chakravarty, Nikhil Vasudeva, Chris Gatihi, Michael Marth, Mark Szulc, Kyle Chau, Marcel Boucher, Michael Point, Brandon Tan, Raul Ugarte, Christophe Loffler, Samuel Blin, Sethu Iyer, Mark Frazer. Designed and built with all the love in the world by @bdecoatpont. Copyright - well, there's actually no copyright. Let's wrap and happy AEM demoing!", 60);
            mp.setBounds(140, 440, 650, 30);
            this.frameMain.getContentPane().add(mp);
            mp.start();
        }
        AemDemoDownload aemDownload = new AemDemoDownload(this);
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(aemDownload, 0L, 5L, TimeUnit.SECONDS);
        String line = null;
        try {
            FileReader fileReader = new FileReader(buildFile.getParentFile().getAbsolutePath() + File.separator + "README.md");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.indexOf("AEM Demo Machine!") > 0) {
                    line = line + " (version: " + aemDemoMachineVersion + ")";
                }
                if (line.startsWith("Double")) continue;
                System.out.println(line);
            }
            bufferedReader.close();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public Properties getPersonalProperties() {
        return this.personalProperties;
    }

    public void setPersonalProperties(Properties personalProperties) {
        this.personalProperties = personalProperties;
    }

    public File getBuildFile() {
        return buildFile;
    }

    public void setBuildFile(File buildFile) {
        AemDemo.buildFile = buildFile;
    }

    public boolean getBuildInProgress() {
        return this.buildInProgress;
    }

    public void setBuildInProgress(boolean buildInProgress) {
        this.buildInProgress = buildInProgress;
    }

    public boolean getDownloadInProgress() {
        return this.downloadInProgress;
    }

    public void setDownloadInProgress(boolean downloadInProgress) {
        this.downloadInProgress = downloadInProgress;
    }

    public DefaultListModel<String> getListModelDemoMachines() {
        return this.listModelDemoMachines;
    }

    public JList<String> getListDemoMachines() {
        return this.listDemoMachines;
    }

    public String getSelectedDemoMachine() {
        return this.listDemoMachines.getSelectedValue();
    }

    public void onExit() {
        System.exit(0);
    }

    static {
        aemDemoMachineVersion = "Unknown";
    }
}

