/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.gui.AemDemo;
import com.adobe.aem.demomachine.gui.AemDemoUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class AemDemoDownload
implements Runnable {
    private AemDemo aemDemo;
    private long currentSize;

    public AemDemoDownload(AemDemo aemDemo) {
        this.aemDemo = aemDemo;
    }

    @Override
    public void run() {
        if (this.aemDemo.getDownloadInProgress()) {
            WildcardFileFilter fileFilter;
            File[] files;
            File theNewestFile = null;
            File dir = new File(this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "dist" + File.separator + "downloads");
            if (dir != null && dir.exists() && (files = dir.listFiles((FileFilter)(fileFilter = new WildcardFileFilter("*.*")))).length > 0) {
                Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
                theNewestFile = files[0];
                long newSize = theNewestFile.length();
                if (newSize != this.currentSize && theNewestFile.getName().indexOf("xml") < 0 && theNewestFile.getName().indexOf("html") < 0 && theNewestFile.lastModified() > System.currentTimeMillis() - 5000L) {
                    System.out.println("     [echo] " + theNewestFile.getName() + " (" + AemDemoUtils.humanReadableByteCount(theNewestFile.length(), true) + ")");
                    this.currentSize = newSize;
                }
            }
        }
    }
}

