/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.gui.AemDemo;
import com.adobe.aem.demomachine.gui.AemDemoProject;
import com.adobe.aem.demomachine.gui.AemDemoProperty;
import com.adobe.aem.demomachine.gui.AemDemoRunnable;
import com.adobe.aem.demomachine.gui.AemDemoUtils;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AemDemoNew
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField demoBuildName;
    private JList listConfigs;
    private JList listTopologies;
    private JList listSRP;
    private JList listAemJars;
    private JList listMK;
    private AemDemo aemDemo;
    static Logger logger = Logger.getLogger(AemDemoNew.class);

    public AemDemoNew(AemDemo aemDemoInput) {
        AemDemoProperty[] aemJars;
        this.aemDemo = aemDemoInput;
        boolean validConfiguration = true;
        ArrayList<String> validationErrors = new ArrayList<String>();
        String licenseFileName = "license-" + this.aemDemo.getDefaultProperties().getProperty("demo.license") + ".properties";
        File licenseFile = new File(this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "dist" + File.separator + "license" + File.separator + licenseFileName);
        if (!licenseFile.exists()) {
            validationErrors.add("Please add a valid AEM license file named " + licenseFileName + " in the ${demohome}/dist/license folder");
            validConfiguration = false;
        }
        if ((aemJars = AemDemoUtils.listAEMjars(this.aemDemo.getBuildFile())).length == 0) {
            validationErrors.add("Please add a valid AEM/CQ .jar file in the ${demohome}/dist/bin folder");
            validConfiguration = false;
        }
        if (validConfiguration) {
            this.setBounds(150, 150, 660, 340);
            this.getContentPane().setLayout(null);
            this.contentPanel.setBounds(0, 0, 660, 340);
            this.getContentPane().add(this.contentPanel);
            this.contentPanel.setLayout(null);
            JLabel lblSelectADemo = new JLabel("Select demo add-on(s)");
            lblSelectADemo.setBounds(20, 20, 148, 16);
            this.contentPanel.add(lblSelectADemo);
            JLabel lblSelectMultiple = new JLabel("Use Command/CTRL key for multiple add-ons. (*) indicates that the add-on needs to be downloaded.");
            lblSelectMultiple.setFont(new Font("Serif", 2, 10));
            lblSelectMultiple.setBounds(20, 20, 600, 416);
            this.contentPanel.add(lblSelectMultiple);
            JScrollPane scrollConfigs = new JScrollPane();
            scrollConfigs.setBounds(20, 45, 140, 175);
            this.contentPanel.add(scrollConfigs);
            AemDemoProperty[] aemConfigs = AemDemoUtils.listDemoAddons(this.aemDemo.getBuildFile());
            this.listConfigs = new JList<AemDemoProperty>(aemConfigs);
            this.listConfigs.setSelectionMode(2);
            this.listConfigs.setSelectedIndices(AemDemoUtils.getDemoAddons(this.aemDemo.getBuildFile()));
            scrollConfigs.setViewportView(this.listConfigs);
            JLabel lblEnterAName = new JLabel("Select a topology");
            lblEnterAName.setBounds(175, 20, 124, 16);
            this.contentPanel.add(lblEnterAName);
            JScrollPane scrollTopologies = new JScrollPane();
            scrollTopologies.setBounds(175, 45, 140, 175);
            this.contentPanel.add(scrollTopologies);
            AemDemoProperty[] aemTopologies = AemDemoUtils.listTopologies(this.aemDemo.getBuildFile());
            this.listTopologies = new JList<AemDemoProperty>(aemTopologies);
            this.listTopologies.setSelectionMode(0);
            this.listTopologies.setSelectedIndex(AemDemoUtils.getSelectedIndex(this.listTopologies, this.aemDemo.getDefaultProperties(), this.aemDemo.getPersonalProperties(), "demo.type"));
            scrollTopologies.setViewportView(this.listTopologies);
            JLabel lblSelectAMk = new JLabel("Select an AEM/CQ .jar");
            lblSelectAMk.setBounds(331, 20, 139, 16);
            this.contentPanel.add(lblSelectAMk);
            JScrollPane scrollAemJars = new JScrollPane();
            scrollAemJars.setBounds(330, 45, 140, 175);
            this.contentPanel.add(scrollAemJars);
            this.listAemJars = new JList<AemDemoProperty>(aemJars);
            this.listAemJars.setSelectionMode(0);
            this.listAemJars.setSelectedIndex(AemDemoUtils.getSelectedIndex(this.listAemJars, this.aemDemo.getDefaultProperties(), this.aemDemo.getPersonalProperties(), "demo.jar"));
            scrollAemJars.setViewportView(this.listAemJars);
            JLabel lblPersistence = new JLabel("Micro-Kernel");
            lblPersistence.setBounds(500, 20, 118, 16);
            this.contentPanel.add(lblPersistence);
            JScrollPane scrollMK = new JScrollPane();
            scrollMK.setBounds(500, 45, 140, 80);
            this.contentPanel.add(scrollMK);
            AemDemoProperty[] aemMKs = AemDemoUtils.listMKs(this.aemDemo.getBuildFile());
            this.listMK = new JList<AemDemoProperty>(aemMKs);
            this.listMK.setSelectionMode(0);
            this.listMK.setSelectedIndex(AemDemoUtils.getSelectedIndex(this.listMK, this.aemDemo.getDefaultProperties(), this.aemDemo.getPersonalProperties(), "demo.store"));
            scrollMK.setViewportView(this.listMK);
            JLabel lblCommunityPersistence = new JLabel("Communities");
            lblCommunityPersistence.setBounds(500, 135, 118, 16);
            this.contentPanel.add(lblCommunityPersistence);
            JScrollPane scrollSRP = new JScrollPane();
            scrollSRP.setBounds(500, 160, 140, 60);
            this.contentPanel.add(scrollSRP);
            AemDemoProperty[] aemSRPs = AemDemoUtils.listSRPs(this.aemDemo.getBuildFile());
            this.listSRP = new JList<AemDemoProperty>(aemSRPs);
            this.listSRP.setSelectionMode(0);
            this.listSRP.setSelectedIndex(AemDemoUtils.getSelectedIndex(this.listSRP, this.aemDemo.getDefaultProperties(), this.aemDemo.getPersonalProperties(), "demo.srp"));
            scrollSRP.setViewportView(this.listSRP);
            JLabel lblDemoName = new JLabel("Enter a name for your demo environment");
            lblDemoName.setBounds(20, 240, 279, 16);
            this.contentPanel.add(lblDemoName);
            this.demoBuildName = new JTextField(AemDemoUtils.getActualPropertyValue(this.aemDemo.getDefaultProperties(), this.aemDemo.getPersonalProperties(), "demo.build"));
            this.demoBuildName.setBounds(295, 235, 345, 28);
            this.contentPanel.add(this.demoBuildName);
            this.demoBuildName.setColumns(10);
            JButton createButton = new JButton("Create");
            createButton.setBounds(220, 275, 100, 30);
            createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int dialogResult;
                    int index;
                    AemDemoProperty selectedSRP = (AemDemoProperty)AemDemoNew.this.listSRP.getModel().getElementAt(AemDemoNew.this.listSRP.getSelectedIndex());
                    AemDemoProperty selectedMK = (AemDemoProperty)AemDemoNew.this.listMK.getModel().getElementAt(AemDemoNew.this.listMK.getSelectedIndex());
                    AemDemoProperty selectedTopology = (AemDemoProperty)AemDemoNew.this.listTopologies.getModel().getElementAt(AemDemoNew.this.listTopologies.getSelectedIndex());
                    AemDemoProperty selectedJar = (AemDemoProperty)AemDemoNew.this.listAemJars.getModel().getElementAt(AemDemoNew.this.listAemJars.getSelectedIndex());
                    List selectedAddOns = AemDemoNew.this.listConfigs.getSelectedValuesList();
                    if (!AemDemoNew.this.demoBuildName.getText().matches("[a-zA-Z0-9]+")) {
                        JOptionPane.showMessageDialog(null, "Please use alphanumeric characters only for your demo configuration");
                        return;
                    }
                    if (AemDemoNew.this.aemDemo.getListDemoMachines().getModel().getSize() > 0 && (index = AemDemoNew.this.aemDemo.getListDemoMachines().getNextMatch(AemDemoNew.this.demoBuildName.getText(), 0, Position.Bias.Forward)) != -1 && (dialogResult = JOptionPane.showConfirmDialog(null, "There's already a demo environmnent with the same name, do you really want to replace it?", "Warning", 0)) == 1) {
                        return;
                    }
                    File demobuild = new File(AemDemoNew.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "demos" + File.separator + AemDemoNew.this.demoBuildName.getText() + File.separator + "demobuild.properties");
                    if (demobuild != null && demobuild.exists() && demobuild.delete()) {
                        System.out.println("Existing demobuild.properties deleted since it's a fresh install");
                    }
                    AemDemoProject p = new AemDemoProject(AemDemoNew.this.aemDemo);
                    p.setUserProperty("demo.jar", selectedJar.getValue());
                    p.setUserProperty("demo.srp", selectedSRP.getValue());
                    p.setUserProperty("demo.store", selectedMK.getValue());
                    p.setUserProperty("demo.type", selectedTopology.getValue());
                    p.setUserProperty("demo.build", AemDemoNew.this.demoBuildName.getText());
                    AemDemoProperty[] aemConfigs = AemDemoUtils.listDemoAddons(AemDemoNew.this.aemDemo.getBuildFile());
                    for (int i = 0; i < aemConfigs.length; ++i) {
                        if (selectedAddOns.contains(aemConfigs[i])) {
                            p.setUserProperty("demo.addons." + (i + 1) + "." + aemConfigs[i].getValue(), "true");
                            continue;
                        }
                        p.setUserProperty("demo.addons." + (i + 1) + "." + aemConfigs[i].getValue(), "false");
                    }
                    try {
                        p.setUserProperty("demo.hostname", InetAddress.getLocalHost().getHostName());
                    }
                    catch (UnknownHostException ex) {
                        logger.error((Object)ex.getMessage());
                    }
                    p.init();
                    ProjectHelper helper = ProjectHelper.getProjectHelper();
                    p.addReference("ant.projectHelper", helper);
                    helper.parse((Project)p, (Object)AemDemoNew.this.aemDemo.getBuildFile());
                    System.out.println("Building a new " + selectedTopology.getValue() + " demo named " + AemDemoNew.this.demoBuildName.getText());
                    Thread t = new Thread(new AemDemoRunnable(AemDemoNew.this.aemDemo, p, "create"));
                    t.start();
                    AemDemoNew.this.dispose();
                }
            });
            this.contentPanel.add(createButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setBounds(340, 275, 100, 30);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AemDemoNew.this.dispose();
                }
            });
            this.contentPanel.add(cancelButton);
            JRootPane rootPane = SwingUtilities.getRootPane(createButton);
            rootPane.setDefaultButton(createButton);
        } else {
            this.setBounds(150, 150, 760, 340);
            this.getContentPane().setLayout(null);
            this.contentPanel.setBounds(0, 0, 760, 340);
            this.getContentPane().add(this.contentPanel);
            this.contentPanel.setLayout(null);
            JLabel lblSelectADemo = new JLabel("There are validation errors!");
            lblSelectADemo.setBounds(20, 20, 620, 16);
            this.contentPanel.add(lblSelectADemo);
            int pos = 60;
            for (String errorMsg : validationErrors) {
                JLabel lblError = new JLabel(errorMsg);
                lblError.setBounds(20, pos, 720, 16);
                this.contentPanel.add(lblError);
                pos += 40;
            }
            JButton closeButton = new JButton("Close");
            closeButton.setBounds(20, 260, 60, 30);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AemDemoNew.this.dispose();
                }
            });
            this.contentPanel.add(closeButton);
        }
        AemDemoUtils.installEscapeCloseOperation(this);
    }

    public JTextField getDemoBuildName() {
        return this.demoBuildName;
    }
}

