/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.CypherUtils;
import com.adobe.aem.demomachine.gui.AemDemo;
import com.adobe.aem.demomachine.gui.AemDemoUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class AemDemoOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private final JTable table;
    private AemDemo aemDemo;
    static Logger logger = Logger.getLogger(AemDemoOptions.class);

    public AemDemoOptions(AemDemo aemDemoInput) {
        this.aemDemo = aemDemoInput;
        this.setBounds(150, 150, 960, 600);
        this.getContentPane().setLayout(null);
        this.contentPanel.setBounds(0, 0, 960, 600);
        this.getContentPane().add(this.contentPanel);
        this.contentPanel.setLayout(null);
        Enumeration<Object> e = this.aemDemo.getDefaultProperties().keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.endsWith(".help") || key.startsWith("demo.download.") && !key.contains("artifactory")) continue;
            ++i;
        }
        Object[][] props = new Object[i][4];
        e = this.aemDemo.getDefaultProperties().keys();
        i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.endsWith(".help") || key.startsWith("demo.download.") && !key.contains("artifactory")) continue;
            String value = this.aemDemo.getDefaultProperties().getProperty(key);
            Object[] prop = new Object[5];
            prop[0] = this.aemDemo.getPersonalProperties().containsKey(key) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            prop[1] = key;
            Object object = prop[2] = key.contains("password") ? "******" : value;
            if (this.aemDemo.getPersonalProperties().containsKey(key)) {
                String personalValue = this.aemDemo.getPersonalProperties().getProperty(key);
                prop[3] = key.contains("password") ? "******" : personalValue;
            } else {
                prop[3] = "";
            }
            prop[4] = this.aemDemo.getDefaultProperties().containsKey(key + ".help") ? this.aemDemo.getDefaultProperties().getProperty(key + ".help") : "";
            props[i++] = prop;
        }
        Object[] columnNames = new Object[]{"Override", "Name", "Default Value", "Custom Value", "Description"};
        DefaultTableModel model = new DefaultTableModel(props, columnNames);
        this.table = new JTable(model){

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return String.class;
                    }
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0 || column == 3 || column == 4;
            }
        };
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 3) {
                    String value = (String)AemDemoOptions.this.table.getModel().getValueAt(e.getLastRow(), e.getColumn());
                    if (value.equals("")) {
                        AemDemoOptions.this.table.getModel().setValueAt(false, e.getLastRow(), 0);
                    } else {
                        AemDemoOptions.this.table.getModel().setValueAt(true, e.getLastRow(), 0);
                    }
                }
            }
        });
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().toggleSortOrder(1);
        this.table.setAutoResizeMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(240);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(350);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBounds(20, 20, 910, 500);
        this.contentPanel.add(scrollPane);
        JButton applyButton = new JButton("Apply");
        applyButton.setBounds(700, 535, 100, 30);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoOptions.this.aemDemo.setPersonalProperties(AemDemoOptions.this.savePersonalProperties());
                AemDemoOptions.this.dispose();
            }
        });
        this.contentPanel.add(applyButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setBounds(820, 535, 100, 30);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AemDemoOptions.this.dispose();
            }
        });
        this.contentPanel.add(cancelButton);
        JRootPane rootPane = SwingUtilities.getRootPane(applyButton);
        rootPane.setDefaultButton(applyButton);
        JButton saveButton = new JButton("Save");
        saveButton.setBounds(20, 535, 100, 30);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File personalConf = new File(AemDemoOptions.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
                File personalBackup = new File(AemDemoOptions.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal." + System.currentTimeMillis() + ".properties");
                if (personalConf.exists()) {
                    personalConf.renameTo(personalBackup);
                }
                File newPersonalConf = new File(AemDemoOptions.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
                try {
                    AemDemoOptions.this.aemDemo.setPersonalProperties(AemDemoOptions.this.savePersonalProperties());
                    Properties tmpProperties = new Properties(){

                        @Override
                        public synchronized Enumeration<Object> keys() {
                            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                        }
                    };
                    tmpProperties.putAll((Map<?, ?>)AemDemoOptions.this.aemDemo.getPersonalProperties());
                    tmpProperties.store(new FileOutputStream(newPersonalConf), null);
                    JOptionPane.showMessageDialog(null, "Personal properties saved as /conf/build-personal.properties");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Error when saving personal properties");
                }
            }
        });
        this.contentPanel.add(saveButton);
        JButton restoreButton = new JButton("Restore");
        restoreButton.setBounds(140, 535, 100, 30);
        restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File personalConf = new File(AemDemoOptions.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
                if (personalConf.exists()) {
                    AemDemoOptions.this.aemDemo.setPersonalProperties(AemDemoUtils.loadProperties(AemDemoOptions.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties"));
                    JOptionPane.showMessageDialog(null, "Personal properties restored from /conf/build-personal.properties");
                    AemDemoOptions.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(null, "Problem when restoring personal properties from /conf/build-personal.properties");
                }
            }
        });
        this.contentPanel.add(restoreButton);
        JButton loadButton = new JButton("Load");
        loadButton.setBounds(260, 535, 100, 30);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(AemDemoOptions.this.aemDemo.getBuildFile());
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Properties", "props", "properties");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(AemDemoOptions.this);
                if (returnVal == 0) {
                    Properties mergeProps = AemDemoUtils.loadProperties(chooser.getSelectedFile().getAbsolutePath());
                    Enumeration<?> currentProp = mergeProps.propertyNames();
                    while (currentProp.hasMoreElements()) {
                        String key = (String)currentProp.nextElement();
                        String value = mergeProps.getProperty(key);
                        for (int i = 0; i < AemDemoOptions.this.table.getRowCount(); ++i) {
                            if (!AemDemoOptions.this.table.getModel().getValueAt(i, 1).equals(key)) continue;
                            AemDemoOptions.this.table.getModel().setValueAt(value, i, 3);
                            AemDemoOptions.this.table.getModel().setValueAt(true, i, 0);
                        }
                    }
                    AemDemoOptions.this.aemDemo.setPersonalProperties(AemDemoOptions.this.savePersonalProperties());
                }
            }
        });
        this.contentPanel.add(loadButton);
        JButton oneclickButton = new JButton("1-Click Setup (VPN)");
        oneclickButton.setBounds(380, 535, 170, 30);
        oneclickButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogResult = JOptionPane.showConfirmDialog(null, "Are you sure you really want to load the default Adobe-only demo properties?\nThis might override some of your existing values.\nA backup file of /conf/build-personal.properties will be created.", "Warning", 0);
                if (dialogResult == 1) {
                    return;
                }
                StringBuffer cryptedContent = new StringBuffer("");
                try {
                    String line;
                    URL url = new URL("http://aem-communities-demo.corp.adobe.com/properties/build-mac.properties.encrypted");
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((line = in.readLine()) != null) {
                        cryptedContent.append(line);
                    }
                    in.close();
                    logger.info((Object)cryptedContent);
                    String decryptedContent = CypherUtils.decrypt(cryptedContent.toString(), "adobevpn");
                    logger.info((Object)decryptedContent);
                    Properties mergeProps = AemDemoOptions.this.parsePropertiesString(decryptedContent);
                    Enumeration<?> currentProp = mergeProps.propertyNames();
                    while (currentProp.hasMoreElements()) {
                        String key = (String)currentProp.nextElement();
                        String value = mergeProps.getProperty(key);
                        for (int i = 0; i < AemDemoOptions.this.table.getRowCount(); ++i) {
                            if (!AemDemoOptions.this.table.getModel().getValueAt(i, 1).equals(key)) continue;
                            AemDemoOptions.this.table.getModel().setValueAt(value, i, 3);
                            AemDemoOptions.this.table.getModel().setValueAt(true, i, 0);
                        }
                    }
                    AemDemoOptions.this.aemDemo.setPersonalProperties(AemDemoOptions.this.savePersonalProperties());
                }
                catch (MalformedURLException ex) {
                    logger.error((Object)("Malformed URL: " + ex.getMessage()));
                }
                catch (IOException ex) {
                    logger.error((Object)("I/O Error: " + ex.getMessage()));
                    JOptionPane.showMessageDialog(null, "Problem when loading the properties - make sure you are logged into the Adobe VPN and retry");
                }
            }
        });
        this.contentPanel.add(oneclickButton);
        AemDemoUtils.installEscapeCloseOperation(this);
    }

    private Properties savePersonalProperties() {
        Properties newPersonalProperties = new Properties();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String customValue;
            if (!((Boolean)this.table.getModel().getValueAt(i, 0)).booleanValue() || (customValue = (String)this.table.getModel().getValueAt(i, 3)) == null || customValue.length() <= 0) continue;
            String propertyKey = (String)this.table.getModel().getValueAt(i, 1);
            if (!customValue.equals("******")) {
                newPersonalProperties.setProperty(propertyKey, customValue);
                continue;
            }
            newPersonalProperties.setProperty(propertyKey, this.aemDemo.getPersonalProperties().getProperty(propertyKey));
        }
        return newPersonalProperties;
    }

    public Properties parsePropertiesString(String s) {
        Properties p = new Properties();
        try {
            p.load(new StringReader(s));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return p;
    }
}

