/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class AemDemoOutputStream
extends OutputStream {
    private final JTextArea destination;

    public AemDemoOutputStream(JTextArea destination) {
        if (destination == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        this.destination = destination;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        final String text = new String(buffer, offset, length);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AemDemoOutputStream.this.destination.append(text.replaceAll("\\[echo\\]", ""));
            }
        });
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public static void main(String[] args) throws Exception {
        JTextArea textArea = new JTextArea(25, 80);
        textArea.setEditable(false);
        JFrame frame = new JFrame("stdout");
        frame.setDefaultCloseOperation(3);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JScrollPane(textArea, 22, 30), "Center");
        frame.pack();
        frame.setVisible(true);
        AemDemoOutputStream out = new AemDemoOutputStream(textArea);
        System.setOut(new PrintStream(out));
        while (true) {
            System.out.println("Current time: " + System.currentTimeMillis());
            Thread.sleep(1000L);
        }
    }
}

