/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.gui.AemDemo;
import com.adobe.aem.demomachine.gui.AemDemoProject;
import com.adobe.aem.demomachine.gui.AemDemoRunnable;
import com.adobe.aem.demomachine.gui.AemDemoUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AemDemoRebuild
extends JDialog {
    private static final long serialVersionUID = 2875921849130484734L;
    private final JPanel contentPanel = new JPanel();
    private JTextField demoBuildName;
    private AemDemo aemDemo;
    private String demoMachine;
    static Logger logger = Logger.getLogger(AemDemoRebuild.class);

    public AemDemoRebuild(AemDemo aemDemoInput) {
        File rebuildProperties;
        this.aemDemo = aemDemoInput;
        boolean validation = true;
        ArrayList<String> validationErrors = new ArrayList<String>();
        this.demoMachine = aemDemoInput.getSelectedDemoMachine();
        if (this.demoMachine == null) {
            validationErrors.add("Please select an existing Demo Environment!");
            validation = false;
        }
        if (!(rebuildProperties = new File(this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "demos" + File.separator + this.demoMachine + File.separator + "demobuild.properties")).exists()) {
            validationErrors.add("This demo environment cannot be rebuilt because of a missing property file:");
            validationErrors.add(rebuildProperties.getAbsolutePath());
            validation = false;
        }
        if (validation) {
            this.setBounds(150, 150, 660, 200);
            this.getContentPane().setLayout(null);
            this.contentPanel.setBounds(0, 0, 660, 200);
            this.getContentPane().add(this.contentPanel);
            this.contentPanel.setLayout(null);
            JLabel lblSelectADemo = new JLabel("You're going to rebuild a demo environment with the exact same properties");
            lblSelectADemo.setBounds(20, 20, 600, 16);
            this.contentPanel.add(lblSelectADemo);
            JLabel lblDemoName = new JLabel("Enter the  name for your demo environment:");
            lblDemoName.setBounds(20, 50, 600, 16);
            this.contentPanel.add(lblDemoName);
            this.demoBuildName = new JTextField(this.demoMachine);
            this.demoBuildName.setBounds(20, 80, 345, 28);
            this.contentPanel.add(this.demoBuildName);
            this.demoBuildName.setColumns(10);
            JButton createButton = new JButton("Rebuild");
            createButton.setBounds(220, 120, 100, 30);
            createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int dialogResult;
                    int index;
                    if (!AemDemoRebuild.this.demoBuildName.getText().matches("[a-zA-Z0-9]+")) {
                        JOptionPane.showMessageDialog(null, "Please use alphanumeric characters only for your demo configuration");
                        return;
                    }
                    if (AemDemoRebuild.this.aemDemo.getListDemoMachines().getModel().getSize() > 0 && (index = AemDemoRebuild.this.aemDemo.getListDemoMachines().getNextMatch(AemDemoRebuild.this.demoBuildName.getText(), 0, Position.Bias.Forward)) != -1 && (dialogResult = JOptionPane.showConfirmDialog(null, "There's already a demo environmnent with the same name, do you really want to replace it?", "Warning", 0)) == 1) {
                        return;
                    }
                    AemDemoProject p = new AemDemoProject(AemDemoRebuild.this.aemDemo);
                    Properties rebuildProps = AemDemoUtils.loadProperties(AemDemoRebuild.this.aemDemo.getBuildFile().getParentFile().getAbsolutePath() + File.separator + "demos" + File.separator + AemDemoRebuild.this.demoMachine + File.separator + "demobuild.properties");
                    Enumeration<Object> props = rebuildProps.keys();
                    while (props.hasMoreElements()) {
                        String key = (String)props.nextElement();
                        if (key.startsWith("java") || key.startsWith("sun") || key.startsWith("logs") || key.startsWith("os") || key.startsWith("user")) continue;
                        p.setUserProperty(key, rebuildProps.getProperty(key));
                    }
                    p.setUserProperty("demo.build", AemDemoRebuild.this.demoBuildName.getText());
                    try {
                        p.setUserProperty("demo.hostname", InetAddress.getLocalHost().getHostName());
                    }
                    catch (UnknownHostException ex) {
                        logger.error((Object)ex.getMessage());
                    }
                    p.init();
                    ProjectHelper helper = ProjectHelper.getProjectHelper();
                    p.addReference("ant.projectHelper", helper);
                    helper.parse((Project)p, (Object)AemDemoRebuild.this.aemDemo.getBuildFile());
                    System.out.println("Rebuilding a demo named " + AemDemoRebuild.this.demoBuildName.getText());
                    Thread t = new Thread(new AemDemoRunnable(AemDemoRebuild.this.aemDemo, p, "create"));
                    t.start();
                    AemDemoRebuild.this.dispose();
                }
            });
            this.contentPanel.add(createButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setBounds(340, 120, 100, 30);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AemDemoRebuild.this.dispose();
                }
            });
            this.contentPanel.add(cancelButton);
            JRootPane rootPane = SwingUtilities.getRootPane(createButton);
            rootPane.setDefaultButton(createButton);
        } else {
            this.setBounds(150, 150, 760, 340);
            this.getContentPane().setLayout(null);
            this.contentPanel.setBounds(0, 0, 760, 340);
            this.getContentPane().add(this.contentPanel);
            this.contentPanel.setLayout(null);
            JLabel lblSelectADemo = new JLabel("There are validation errors!");
            lblSelectADemo.setBounds(20, 20, 620, 16);
            this.contentPanel.add(lblSelectADemo);
            int pos = 60;
            for (String errorMsg : validationErrors) {
                JLabel lblError = new JLabel(errorMsg);
                lblError.setBounds(20, pos, 720, 16);
                this.contentPanel.add(lblError);
                pos += 40;
            }
            JButton closeButton = new JButton("Close");
            closeButton.setBounds(20, 260, 60, 30);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AemDemoRebuild.this.dispose();
                }
            });
            this.contentPanel.add(closeButton);
        }
        AemDemoUtils.installEscapeCloseOperation(this);
    }

    public JTextField getDemoBuildName() {
        return this.demoBuildName;
    }
}

