/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.gui.AemDemo;
import com.adobe.aem.demomachine.gui.AemDemoConstants;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class AemDemoRunnable
implements Runnable {
    private AemDemo aemDemo;
    private Project p;
    private String t;

    public AemDemoRunnable(AemDemo aemDemo, Project p, String t) {
        this.p = p;
        this.t = t;
        this.aemDemo = aemDemo;
    }

    @Override
    public void run() {
        if (Arrays.asList(AemDemoConstants.BUILD_ACTIONS).contains(this.t)) {
            this.aemDemo.setBuildInProgress(true);
        }
        if (this.t.startsWith("download") || this.t.equals("infrastructure")) {
            this.aemDemo.setDownloadInProgress(true);
        }
        try {
            this.p.executeTarget(this.t);
            this.p.fireBuildFinished(null);
        }
        catch (BuildException ex) {
            System.out.println("Sorry, this target couldn't be completed properly");
            System.out.println("The error message is:");
            System.out.println(ex.getMessage());
        }
        if (Arrays.asList(AemDemoConstants.BUILD_ACTIONS).contains(this.t) || Arrays.asList(AemDemoConstants.STOP_ACTIONS).contains(this.t)) {
            this.aemDemo.setBuildInProgress(false);
        }
        if (this.t.startsWith("download")) {
            this.aemDemo.setDownloadInProgress(false);
        }
        String buildName = this.p.getProperty("demo.build");
        if (Arrays.asList(AemDemoConstants.CLEANUP_ACTIONS).contains(this.t)) {
            this.aemDemo.getListModelDemoMachines().removeElement(buildName);
        }
        if (Arrays.asList(AemDemoConstants.BUILD_ACTIONS).contains(this.t) && !this.aemDemo.getListModelDemoMachines().contains(buildName)) {
            this.aemDemo.getListModelDemoMachines().addElement(buildName);
        }
    }
}

