/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.gui;

import com.adobe.aem.demomachine.gui.AemDemo;
import com.adobe.aem.demomachine.gui.AemDemoConstants;
import com.adobe.aem.demomachine.gui.AemDemoProject;
import com.adobe.aem.demomachine.gui.AemDemoProperty;
import com.adobe.aem.demomachine.gui.AemDemoRunnable;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AemDemoUtils {
    static Logger logger = Logger.getLogger(AemDemoUtils.class);
    private static final KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
    public static final String dispatchWindowClosingActionMapKey = "com.spodding.tackline.dispatch:WINDOW_CLOSING";

    public static void main(String[] args) {
    }

    public static DefaultListModel<String> listDemoMachines(String demoMachineRootFolder) {
        DefaultListModel<String> demoMachines = new DefaultListModel<String>();
        File folder = new File(demoMachineRootFolder + File.separator + "demos");
        if (folder.exists()) {
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isDirectory()) continue;
                demoMachines.addElement(listOfFiles[i].getName());
            }
        }
        return demoMachines;
    }

    public static AemDemoProperty[] listAEMjars(File buildFile) {
        ArrayList<AemDemoProperty> aemJars = new ArrayList<AemDemoProperty>();
        File folder = new File(buildFile.getParentFile().getAbsolutePath() + File.separator + "dist" + File.separator + "bin");
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().endsWith(".jar")) continue;
            aemJars.add(new AemDemoProperty(listOfFiles[i].getName().substring(0, listOfFiles[i].getName().indexOf(".jar")), listOfFiles[i].getName()));
        }
        Properties defaultProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "build.properties");
        Properties personalProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)defaultProps);
        mergedProps.putAll((Map<?, ?>)personalProps);
        Enumeration<Object> e = mergedProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(key.startsWith("demo.docker.images.") & (!key.endsWith("help") && !key.endsWith("label")))) continue;
            String keyValue = mergedProps.getProperty(key);
            String keyName = "docker:" + keyValue;
            int lastSlash = keyName.lastIndexOf("/");
            if (lastSlash > 0) {
                keyName = keyName.substring(1 + lastSlash);
            }
            aemJars.add(new AemDemoProperty(keyValue, keyName));
        }
        AemDemoProperty[] aemPropertyArray = new AemDemoProperty[aemJars.size()];
        aemJars.toArray(aemPropertyArray);
        return aemPropertyArray;
    }

    public static int[] getDemoAddons(File buildFile) {
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        Properties defaultProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "build.properties");
        Properties personalProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
        Properties sortedProps = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        sortedProps.putAll((Map<?, ?>)defaultProps);
        Enumeration<Object> e = sortedProps.keys();
        int currentIndice = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(key.startsWith("demo.addons.") & (!key.endsWith("help") && !key.endsWith("label")))) continue;
            String value = sortedProps.getProperty(key);
            if (personalProps.containsKey(key)) {
                value = personalProps.getProperty(key);
            }
            if (value.equals("true")) {
                listIndices.add(currentIndice);
            }
            ++currentIndice;
        }
        int[] array = new int[listIndices.size()];
        for (int i = 0; i < listIndices.size(); ++i) {
            array[i] = (Integer)listIndices.get(i);
        }
        return array;
    }

    public static AemDemoProperty[] listDemoAddons(File buildFile) {
        ArrayList<AemDemoProperty> addons = new ArrayList<AemDemoProperty>();
        Properties defaultProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "build.properties");
        Properties sortedProps = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        sortedProps.putAll((Map<?, ?>)defaultProps);
        Enumeration<Object> e = sortedProps.keys();
        List<String[]> listPaths = Arrays.asList(AemDemoConstants.demoPaths);
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(key.startsWith("demo.addons.") & (!key.endsWith("help") && !key.endsWith("label")))) continue;
            String newKey = key.substring(1 + key.lastIndexOf("."));
            boolean downloadRequired = false;
            for (String[] path : listPaths) {
                File pathFolder;
                if (path.length != 5 || path[4] == null || !path[4].equals(newKey) || (pathFolder = new File(buildFile.getParentFile().getAbsolutePath() + (path[1].length() > 0 ? File.separator + path[1] : ""))).exists()) continue;
                downloadRequired = true;
            }
            addons.add(new AemDemoProperty(newKey, sortedProps.getProperty(key + ".label") + (downloadRequired ? " (*)" : "")));
        }
        AemDemoProperty[] aemPropertyArray = new AemDemoProperty[addons.size()];
        addons.toArray(aemPropertyArray);
        return aemPropertyArray;
    }

    public static AemDemoProperty[] listTopologies(File buildFile) {
        return AemDemoUtils.listOptions(buildFile, "demo.type.options");
    }

    public static AemDemoProperty[] listSRPs(File buildFile) {
        return AemDemoUtils.listOptions(buildFile, "demo.srp.options");
    }

    public static AemDemoProperty[] listMKs(File buildFile) {
        return AemDemoUtils.listOptions(buildFile, "demo.store.options");
    }

    public static String getPropertyValue(File buildFile, String propertyName) {
        String propertyValue = null;
        Properties defaultProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "build.properties");
        Properties personalProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
        propertyValue = personalProps.containsKey(propertyName) ? personalProps.getProperty(propertyName) : defaultProps.getProperty(propertyName);
        return propertyValue;
    }

    public static AemDemoProperty[] listOptions(File buildFile, String property) {
        ArrayList<AemDemoProperty> aemMKs = new ArrayList<AemDemoProperty>();
        Properties defaultProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "build.properties");
        Properties personalProps = AemDemoUtils.loadProperties(buildFile.getParentFile().getAbsolutePath() + File.separator + "conf" + File.separator + "build-personal.properties");
        if (personalProps.containsKey(property)) {
            AemDemoUtils.addPropertyFromString(aemMKs, personalProps.getProperty(property));
        } else {
            AemDemoUtils.addPropertyFromString(aemMKs, defaultProps.getProperty(property));
        }
        AemDemoProperty[] aemPropertyArray = new AemDemoProperty[aemMKs.size()];
        aemMKs.toArray(aemPropertyArray);
        return aemPropertyArray;
    }

    public static Properties loadProperties(String path) {
        Properties prop = new Properties();
        try {
            FileInputStream input = new FileInputStream(path);
            prop.load(input);
            ((InputStream)input).close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return prop;
    }

    private static void addPropertyFromString(List<AemDemoProperty> aemProperties, String propertyString) {
        if (propertyString != null) {
            Pattern pattern = Pattern.compile("\\[(.*?)\\]");
            Matcher matcher = pattern.matcher(propertyString);
            while (matcher.find()) {
                int sep = matcher.group().indexOf("/");
                if (sep <= 0) continue;
                aemProperties.add(new AemDemoProperty(matcher.group().substring(1, sep), matcher.group().substring(sep + 1, matcher.group().length() - 1)));
            }
        }
    }

    public static int getSelectedIndex(JList list, Properties defaultProperties, Properties personalProperties, String propertyString) {
        int index = 0;
        String defaultProperty = defaultProperties.getProperty(propertyString);
        String personalProperty = personalProperties.getProperty(propertyString);
        String actualProperty = personalProperty != null ? personalProperty : defaultProperty;
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            AemDemoProperty aemProperty;
            if (!(list.getModel().getElementAt(i) instanceof AemDemoProperty) || (aemProperty = (AemDemoProperty)list.getModel().getElementAt(i)).getValue() == null || actualProperty == null || !aemProperty.getValue().equals(actualProperty)) continue;
            return i;
        }
        return index;
    }

    public static String getActualPropertyValue(Properties defaultProperties, Properties personalProperties, String propertyString) {
        String defaultProperty = defaultProperties.getProperty(propertyString);
        String personalProperty = personalProperties.getProperty(propertyString);
        return personalProperty != null ? personalProperty : defaultProperty;
    }

    public static void antTarget(AemDemo aemDemo, String targetName) {
        String selectedDemoMachine = aemDemo.getListDemoMachines().getSelectedValue();
        if (Arrays.asList(AemDemoConstants.INSTANCE_ACTIONS).contains(targetName) && (selectedDemoMachine == null || selectedDemoMachine.toString().length() == 0)) {
            JOptionPane.showMessageDialog(null, "Please select a demo environment before running this command");
        } else {
            AemDemoProject p = new AemDemoProject(aemDemo);
            if (selectedDemoMachine != null && selectedDemoMachine.length() > 0) {
                p.setUserProperty("demo.build", selectedDemoMachine.toString());
            }
            try {
                p.setUserProperty("demo.hostname", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException ex) {
                logger.error((Object)ex.getMessage());
            }
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", helper);
            helper.parse((Project)p, (Object)aemDemo.getBuildFile());
            System.out.println("Running ANT target: " + targetName);
            Thread t = new Thread(new AemDemoRunnable(aemDemo, p, targetName));
            t.start();
        }
    }

    public static void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void openWebpage(URL url) {
        try {
            AemDemoUtils.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void openWebpage(String sUrl) {
        try {
            AemDemoUtils.openWebpage(new URL(sUrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, dispatchWindowClosingActionMapKey);
        root.getActionMap().put(dispatchWindowClosingActionMapKey, dispatchClosing);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String calcMD5HashForDir(File dirToHash, boolean includeSubFolders, boolean includeHiddenFiles) {
        assert (dirToHash.isDirectory());
        Vector<FileInputStream> fileStreams = new Vector<FileInputStream>();
        logger.debug((Object)"Found files for hashing:");
        AemDemoUtils.collectInputStreams(dirToHash, fileStreams, includeSubFolders, includeHiddenFiles);
        SequenceInputStream seqStream = new SequenceInputStream(fileStreams.elements());
        try {
            String md5Hash = DigestUtils.md5Hex((InputStream)seqStream);
            seqStream.close();
            return md5Hash;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading files to hash in " + dirToHash.getAbsolutePath(), e);
        }
    }

    public static void collectInputStreams(File dir, List<FileInputStream> foundStreams, boolean includeSubFolders, boolean includeHiddenFiles) {
        File[] fileList = dir.listFiles();
        Arrays.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (File f : fileList) {
            if (!includeHiddenFiles && f.getName().startsWith(".") || f.isDirectory() && !includeSubFolders) continue;
            if (f.isDirectory()) {
                AemDemoUtils.collectInputStreams(f, foundStreams, includeSubFolders, includeHiddenFiles);
                continue;
            }
            try {
                logger.debug((Object)f.getAbsolutePath());
                foundStreams.add(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new AssertionError((Object)(e.getMessage() + ": file should never not be found!"));
            }
        }
    }
}

