/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybrisUtil {
    public static Resource findBaseStore(Resource res) throws IllegalArgumentException {
        if (res != null) {
            ValueMap props = null;
            props = res.getChild("jcr:content") != null ? ResourceUtil.getValueMap((Resource)res.getChild("jcr:content")) : ResourceUtil.getValueMap((Resource)res);
            if (props.containsKey((Object)"cq:hybrisBaseStore")) {
                return res.getName().equals("jcr:content") ? res.getParent() : res;
            }
            return HybrisUtil.findBaseStore(res.getParent());
        }
        return null;
    }

    public static String findBaseStoreId(Resource res) throws IllegalArgumentException {
        if (res != null) {
            ValueMap props = null;
            props = res.getChild("jcr:content") != null ? ResourceUtil.getValueMap((Resource)res.getChild("jcr:content")) : ResourceUtil.getValueMap((Resource)res);
            if (props.containsKey((Object)"cq:hybrisBaseStore")) {
                return (String)props.get("cq:hybrisBaseStore", String.class);
            }
            return HybrisUtil.findBaseStoreId(res.getParent());
        }
        return null;
    }

    public static String findCatalogId(Resource res) throws IllegalArgumentException {
        if (res != null) {
            ValueMap props = null;
            props = res.getChild("jcr:content") != null ? ResourceUtil.getValueMap((Resource)res.getChild("jcr:content")) : ResourceUtil.getValueMap((Resource)res);
            if (props != null && props.containsKey((Object)"cq:hybrisCatalogId")) {
                return (String)props.get("cq:hybrisCatalogId", String.class);
            }
            return HybrisUtil.findCatalogId(res.getParent());
        }
        return null;
    }

    public static String getProductId(Resource res) {
        ValueMap props = ResourceUtil.getValueMap((Resource)res);
        if (props.containsKey((Object)"cq:hybrisProductId")) {
            return (String)props.get("cq:hybrisProductId", String.class);
        }
        return null;
    }

    public static String createProductUri(Resource resource, String uriTemplate) {
        String productId = HybrisUtil.getProductId(resource);
        return HybrisUtil.createProductUri(productId, uriTemplate);
    }

    public static String createProductUri(String productId, String uriTemplate) {
        return uriTemplate.replace("{id}", productId);
    }

    public static boolean isProduct(Resource res) {
        ValueMap props = ResourceUtil.getValueMap((Resource)res);
        return props.containsKey((Object)"cq:hybrisProductId");
    }

    public static boolean isVariant(Resource res) {
        if (res.getParent() != null) {
            return HybrisUtil.isProduct(res.getParent());
        }
        return false;
    }

    public static String fetchHybrisDeliveryMode(Map<String, Object> orderInfo) {
        String deliveryMode = (String)orderInfo.get("shipping-option");
        if (orderInfo.containsKey("shipping-option") && StringUtils.isEmpty((String)deliveryMode)) {
            deliveryMode = "standard-gross";
        }
        return deliveryMode;
    }

    public static Resource findProductInBucket(Resource base, String productId) throws RepositoryException {
        ValueMap properties = (ValueMap)base.adaptTo(ValueMap.class);
        if (productId.equals(properties.get("cq:hybrisProductId", String.class))) {
            return base;
        }
        Resource productResource = base.getChild(productId);
        if (productResource != null && productId.equals(HybrisUtil.getProductId(productResource))) {
            return productResource;
        }
        for (Resource bucket : base.getChildren()) {
            Resource child = bucket.getChild(productId);
            if (child == null || !productId.equals(HybrisUtil.getProductId(child))) continue;
            return child;
        }
        return null;
    }
}

