/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.hybris.api.GroupConnector;
import java.security.Principal;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
public class DefaultGroupConnector
implements GroupConnector {
    private static final Logger log = LoggerFactory.getLogger(DefaultGroupConnector.class);
    public static final String PATH_HYBRIS_CONNECTOR = "hybris";
    public static final String PN_UID = "hybris/uid";
    public static final String DEFAULT_GROUPS_PATH = "";
    @Property(value={""})
    public static final String PN_GROUPS_PATH = "hybris.groups.path";
    protected String groupsPath;

    protected void activate(ComponentContext context) {
        this.groupsPath = context.getBundleContext().getProperty(PN_GROUPS_PATH);
    }

    @Override
    public String getHybrisUid(String groupId, ResourceResolver resolver) {
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        String uid = null;
        try {
            Group group = (Group)userManager.getAuthorizable(groupId);
            if (group.hasProperty(PN_UID)) {
                uid = group.getProperty(PN_UID)[0].getString();
            }
        }
        catch (RepositoryException e) {
            log.error("Could not get hybris uid for groupId: " + groupId, (Throwable)e);
        }
        return uid;
    }

    @Override
    public Group setHybrisData(Map<String, String> hybrisData, String path, ResourceResolver resolver) {
        String groupID = hybrisData.get("uid");
        if (StringUtils.isBlank((String)groupID)) {
            throw new IllegalArgumentException("group uid cannot be blank");
        }
        if (StringUtils.isBlank((String)path)) {
            path = this.groupsPath;
        }
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        Group group = null;
        try {
            group = (Group)userManager.getAuthorizable(groupID);
            if (group == null) {
                if (!StringUtils.isBlank((String)path)) {
                    JcrUtils.getOrCreateByPath((String)path, (String)"rep:AuthorizableFolder", (Session)((Session)resolver.adaptTo(Session.class)));
                    group = userManager.createGroup(groupID, (Principal)new SimplePrincipal(groupID), path);
                } else {
                    group = userManager.createGroup(groupID);
                }
            }
            for (Map.Entry<String, String> property : hybrisData.entrySet()) {
                group.setProperty("hybris/" + property.getKey(), (Value)new StringValue(property.getValue()));
            }
        }
        catch (RepositoryException e) {
            log.error("Could not set hybris group data", (Throwable)e);
        }
        return group;
    }

    private static class SimplePrincipal
    implements Principal {
        protected final String name;

        public SimplePrincipal(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("Principal name cannot be blank.");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Principal) {
                return this.name.equals(((Principal)obj).getName());
            }
            return false;
        }
    }
}

