/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.PriceFilter;
import com.adobe.cq.commerce.hybris.api.HybrisService;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisSession;
import com.adobe.cq.commerce.hybris.common.HybrisProduct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHybrisCartEntry
implements CommerceSession.CartEntry {
    private ValueMap values;
    private List<PriceInfo> prices;
    private DefaultHybrisSession hybrisSession;

    public DefaultHybrisCartEntry(DefaultHybrisSession hybrisSession, Map<String, Object> entryValues) {
        this.hybrisSession = hybrisSession;
        this.values = new ValueMapDecorator(entryValues);
        this.prices = new ArrayList<PriceInfo>();
        this.prices.add(this.addPriceTypes((PriceInfo)this.values.get("basePrice", PriceInfo.class), "UNIT"));
        this.prices.add(this.addPriceTypes((PriceInfo)this.values.get("totalPrice", PriceInfo.class), "LINE"));
    }

    public int getEntryIndex() {
        return (Integer)this.values.get("entryNumber", Integer.class);
    }

    public Product getProduct() throws CommerceException {
        String code = (String)this.values.get("code", String.class);
        HybrisService service = (HybrisService)this.hybrisSession.getCommerceService();
        HybrisProduct product = (HybrisProduct)service.getProductByHybrisId(code);
        if (this.values.containsKey((Object)"product")) {
            product.setProperties((ValueMap)new ValueMapDecorator((Map)this.values.get((Object)"product")));
        }
        return product;
    }

    public int getQuantity() {
        return (Integer)this.values.get("quantity", Integer.class);
    }

    public String getUnitPrice() {
        try {
            return this.getPriceInfo((Predicate)new PriceFilter(new String[]{"UNIT"})).get(0).getFormattedString();
        }
        catch (CommerceException e) {
            return "";
        }
    }

    public String getPreTaxPrice() {
        return this.getTotalPrice();
    }

    public String getTax() {
        return "";
    }

    public String getTotalPrice() {
        try {
            return this.getPriceInfo((Predicate)new PriceFilter(new String[]{"LINE"})).get(0).getFormattedString();
        }
        catch (CommerceException e) {
            return "";
        }
    }

    public List<PriceInfo> getPriceInfo(Predicate filter) throws CommerceException {
        if (filter != null) {
            ArrayList<PriceInfo> filtered = new ArrayList<PriceInfo>();
            CollectionUtils.select(this.prices, (Predicate)filter, filtered);
            return filtered;
        }
        return this.prices;
    }

    public String getPrice(Predicate filter) throws CommerceException {
        List<PriceInfo> filtered = this.getPriceInfo(filter);
        if (filtered.size() > 0) {
            return filtered.get(0).getFormattedString();
        }
        return null;
    }

    public <T> T getProperty(String name, Class<T> type) {
        return (T)this.values.get(name, type);
    }

    private PriceInfo addPriceTypes(PriceInfo pi, String ... types) {
        pi.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList(types)));
        return pi;
    }
}

