/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.NotAuthorizedException;
import com.adobe.cq.commerce.hybris.HybrisSession;
import com.adobe.cq.commerce.hybris.common.HttpMethodWrapper;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Day CQ Commerce Hybris Connection Handler")
@Service
public class DefaultHybrisConnection
implements HybrisConnection {
    private static final Logger log = LoggerFactory.getLogger(DefaultHybrisConnection.class);
    private static final URLCodec urlCodec = new URLCodec();
    @Property(value={"https://localhost:9002"})
    public static final String SERVER_URL = "hybris.server.url";
    @Property(value={"admin"})
    public static final String SERVER_USERNAME = "hybris.server.username";
    @Property(value={"nimda"})
    public static final String SERVER_PASSWORD = "hybris.server.password";
    @Property(boolValue={true})
    public static final String SERVER_SSL_TRUST_ALL_CERTS = "hybris.server.ssl.trust_all_certs";
    @Property(value={"/ws410/rest", "/medias"})
    public static final String STORE_INDEPENDENT_PREFIXES = "hybris.server.store_independent_prefixes";
    @Property(value={"/rest/v1/"})
    public static final String REST_ENDPOINT = "hybris.server.rest_endpoint";
    @Property(intValue={30000})
    public static final String CONNECTION_TIMEOUT = "hybris.http.timeout.connection";
    @Property(intValue={30000})
    public static final String SOCKET_TIMEOUT = "hybris.http.timeout.socket";
    @Property(intValue={20})
    public static final String MAX_CONNECTIONS = "hybris.http.max_connections";
    @Property(intValue={2})
    public static final String MAX_CONNECTIONS_PER_HOST = "hybris.http.max_connections_per_host";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisAuthenticationHandler authHandler;
    private static final String DEFAULT_SERVER_URL = "https://localhost:9002";
    private static final String DEFAULT_SERVER_USERNAME = "admin";
    private static final String DEFAULT_SERVER_PASSWORD = "nimda";
    private static final boolean DEFAULT_SERVER_SSL_TRUST_ALL_CERTS = true;
    private static final String DEFAULT_ENDPOINT = "/rest/v1/";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static final int DEFAULT_MAX_CONNECTIONS = 20;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_HOST = 2;
    private static final int CONNECTION_MANAGER_TIMEOUT = 3000;
    private String endpoint;
    private Integer maxConnectionsPerHost;
    private MultiThreadedHttpConnectionManager connectionManager;
    private SSLContext originalSSLContext = null;
    private String serverUrl;
    private String serverUsername;
    private String serverPassword;
    private String contextPath;
    private String[] storeIndependentPrefixes;
    private Integer connectionTimeout;
    private Integer socketTimeout;
    static Map<Thread, Integer> connectionCount = new HashMap<Thread, Integer>();

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public CommandResult execute(HybrisCommand command, HybrisConnection.ConnectionOptions options) throws CommerceException {
        HttpClient httpClient = this.getConfiguredHttpClient();
        HttpMethod request = null;
        boolean releaseConnection = true;
        try {
            Map<String, String> newSessionData;
            request = this.createRequestMethod(command, options.getBaseStore(), options.getContext());
            long ms = System.currentTimeMillis();
            if (options.getSessionData() != null && !options.getSessionData().isEmpty()) {
                log.debug("Using session data to authenticate request.");
                newSessionData = this.authHandler.executeAuthenticated(httpClient, request, options.getSessionData());
            } else if (command.needsServerAuth()) {
                log.debug("Using server username/password to authenticate request.");
                newSessionData = this.authHandler.executeAuthenticated(httpClient, request, this.serverUsername, this.serverPassword);
            } else {
                log.debug("Not authenticating request.");
                newSessionData = null;
                httpClient.executeMethod(request);
            }
            if (newSessionData != null && options.getSession() != null && options.getSession().getSessionInfo() != null) {
                options.getSession().getSessionInfo().setCookieInfo(newSessionData);
            }
            int status = request.getStatusCode();
            log.debug("Sending {} to {} returned with status {} in {} ms", new Object[]{command.getClass().getSimpleName(), request.getURI(), status, System.currentTimeMillis() - ms});
            if (log.isTraceEnabled()) {
                log.trace(request.getResponseBodyAsString());
            }
            if (status == 200 || status == 201 || status == 202) {
                CommandResult result;
                releaseConnection = false;
                CommandResult commandResult = result = this.createCommandResult(command, newSessionData, request, status);
                return commandResult;
            }
            if (status == 403 || status == 401) {
                throw new NotAuthorizedException("You are not authorized.");
            }
            if (status == 404) {
                releaseConnection = false;
                CommandResult result = this.createCommandResult(command, newSessionData, request, status);
                return result;
            }
            try {
                String body = request.getResponseBodyAsString();
                String error = "hybris response status: [" + status + "], body: [" + body + "]";
                log.error("execute: " + error);
                throw new CommerceException("error executing command; " + error);
            }
            catch (IOException e) {
                throw new CommerceException("error executing command", (Throwable)e);
            }
        }
        finally {
            if (releaseConnection && request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public CommandResult execute(HybrisCommand command, String baseStore) throws CommerceException {
        return this.execute(command, baseStore, null);
    }

    @Override
    public CommandResult execute(HybrisCommand command, String baseStore, CommerceSession session) throws NotAuthorizedException, CommerceException {
        Map context = session != null ? ((HybrisSession)session).getCommerceService().getContext() : null;
        HybrisConnection.ConnectionOptions options = new HybrisConnection.ConnectionOptions(baseStore, (HybrisSession)session, (Map<String, Object>)context);
        return this.execute(command, options);
    }

    @Override
    public CommandResult execute(HybrisCommand command, String username, String password, String baseStore) throws NotAuthorizedException, CommerceException {
        HttpClient httpClient = this.getConfiguredHttpClient();
        HttpMethod request = null;
        boolean releaseConnection = true;
        try {
            request = this.createRequestMethod(command, baseStore, null);
            long ms = System.currentTimeMillis();
            Map<String, String> newSessionData = this.authHandler.executeAuthenticated(httpClient, request, username, password);
            int status = request.getStatusCode();
            log.debug("Sending {} to {} returned with status {} in {} ms", new Object[]{command.getClass().getSimpleName(), request.getURI(), status, System.currentTimeMillis() - ms});
            if (log.isTraceEnabled()) {
                log.trace(request.getResponseBodyAsString());
            }
            if (status == 200 || status == 201) {
                releaseConnection = false;
                CommandResult commandResult = this.createCommandResult(command, newSessionData, request, status);
                return commandResult;
            }
            if (status == 403 || status == 401) {
                throw new NotAuthorizedException("You are not authorized.");
            }
            if (status == 404) {
                releaseConnection = false;
                CommandResult commandResult = this.createCommandResult(command, newSessionData, request, status);
                return commandResult;
            }
            try {
                String error = request.getResponseBodyAsString();
                log.error("execute: hybris response error: [{}]", (Object)error);
                throw new CommerceException("error executing command; " + error);
            }
            catch (IOException e) {
                throw new CommerceException("error executing command", (Throwable)e);
            }
        }
        finally {
            if (releaseConnection && request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public HttpClient getConfiguredHttpClient() {
        HttpClient http = new HttpClient((HttpConnectionManager)this.connectionManager);
        http.getParams().setParameter("http.connection.timeout", (Object)this.connectionTimeout);
        http.getParams().setParameter("http.socket.timeout", (Object)this.socketTimeout);
        http.getParams().setConnectionManagerTimeout(3000L);
        return http;
    }

    private HttpMethod createRequestMethod(HybrisCommand command, String baseStore, Map<String, Object> context) throws UnsupportedEncodingException {
        Object request;
        Object entity;
        String url = this.serverUrl + this.getCommandPath(command, baseStore);
        if ("POST".equals(command.getMethod())) {
            PostMethod post = new PostMethod(url);
            entity = command.getRequestBodyStream() != null ? new InputStreamRequestEntity(command.getRequestBodyStream(), command.getRequestContentType()) : (!StringUtils.isBlank((String)command.getRequestBody()) ? new StringRequestEntity(command.getRequestBody(), command.getRequestContentType(), "utf-8") : null);
            if (entity != null) {
                post.setRequestEntity((RequestEntity)entity);
            }
            request = post;
        } else if ("PUT".equals(command.getMethod())) {
            PutMethod put = new PutMethod(url);
            entity = command.getRequestBodyStream() != null ? new InputStreamRequestEntity(command.getRequestBodyStream(), command.getRequestContentType()) : (!StringUtils.isBlank((String)command.getRequestBody()) ? new StringRequestEntity(command.getRequestBody(), command.getRequestContentType(), "utf-8") : null);
            if (entity != null) {
                put.setRequestEntity((RequestEntity)entity);
            }
            put.setRequestEntity((RequestEntity)entity);
            request = put;
        } else {
            request = "DELETE".equals(command.getMethod()) ? new DeleteMethod(url) : new GetMethod(url);
        }
        String queryString = command.getQueryString();
        if (context != null) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (queryString.length() > 0) {
                    queryString = queryString + "&";
                }
                queryString = queryString + entry.getKey() + "=" + urlCodec.encode((String)entry.getValue(), "utf-8");
            }
        }
        request.setQueryString(queryString);
        request.addRequestHeader("Accept", "application/xml");
        for (NameValuePair h : command.getHeaders()) {
            request.addRequestHeader(h.getName(), h.getValue());
        }
        return new HttpMethodWrapper(this, (HttpMethod)request);
    }

    private String getCommandPath(HybrisCommand command, String baseStore) {
        String commandPath = command.getPath().replaceFirst(this.contextPath, "");
        for (String prefix : this.storeIndependentPrefixes) {
            if (!commandPath.startsWith(prefix)) continue;
            return commandPath;
        }
        return this.endpoint + baseStore + commandPath;
    }

    private CommandResult createCommandResult(HybrisCommand command, Map<String, String> newSessionData, HttpMethod request, int status) throws CommerceException, IOException {
        CommandResult result = new CommandResult(status, request, newSessionData);
        if (!result.success()) {
            log.error("command failed to execute: status: [{}]", (Object)status);
            throw new CommerceException("the command failed to execute");
        }
        return result;
    }

    @Activate
    protected void activate(ComponentContext ctx) throws MalformedURLException {
        Dictionary config = ctx.getProperties();
        this.maxConnectionsPerHost = PropertiesUtil.toInteger(config.get(MAX_CONNECTIONS_PER_HOST), (int)2);
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(this.maxConnectionsPerHost.intValue());
        params.setMaxTotalConnections(PropertiesUtil.toInteger(config.get(MAX_CONNECTIONS), (int)20));
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.setParams(params);
        this.serverUrl = PropertiesUtil.toString(config.get(SERVER_URL), (String)DEFAULT_SERVER_URL);
        this.serverUsername = PropertiesUtil.toString(config.get(SERVER_USERNAME), (String)DEFAULT_SERVER_USERNAME);
        this.serverPassword = PropertiesUtil.toString(config.get(SERVER_PASSWORD), (String)DEFAULT_SERVER_PASSWORD);
        this.contextPath = new URL(this.serverUrl).getPath();
        this.storeIndependentPrefixes = PropertiesUtil.toStringArray(config.get(STORE_INDEPENDENT_PREFIXES));
        this.endpoint = PropertiesUtil.toString(config.get(REST_ENDPOINT), (String)DEFAULT_ENDPOINT);
        this.connectionTimeout = PropertiesUtil.toInteger(config.get(CONNECTION_TIMEOUT), (int)30000);
        this.socketTimeout = PropertiesUtil.toInteger(config.get(SOCKET_TIMEOUT), (int)30000);
        boolean trustAllCerts = PropertiesUtil.toBoolean(config.get(SERVER_SSL_TRUST_ALL_CERTS), (boolean)true);
        if (trustAllCerts) {
            TrustManager[] trustmanager = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustmanager, new SecureRandom());
                this.originalSSLContext = SSLContext.getDefault();
                SSLContext.setDefault(sc);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this.connectionManager.shutdown();
        if (this.originalSSLContext != null) {
            SSLContext.setDefault(this.originalSSLContext);
            this.originalSSLContext = null;
        }
    }

    synchronized void increaseConnectionCount(Thread thread) {
        Integer count = connectionCount.get(thread);
        if (count == null) {
            count = 0;
        }
        if (count == this.maxConnectionsPerHost) {
            log.warn("Max connections exceeded resulting in potential deadlock. The connection was requested here: ", new Throwable());
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        log.debug("Increasing connection count to {} for thread: {}", (Object)count, (Object)thread.getId());
        connectionCount.put(thread, count);
    }

    synchronized void decreaseConnectionCount(Thread thread) {
        Integer count;
        Integer n = count = connectionCount.get(thread);
        Integer n2 = count = Integer.valueOf(count - 1);
        log.debug("Decreasing connection count to {} for thread: {}", (Object)count, (Object)thread.getId());
        if (count == 0) {
            connectionCount.remove(thread);
        } else {
            connectionCount.put(thread, count);
        }
    }

    protected void bindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        this.authHandler = hybrisAuthenticationHandler;
    }

    protected void unbindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        if (this.authHandler == hybrisAuthenticationHandler) {
            this.authHandler = null;
        }
    }
}

