/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceServiceFactory;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.AbstractJcrCommerceServiceFactory;
import com.adobe.cq.commerce.hybris.HybrisSession;
import com.adobe.cq.commerce.hybris.HybrisUtil;
import com.adobe.cq.commerce.hybris.SessionInfo;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.HybrisService;
import com.adobe.cq.commerce.hybris.api.ProfileSynchronizer;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisService;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisSession;
import com.adobe.cq.commerce.hybris.common.HybrisConfiguration;
import com.adobe.cq.commerce.hybris.common.HybrisProduct;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, label="Day CQ Commerce Factory for Hybris")
@Service(value={CommerceServiceFactory.class, HybrisFactory.class})
@Properties(value={@Property(name="service.description", value={"Hybris-specific factory for commerce service"}), @Property(name="commerceProvider", value={"hybris"})})
public class DefaultHybrisFactory
extends AbstractJcrCommerceServiceFactory
implements HybrisFactory {
    public static final String DEFAULT_CATALOG_VERSION = "Online";
    public static final String DEFAULT_PRODUCT_URI_TEMPLATE = "/products/{id}";
    public static final String DEFAULT_PRODUCT_URI_REGEX = "(.*)/products/([a-zA-Z_0-9\\-\\.]+)";
    public static final String DEFAULT_BASE_STORE = "outdoors";
    public static final int DEFAULT_PING_INTERVAL = 5;
    @Property(value={"Online"})
    public static final String CATALOG_VERSION = "hybris.catalog.version";
    @Property(value={"Online"})
    public static final String CATALOG_VERSION_ONLINE = "hybris.catalog.version.online";
    @Property(value={"/products/{id}"})
    public static final String PRODUCT_URI_TEMPLATE = "hybris.product.uri.template";
    @Property(value={"(.*)/products/([a-zA-Z_0-9\\-\\.]+)"})
    public static final String PRODUCT_URI_REGEX = "hybris.product.uri.regex";
    @Property(value={"outdoors"})
    public static final String BASE_STORE = "hybris.basestore";
    @Property(intValue={5})
    public static final String PING_INTERVAL = "hybris.ping_interval";
    @Property(value={"V5"}, options={@PropertyOption(name="V4", value="4.x.x"), @PropertyOption(name="V5", value="5.0.x")})
    public static final String HYBRIS_VERSION = "hybris.version";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisConnection connection;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisResponseParser parser;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected UserConnector userConnector;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisAuthenticationHandler authHandler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected ProfileSynchronizer profileSynchronizer;
    protected ComponentContext context;

    public HybrisConfiguration getServiceContext() {
        return new HybrisConfiguration(this);
    }

    public HybrisService getCommerceService(Resource res) {
        return new DefaultHybrisService(res, this.getServiceContext());
    }

    public Product getProduct(Resource originalResource) {
        String dataPath = (String)ResourceUtil.getValueMap((Resource)originalResource).get("productData", String.class);
        if (dataPath == null && !HybrisUtil.isProduct(originalResource)) {
            return null;
        }
        Resource dataResource = null;
        Resource refResource = null;
        if (dataPath == null) {
            dataResource = originalResource;
            refResource = null;
        } else {
            dataResource = originalResource.getResourceResolver().getResource(dataPath);
            refResource = originalResource;
        }
        return new HybrisProduct(refResource, dataResource);
    }

    public HybrisSession getSession(HybrisService service, SlingHttpServletRequest request, SessionInfo sessionInfo) {
        return this.getSession(service, request, null, sessionInfo);
    }

    public HybrisSession getSession(HybrisService service, SlingHttpServletRequest request, SlingHttpServletResponse response, SessionInfo sessionInfo) {
        return new DefaultHybrisSession(this.getServiceContext(), service, request, response, sessionInfo);
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.context = ctx;
    }

    protected void bindConnection(HybrisConnection hybrisConnection) {
        this.connection = hybrisConnection;
    }

    protected void unbindConnection(HybrisConnection hybrisConnection) {
        if (this.connection == hybrisConnection) {
            this.connection = null;
        }
    }

    protected void bindParser(HybrisResponseParser hybrisResponseParser) {
        this.parser = hybrisResponseParser;
    }

    protected void unbindParser(HybrisResponseParser hybrisResponseParser) {
        if (this.parser == hybrisResponseParser) {
            this.parser = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindUserConnector(UserConnector userConnector) {
        this.userConnector = userConnector;
    }

    protected void unbindUserConnector(UserConnector userConnector) {
        if (this.userConnector == userConnector) {
            this.userConnector = null;
        }
    }

    protected void bindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        this.authHandler = hybrisAuthenticationHandler;
    }

    protected void unbindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        if (this.authHandler == hybrisAuthenticationHandler) {
            this.authHandler = null;
        }
    }

    protected void bindProfileSynchronizer(ProfileSynchronizer profileSynchronizer) {
        this.profileSynchronizer = profileSynchronizer;
    }

    protected void unbindProfileSynchronizer(ProfileSynchronizer profileSynchronizer) {
        if (this.profileSynchronizer == profileSynchronizer) {
            this.profileSynchronizer = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HybrisVersion {
        V4,
        V5;


        public boolean isV5() {
            return this.equals((Object)V5);
        }
    }
}

