/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PlacedOrder;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHybrisPlacedOrder
implements PlacedOrder {
    private String orderId;
    protected Map<String, Object> details;
    protected List<PriceInfo> prices;
    protected List<CommerceSession.CartEntry> entries;
    protected List<PromotionInfo> promotions;
    protected List<VoucherInfo> vouchers;

    public DefaultHybrisPlacedOrder(String orderId) {
        this.orderId = orderId;
        this.details = new HashMap<String, Object>();
        this.details.put("orderId", orderId);
        this.entries = new ArrayList<CommerceSession.CartEntry>();
        this.prices = new ArrayList<PriceInfo>();
    }

    public String getOrderId() throws CommerceException {
        return this.orderId;
    }

    public Map<String, Object> getOrder() throws CommerceException {
        return this.details;
    }

    public List<PriceInfo> getCartPriceInfo(Predicate predicate) throws CommerceException {
        ArrayList<PriceInfo> filteredPrices = new ArrayList<PriceInfo>();
        CollectionUtils.select(this.prices, (Predicate)predicate, filteredPrices);
        return filteredPrices;
    }

    public String getCartPrice(Predicate predicate) throws CommerceException {
        PriceInfo price = (PriceInfo)CollectionUtils.find(this.prices, (Predicate)predicate);
        if (price != null) {
            return price.getFormattedString();
        }
        return "";
    }

    public List<CommerceSession.CartEntry> getCartEntries() throws CommerceException {
        return this.entries;
    }

    public List<Voucher> getVouchers() throws CommerceException {
        return new ArrayList<Voucher>();
    }

    protected void setOrder(Map<String, Object> details) {
        this.details = details;
    }

    protected void setPrices(List<PriceInfo> prices) {
        this.prices = prices;
    }

    protected void setEntries(List<CommerceSession.CartEntry> entries) {
        this.entries = entries;
    }

    protected void setPromotions(List<PromotionInfo> promotions) {
        this.promotions = promotions;
    }

    protected void setVouchers(List<VoucherInfo> vouchers) {
        this.vouchers = vouchers;
    }

    public List<PromotionInfo> getPromotions() throws CommerceException {
        return this.promotions;
    }

    public List<VoucherInfo> getVoucherInfos() throws CommerceException {
        return this.vouchers;
    }
}

