/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.api.CommerceResult;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.common.CommerceSearchProvider;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisService;
import com.adobe.cq.commerce.hybris.common.SearchResultParser;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.cmd.SearchCommand;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Service(value={CommerceSearchProvider.class})
@Component
@Property(name="commerce.search.provider.name", value={"DefaultHybrisSearch"})
public class DefaultHybrisSearchProvider
implements CommerceSearchProvider {
    public static final String PROVIDER_NAME = "DefaultHybrisSearch";

    public CommerceResult search(CommerceQuery query, CommerceService commerceService) throws CommerceException {
        DefaultHybrisService hybrisService = (DefaultHybrisService)commerceService;
        String baseStoreId = hybrisService.getBaseStore();
        Map context = hybrisService.getContext();
        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(baseStoreId, context);
        HybrisConnection connection = hybrisService.getConnection();
        CommandResult result = connection.execute((HybrisCommand)new SearchCommand(query), opts);
        try {
            if (result.success()) {
                CommerceResult commerceResult = new SearchResultParser(hybrisService).parse(query, result.getBody());
                return commerceResult;
            }
        }
        catch (Exception e) {
            throw new CommerceException("Error while parsing search results", (Throwable)e);
        }
        finally {
            result.release();
        }
        return null;
    }
}

