/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.AbstractJcrCommerceService;
import com.adobe.cq.commerce.common.ServiceContext;
import com.adobe.cq.commerce.hybris.HybrisSession;
import com.adobe.cq.commerce.hybris.HybrisUtil;
import com.adobe.cq.commerce.hybris.SessionInfo;
import com.adobe.cq.commerce.hybris.api.HybrisService;
import com.adobe.cq.commerce.hybris.common.HybrisConfiguration;
import com.adobe.cq.commerce.hybris.common.HybrisSessionInfo;
import com.adobe.cq.commerce.hybris.common.promotion.DefaultHybrisPromotion;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.HybrisSessionUtil;
import com.adobe.cq.commerce.hybris.connection.cmd.GenericHybrisCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.GetProductCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.RestoreCartCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.SignUpCommand;
import com.adobe.cq.commerce.hybris.impl.OAuthHandler;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHybrisService
extends AbstractJcrCommerceService
implements HybrisService {
    private static final Logger log = LoggerFactory.getLogger(DefaultHybrisService.class);
    private static final Map<String, ReentrantLock> signUpLocks = Collections.synchronizedMap(new HashMap());
    private HybrisConnection connection;
    private HybrisConfiguration options;
    private ResourceResolver resolver;
    private Resource baseStore;
    private String baseStoreId;
    private String language;
    protected static boolean pinging = false;
    protected static boolean hybrisOnline;
    protected static long lastPing;

    public DefaultHybrisService(Resource resource, HybrisConfiguration config) {
        this(resource.getResourceResolver(), HybrisUtil.findBaseStore(resource), HybrisUtil.findBaseStoreId(resource), config.languageManager.getCqLanguage(resource) != null ? config.languageManager.getCqLanguage(resource).getLanguageCode() : "en", config);
    }

    public DefaultHybrisService(ResourceResolver resolver, HybrisConfiguration config, String baseStoreId) {
        super((ServiceContext)null);
        this.options = config;
        this.resolver = resolver;
        this.connection = config.connection;
        this.baseStoreId = baseStoreId == null ? config.baseStore : baseStoreId;
    }

    public DefaultHybrisService(ResourceResolver resolver, Resource baseResource, String baseStoreId, String lang, HybrisConfiguration config) {
        super((ServiceContext)config);
        this.options = config;
        this.resolver = resolver;
        this.connection = config.connection;
        this.baseStore = baseResource;
        this.baseStoreId = baseStoreId == null ? config.baseStore : baseStoreId;
        this.language = lang;
    }

    public HybrisConfiguration serviceContext() {
        return (HybrisConfiguration)super.serviceContext();
    }

    void signUp(String userID, String hybrisUsername, SlingHttpServletRequest request, SlingHttpServletResponse response) throws CommerceException {
        block19: {
            ResourceResolver rr = null;
            CommandResult result = null;
            try {
                String familyName;
                HashMap<String, String> authInfo = new HashMap<String, String>();
                authInfo.put("user.impersonation", userID);
                rr = this.options.resolverFactory.getAdministrativeResourceResolver(authInfo);
                UserPropertiesManager upm = this.serviceContext().userPropertiesService.createUserPropertiesManager((Session)rr.adaptTo(Session.class), rr);
                UserProperties profile = upm.getUserProperties(userID, "profile");
                String givenName = (String)profile.getProperty("givenName", (Object)"", String.class);
                if (StringUtils.isEmpty((String)givenName)) {
                    givenName = hybrisUsername;
                }
                if (StringUtils.isEmpty((String)(familyName = (String)profile.getProperty("familyName", (Object)"", String.class)))) {
                    familyName = hybrisUsername;
                }
                String hybrisPassword = this.options.userConnector.generateNewSlavePassword();
                HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.baseStoreId, this.context);
                if (this.serviceContext().hybrisVersion.isV5()) {
                    String accessToken = ((OAuthHandler)this.options.authHandler).getAccessToken();
                    result = this.connection.execute((HybrisCommand)new SignUpCommand(hybrisUsername, hybrisPassword, givenName, familyName, accessToken), opts);
                } else {
                    result = this.connection.execute((HybrisCommand)new SignUpCommand(hybrisUsername, hybrisPassword, givenName, familyName), opts);
                }
                try {
                    Map<String, String> authData = this.options.authHandler.authenticateUser(hybrisUsername, hybrisPassword);
                    if (result.success()) {
                        this.options.userConnector.setHybrisCredentials(userID, hybrisUsername, authData);
                        Map<String, String> sessionData = this.options.authHandler.authenticateSession(authData);
                        HybrisSessionUtil.setCookieInfo(sessionData, (HttpServletRequest)request, (HttpServletResponse)response, this.options.settingsService);
                        HybrisConnection.ConnectionOptions connectionOptions = new HybrisConnection.ConnectionOptions(this.baseStoreId, sessionData, (Map<String, Object>)this.context);
                        this.serviceContext().profileSynchronizer.syncProfile(profile, connectionOptions);
                    }
                }
                catch (IllegalStateException x) {
                    if (x.getCause() instanceof ConnectException) {
                        this.checkConnectException(new CommerceException("", x.getCause()), false);
                        break block19;
                    }
                    throw x;
                }
                catch (CommerceException e) {
                    this.checkConnectException(e, false);
                }
                catch (Exception e) {
                    log.warn("Error syncing profile for new user: ", (Throwable)e);
                }
            }
            catch (CommerceException e) {
                this.checkConnectException(e, true);
            }
            catch (Exception e) {
                throw new CommerceException("Failed to create hybris account for user: " + userID + "/" + hybrisUsername, (Throwable)e);
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
                if (result != null) {
                    result.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo fetchClientContextUserHybrisCredentials(SlingHttpServletRequest request, SlingHttpServletResponse response) throws CommerceException {
        String oldUsername;
        String userId;
        String hybrisUsername;
        boolean anonymous;
        block21: {
            anonymous = false;
            UserProperties userProperties = (UserProperties)request.adaptTo(UserProperties.class);
            if (userProperties == null || this.options.userConnector.isAnonymous(userProperties.getAuthorizableID())) {
                hybrisUsername = "anonymous";
                userId = "anonymous";
                anonymous = true;
            } else {
                userId = userProperties.getAuthorizableID();
                DefaultHybrisService defaultHybrisService = this;
                synchronized (defaultHybrisService) {
                    if (!signUpLocks.containsKey(userId)) {
                        signUpLocks.put(userId, new ReentrantLock());
                    }
                    signUpLocks.get(userId).lock();
                }
                try {
                    hybrisUsername = this.options.userConnector.getHybrisUsername(userId);
                    if (hybrisUsername != null) break block21;
                    try {
                        hybrisUsername = userProperties.getProperty("email");
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                    if (hybrisUsername == null) {
                        hybrisUsername = userProperties.getAuthorizableID();
                    }
                    if (hybrisUsername.equalsIgnoreCase("admin")) {
                        hybrisUsername = "cq.admin";
                    }
                    if (this.options.authHandler instanceof OAuthHandler && "cq.admin".equals(hybrisUsername)) {
                        hybrisUsername = hybrisUsername + "@geometrixx.com";
                    }
                    this.signUp(userId, hybrisUsername, request, response);
                }
                finally {
                    signUpLocks.get(userId).unlock();
                }
            }
        }
        HybrisSessionInfo sessionInfo = new HybrisSessionInfo(hybrisUsername, anonymous, request, response, this.options.settingsService);
        Map<String, String> oldCookieInfo = HybrisSessionUtil.getCookieInfo((HttpServletRequest)request);
        String string = oldUsername = oldCookieInfo == null ? null : oldCookieInfo.get("username");
        if (sessionInfo.getCookieInfo() == null || sessionInfo.getCookieInfo().isEmpty() || !hybrisUsername.equals(oldUsername)) {
            Map<String, String> authData = this.options.userConnector.getHybrisCredentials(userId);
            if (this.options.authHandler instanceof OAuthHandler && !authData.containsKey("username") && anonymous) {
                authData.put("username", "anonymous");
            }
            try {
                Map<String, String> sessionData = this.options.authHandler.authenticateSession(authData);
                sessionInfo.setCookieInfo(sessionData);
                if (anonymous) {
                    String cartId;
                    String string2 = cartId = request.getCookie("HybrisCart") != null ? request.getCookie("HybrisCart").getValue() : null;
                    if (StringUtils.isNotBlank((String)cartId)) {
                        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.baseStoreId, sessionData, (Map<String, Object>)this.context);
                        this.connection.execute((HybrisCommand)new RestoreCartCommand(cartId), opts).release();
                    }
                }
            }
            catch (IllegalStateException x) {
                if (x.getCause() instanceof ConnectException) {
                    this.checkConnectException(new CommerceException("", x.getCause()), false);
                }
                throw x;
            }
        }
        return sessionInfo;
    }

    public CommerceSession login(SlingHttpServletRequest request, SlingHttpServletResponse response) throws CommerceException {
        HybrisSession session = (HybrisSession)request.getAttribute("com.adobe.cq.commerce.hybris.common.DefaultHybrisSession");
        if (session != null) {
            return session;
        }
        SessionInfo sessionInfo = this.fetchClientContextUserHybrisCredentials(request, response);
        session = this.options.hybrisFactory.getSession(this, request, response, sessionInfo);
        request.setAttribute("com.adobe.cq.commerce.hybris.common.DefaultHybrisSession", (Object)session);
        return session;
    }

    public HybrisConnection getConnection() {
        return this.connection;
    }

    public String getServer() {
        return this.connection.getServerUrl();
    }

    public String getCatalogVersion() {
        return this.options.catalogVersion;
    }

    public String getBaseStore() {
        return this.baseStoreId;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public Product getProduct(String path) throws CommerceException {
        return this.options.hybrisFactory.getProduct(this.resolver.getResource(path));
    }

    @Override
    public Product getProductByHybrisId(String productId) throws CommerceException {
        try {
            Product product = this.findProduct(this.baseStore.getPath(), productId);
            if (product == null) {
                ValueMap baseStoreProps = ResourceUtil.getValueMap((Resource)this.baseStore);
                String basePath = (String)baseStoreProps.get("cq:productsPath", String.class);
                if (basePath == null) {
                    basePath = "/etc/commerce/products/" + this.baseStoreId + "/" + HybrisUtil.findCatalogId(this.baseStore) + "/" + this.language;
                }
                log.debug("No product with id {} found under base store path {}. Searching in {} instead.", new Object[]{productId, this.baseStore.getPath(), basePath});
                return this.findProduct(basePath, productId);
            }
            return product;
        }
        catch (RepositoryException e) {
            log.error("Could not find product by URI", (Throwable)e);
            throw new CommerceException(e.getMessage(), (Throwable)e);
        }
    }

    private Product findProduct(String basePath, String productId) throws CommerceException, RepositoryException {
        Node n;
        Session session = (Session)this.resolver.adaptTo(Session.class);
        StringBuilder queryString = new StringBuilder("SELECT * FROM [nt:base] WHERE ISDESCENDANTNODE('");
        queryString.append(basePath);
        queryString.append("') AND [");
        queryString.append("cq:hybrisProductId");
        queryString.append("] = '");
        queryString.append(productId);
        queryString.append("'");
        Query q = session.getWorkspace().getQueryManager().createQuery(queryString.toString(), "JCR-SQL2");
        NodeIterator iter = q.execute().getNodes();
        if (iter.hasNext() && HybrisUtil.isProduct(this.resolver.getResource((n = iter.nextNode()).getPath()))) {
            return this.getProduct(n.getPath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActivated(Product product) throws CommerceException {
        Resource res = (Resource)product.adaptTo(Resource.class);
        String uri = HybrisUtil.createProductUri(res, this.options.productUriTemplate);
        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.baseStoreId, this.context);
        CommandResult result = null;
        try {
            result = this.connection.execute((HybrisCommand)new GetProductCommand(uri, this.language, HybrisUtil.isVariant(res), null), opts);
            boolean bl = result.success();
            return bl;
        }
        catch (CommerceException e) {
            this.checkConnectException(e, false);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
    }

    public void catalogRolloutHook(Page blueprint, Page catalog) throws CommerceException {
        Resource blueprintResource = blueprint.getContentResource();
        HierarchyNodeInheritanceValueMap blueprintProps = new HierarchyNodeInheritanceValueMap(blueprintResource);
        String basePath = (String)blueprintProps.getInherited("filter/basePath", (Object)"/etc/commerce/products");
        try {
            Resource productDataRoot = blueprintResource.getResourceResolver().getResource(basePath);
            if (productDataRoot != null) {
                ComponentInheritanceValueMap productDataProps = new ComponentInheritanceValueMap(productDataRoot);
                Node catalogNode = (Node)catalog.getContentResource().adaptTo(Node.class);
                catalogNode.setProperty("cq:hybrisBaseStore", (String)productDataProps.getInherited("cq:hybrisBaseStore", (Object)""));
                catalogNode.setProperty("cq:hybrisCatalogId", (String)productDataProps.getInherited("cq:hybrisCatalogId", (Object)""));
            }
        }
        catch (RepositoryException e) {
            throw new CommerceException("Catalog rollout hook failed: ", (Throwable)e);
        }
    }

    public void sectionRolloutHook(Page blueprint, Page section) {
    }

    public void productRolloutHook(Product productData, Page productPage, Product productReference) throws CommerceException {
        try {
            Node productReferenceNode = (Node)productReference.adaptTo(Node.class);
            productReferenceNode.setProperty("cq:hybrisProductId", productData.getSKU());
            Iterator variants = productData.getVariants();
            while (variants.hasNext()) {
                String jcrName;
                Product variant = (Product)variants.next();
                ValueMap values = (ValueMap)variant.adaptTo(ValueMap.class);
                if (!productReferenceNode.hasProperty("variationAxis") && values.get("variantAttribute.name", String[].class) != null) {
                    String leadAxis = (String)((ValueMap)productData.adaptTo(ValueMap.class)).get("leadAxis", String.class);
                    String axis = this.getVariantAxis(values, leadAxis);
                    productReferenceNode.setProperty("variationAxis", axis);
                    productReferenceNode.setProperty("variationTitle", StringUtils.capitalize((String)axis));
                }
                if (!productReferenceNode.hasNode(jcrName = JcrUtil.isValidName((String)variant.getSKU()) ? variant.getSKU() : JcrUtil.createValidName((String)variant.getSKU()))) continue;
                Node variantNode = productReferenceNode.getNode(jcrName);
                variantNode.setProperty("cq:hybrisProductId", variant.getSKU());
            }
        }
        catch (Exception e) {
            throw new CommerceException("Product rollout hook failed: ", (Throwable)e);
        }
    }

    private String getVariantAxis(ValueMap values, String leadAxis) {
        String[] attrs = (String[])values.get("variantAttribute.name", String[].class);
        if (attrs != null && attrs.length > 0) {
            return Arrays.asList(attrs).contains(leadAxis) ? leadAxis : attrs[0];
        }
        return (String)values.get("variantAttribute.name", String.class);
    }

    public Voucher getVoucher(String s) throws CommerceException {
        return null;
    }

    public List<String> getCountries() throws CommerceException {
        ArrayList<String> countries = new ArrayList<String>();
        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.baseStoreId, this.context);
        CommandResult result = null;
        try {
            result = this.connection.execute((HybrisCommand)new GenericHybrisCommand("/deliverycountries"), opts);
            if (result.success()) {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(result.getBody());
                NodeList list = doc.getElementsByTagName("isocode");
                for (int i = 0; i < list.getLength(); ++i) {
                    countries.add(list.item(i).getTextContent());
                }
            } else {
                countries.add("*");
            }
        }
        catch (CommerceException e) {
            this.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Loading shipping countries failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return countries;
    }

    public List<String> getCreditCardTypes() throws CommerceException {
        ArrayList<String> ccTypes = new ArrayList<String>();
        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.baseStoreId, this.context);
        CommandResult result = null;
        try {
            result = this.connection.execute((HybrisCommand)new GenericHybrisCommand("/cardtypes"), opts);
            if (result.success()) {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(result.getBody());
                NodeList list = doc.getElementsByTagName("code");
                for (int i = 0; i < list.getLength(); ++i) {
                    ccTypes.add(list.item(i).getTextContent());
                }
            } else {
                ccTypes.add("*");
            }
        }
        catch (CommerceException e) {
            this.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Loading credit cart types failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return ccTypes;
    }

    protected String getSearchProviderName() {
        return "DefaultHybrisSearch";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean pingHybris(HybrisConnection connection, HybrisConnection.ConnectionOptions opts) {
        CommandResult result = null;
        try {
            result = connection.execute((HybrisCommand)new GenericHybrisCommand("/catalogs"), opts);
            if (!result.success()) {
                log.warn("Get catalogs command was not successful, considering hybris offline");
                boolean bl = false;
                return bl;
            }
        }
        catch (CommerceException x) {
            Throwable cause = x.getCause();
            if (cause instanceof ConnectException) {
                log.warn("Could not get catalogs, considering hybris offline: " + cause.getMessage());
            } else {
                log.warn("Could not get catalogs, considering hybris offline.", (Throwable)x);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.warn("Could not get catalogs, considering hybris offline.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return true;
    }

    public boolean isAvailable(String serviceType) {
        if ("commerce-service".equals(serviceType)) {
            if (pinging || (System.currentTimeMillis() - lastPing) / 60000L < (long)this.options.pingInterval) {
                return hybrisOnline;
            }
            pinging = true;
            hybrisOnline = DefaultHybrisService.pingHybris(this.connection, new HybrisConnection.ConnectionOptions(this.baseStoreId, this.context));
            lastPing = System.currentTimeMillis();
            pinging = false;
            return hybrisOnline;
        }
        return false;
    }

    @Override
    public boolean checkConnectException(CommerceException x, boolean rethrow) throws CommerceException {
        Throwable cause = x.getCause();
        if (cause instanceof ConnectException) {
            hybrisOnline = false;
            log.error("Hybris server is not available: " + cause.getMessage());
            if (rethrow) {
                throw x;
            }
            return true;
        }
        if (rethrow) {
            throw x;
        }
        log.warn("", (Throwable)x);
        return false;
    }

    public List<String> getOrderPredicates() throws CommerceException {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add("openOrders");
        return predicates;
    }

    public List<Promotion> getAvailablePromotions(ResourceResolver resourceResolver) throws CommerceException {
        ArrayList<Promotion> promotions = new ArrayList<Promotion>();
        if (!(this.serviceContext().authHandler instanceof OAuthHandler)) {
            return promotions;
        }
        final String accessToken = ((OAuthHandler)this.serviceContext().authHandler).getAccessToken();
        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.baseStoreId, this.context);
        CommandResult result = null;
        try {
            GenericHybrisCommand command = new GenericHybrisCommand("/promotions"){
                {
                    super(x0);
                    this.addParameter("type", "all");
                    this.addParameter("access_token", accessToken);
                }
            };
            result = this.serviceContext().connection.execute((HybrisCommand)command, opts);
            if (result.success()) {
                XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
                XMLEventReader xml = xmlFactory.createXMLEventReader(result.getBody());
                for (Map<String, Object> promotionData : this.serviceContext().parser.parsePromotions(xml)) {
                    String code = (String)promotionData.get("code");
                    String type = (String)promotionData.get("promotionType");
                    String description = (String)promotionData.get("description");
                    Date endDate = (Date)promotionData.get("endDate");
                    DefaultHybrisPromotion promotion = new DefaultHybrisPromotion(code, description, description, type, endDate);
                    promotions.add(promotion);
                }
            }
        }
        catch (CommerceException e) {
            this.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Loading promotions failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return promotions;
    }
}

