/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PlacedOrder;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import com.adobe.cq.commerce.common.PriceFilter;
import com.adobe.cq.commerce.hybris.HybrisSession;
import com.adobe.cq.commerce.hybris.HybrisUtil;
import com.adobe.cq.commerce.hybris.SessionInfo;
import com.adobe.cq.commerce.hybris.api.HybrisService;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisCartEntry;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisPlacedOrder;
import com.adobe.cq.commerce.hybris.common.HybrisConfiguration;
import com.adobe.cq.commerce.hybris.connection.AbstractHybrisCommand;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.cmd.AddAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.AddCartEntryCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.AddPaymentInfoCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.AuthorizePaymentCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.CheckoutCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.DeleteCartEntryCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.GenericHybrisCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.GetCartCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.GetProductCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.LogoutCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.ModifyCartEntryCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.RedeemVoucherCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.ReleaseVoucherCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.SetDeliveryAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.SetDeliveryModeCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.UpdateAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.UpdatePaymentAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.UpdatePaymentInfoCommand;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import com.adobe.cq.commerce.hybris.importer.XMLEventReaderUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHybrisSession
implements HybrisSession {
    private final Logger log = LoggerFactory.getLogger((String)DefaultHybrisSession.class.getName());
    private final HybrisConfiguration config;
    private final HybrisConnection connection;
    private final HybrisService hybrisService;
    private final HybrisResponseParser parser;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private SessionInfo sessionInfo;
    private boolean cartCacheDirty = true;
    private ValueMap cartValues;
    private List<CommerceSession.CartEntry> cartEntries = new ArrayList<CommerceSession.CartEntry>();
    private List<PriceInfo> prices;
    private Locale userLocale = null;

    DefaultHybrisSession(HybrisConfiguration config, HybrisService hybrisService, SlingHttpServletRequest request, SessionInfo sessionInfo) {
        this(config, hybrisService, request, null, sessionInfo);
    }

    DefaultHybrisSession(HybrisConfiguration config, HybrisService hybrisService, SlingHttpServletRequest request, SlingHttpServletResponse response, SessionInfo sessionInfo) {
        this.config = config;
        this.connection = config.connection;
        this.hybrisService = hybrisService;
        this.parser = config.parser;
        this.request = request;
        this.response = response;
        this.sessionInfo = sessionInfo;
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    @Override
    public CommerceService getCommerceService() {
        return this.hybrisService;
    }

    @Override
    public String getBaseStore() {
        return this.config.baseStore;
    }

    public void logout() throws CommerceException {
        try {
            this.connection.execute(new LogoutCommand(), this.config.baseStore, this).release();
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
        this.sessionInfo.setCookieInfo(null);
    }

    public void setUserLocale(Locale locale) {
        this.userLocale = locale;
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }

    public Map<String, String> getProfile() throws CommerceException {
        HashMap<String, String> profile = new HashMap<String, String>();
        Map<String, Object> values = this.doGetProfile();
        for (String key : values.keySet()) {
            if (!(values.get(key) instanceof String)) continue;
            profile.put(key, (String)values.get(key));
        }
        return profile;
    }

    private Map<String, Object> doGetProfile() throws CommerceException {
        CommandResult result = null;
        try {
            result = this.connection.execute(new GenericHybrisCommand("/customers/current"), this.config.baseStore, this);
            if (result.success()) {
                XMLEventReader xml = XMLInputFactory.newInstance().createXMLEventReader(result.getBody());
                Map<String, Object> map = this.parser.parseProfile(xml);
                return map;
            }
        }
        catch (CommerceException e) {
            this.hybrisService.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Loading profile failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return null;
    }

    public String getPriceInfo(Product product) throws CommerceException {
        List<PriceInfo> prices = this.getProductPriceInfo(product);
        return prices.size() > 0 ? prices.get(0).getFormattedString() : null;
    }

    public List<PriceInfo> getProductPriceInfo(Product product) throws CommerceException {
        return this.getProductPriceInfo(product, null);
    }

    public List<PriceInfo> getProductPriceInfo(Product product, Predicate filter) throws CommerceException {
        ArrayList<PriceInfo> prices = new ArrayList<PriceInfo>();
        Resource resource = (Resource)product.adaptTo(Resource.class);
        String uri = HybrisUtil.createProductUri(resource, this.config.productUriTemplate);
        boolean variant = HybrisUtil.isVariant(resource);
        HybrisConnection.ConnectionOptions opts = new HybrisConnection.ConnectionOptions(this.config.baseStore, this, (Map<String, Object>)this.hybrisService.getContext());
        CommandResult result = null;
        try {
            result = this.connection.execute((HybrisCommand)new GetProductCommand(uri, this.hybrisService.getLanguage(), variant, this.config.parser.getConfiguredProductAttributes(variant)), opts);
            if (result.success()) {
                XMLEventReader xml = XMLInputFactory.newInstance().createXMLEventReader(result.getBody());
                Map<String, Object> data = this.parser.parseProductData(xml, variant);
                if (data.containsKey("prices")) {
                    List pricesData = (List)data.get("prices");
                    for (Object pi : pricesData) {
                        prices.add((PriceInfo)pi);
                    }
                }
                CollectionUtils.filter(prices, (Predicate)filter);
            }
        }
        catch (CommerceException e) {
            this.hybrisService.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Parsing product data failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return prices;
    }

    public String getProductPrice(Product product) throws CommerceException {
        return this.getProductPrice(product, null);
    }

    public String getProductPrice(Product product, Predicate filter) throws CommerceException {
        List<PriceInfo> prices = this.getProductPriceInfo(product, filter);
        return prices.size() > 0 ? prices.get(0).getFormattedString() : null;
    }

    public boolean supportsClientsidePromotionResolution() {
        return false;
    }

    public void addPromotion(String path) throws CommerceException {
        Promotion p;
        Resource r = this.request.getResourceResolver().getResource(path);
        Promotion promotion = p = r == null ? null : (Promotion)r.adaptTo(Promotion.class);
        if (p == null) {
            throw new CommerceException("Invalid promotion path: " + path);
        }
        ValueMap properties = (ValueMap)r.adaptTo(ValueMap.class);
        String hybrisVoucherCode = (String)properties.get("hybrisVoucherCode", (Object)"");
        if (hybrisVoucherCode.length() > 0) {
            this.addVoucher(hybrisVoucherCode);
        }
    }

    public void removePromotion(String path) throws CommerceException {
        ValueMap properties;
        String hybrisVoucherCode;
        Promotion p;
        Resource r = this.request.getResourceResolver().getResource(path);
        Promotion promotion = p = r == null ? null : (Promotion)r.adaptTo(Promotion.class);
        if (p != null && (hybrisVoucherCode = (String)(properties = (ValueMap)r.adaptTo(ValueMap.class)).get("hybrisVoucherCode", (Object)"")).length() > 0) {
            this.removeVoucher(hybrisVoucherCode);
        }
    }

    public List<PromotionInfo> getPromotions() throws CommerceException {
        this.refreshLocalShoppingCartCache();
        return this.collectPromotions(this.cartValues);
    }

    protected List<PromotionInfo> collectPromotions(ValueMap values) {
        PromotionInfo info;
        Object firedMessages;
        Map promo;
        Map appliedPromo;
        List promos;
        ArrayList<PromotionInfo> appliedPromotions = new ArrayList<PromotionInfo>();
        if (values.containsKey((Object)"appliedProductPromotions")) {
            promos = (List)values.get((Object)"appliedProductPromotions");
            for (Object item : promos) {
                appliedPromo = (Map)item;
                promo = (Map)appliedPromo.get("promotionData");
                firedMessages = promo.get("firedMessages");
                if (firedMessages instanceof List) {
                    firedMessages = StringUtils.join((Collection)((List)firedMessages), (String)" ");
                }
                info = new PromotionInfo((String)promo.get("code"), (String)promo.get("code"), PromotionInfo.PromotionStatus.FIRED, (String)promo.get("description"), (String)firedMessages, (Integer)appliedPromo.get("orderEntryNumber"));
                appliedPromotions.add(info);
            }
        }
        if (values.containsKey((Object)"appliedOrderPromotions")) {
            promos = (List)values.get((Object)"appliedOrderPromotions");
            for (Object item : promos) {
                appliedPromo = (Map)item;
                promo = (Map)appliedPromo.get("promotionData");
                firedMessages = promo.get("firedMessages");
                if (firedMessages instanceof List) {
                    firedMessages = StringUtils.join((Collection)((List)firedMessages), (String)" ");
                }
                info = new PromotionInfo((String)promo.get("code"), (String)promo.get("code"), PromotionInfo.PromotionStatus.FIRED, (String)promo.get("description"), (String)firedMessages, null);
                appliedPromotions.add(info);
            }
        }
        return appliedPromotions;
    }

    protected void refreshLocalShoppingCartCache() throws CommerceException {
        if (this.cartCacheDirty) {
            CommandResult result = null;
            try {
                result = this.connection.execute(new GetCartCommand(this.userLocale), this.config.baseStore, this);
                if (result.success()) {
                    XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
                    XMLEventReader xml = xmlFactory.createXMLEventReader(result.getBody());
                    this.cartValues = new ValueMapDecorator(this.parser.parseCart(xml));
                    if (this.sessionInfo.isAnonymous() && this.cartValues.containsKey((Object)"guid")) {
                        Cookie cartIdCookie = new Cookie("HybrisCart", (String)this.cartValues.get((Object)"guid"));
                        cartIdCookie.setPath("/");
                        cartIdCookie.setMaxAge(Integer.MAX_VALUE);
                        this.response.addCookie(cartIdCookie);
                    }
                    this.cartEntries.clear();
                    if (this.cartValues.containsKey((Object)"entries")) {
                        List entries = (List)this.cartValues.get("entries", List.class);
                        for (int i = 0; i < entries.size(); ++i) {
                            Map entryValues = (Map)entries.get(i);
                            this.cartEntries.add(this.newCartEntryImpl(entryValues));
                        }
                    }
                    this.prices = new ArrayList<PriceInfo>();
                    this.prices.add(this.addPriceTypes((PriceInfo)this.cartValues.get("totalPrice", PriceInfo.class), "ORDER"));
                    this.prices.add(this.addPriceTypes((PriceInfo)this.cartValues.get("subTotal", PriceInfo.class), "PRE_TAX"));
                    if (this.cartValues.containsKey((Object)"totalTax")) {
                        this.prices.add(this.addPriceTypes((PriceInfo)this.cartValues.get("totalTax", PriceInfo.class), "TAX"));
                    }
                    if (this.cartValues.containsKey((Object)"deliveryCost")) {
                        this.prices.add(this.addPriceTypes((PriceInfo)this.cartValues.get("deliveryCost", PriceInfo.class), "SHIPPING"));
                    }
                    if (this.cartValues.containsKey((Object)"deliveryAddress")) {
                        Map shippingAddress = (Map)this.cartValues.get("deliveryAddress", Map.class);
                        this.putAllWithPrefix((Map<String, Object>)this.cartValues, shippingAddress, "shipping.");
                    }
                    if (this.cartValues.containsKey((Object)"paymentInfo")) {
                        Map paymentInfo = (Map)this.cartValues.get("paymentInfo", Map.class);
                        this.putAllWithPrefix((Map<String, Object>)this.cartValues, paymentInfo, "payment.");
                        if (paymentInfo.containsKey("billingAddress")) {
                            Map billingAddress = (Map)paymentInfo.get("billingAddress");
                            this.putAllWithPrefix((Map<String, Object>)this.cartValues, billingAddress, "billing.");
                        } else {
                            Map<String, Object> profile = this.doGetProfile();
                            if (profile != null && profile.containsKey("defaultAddress")) {
                                Map defaultAddress = (Map)profile.get("defaultAddress");
                                this.putAllWithPrefix((Map<String, Object>)this.cartValues, defaultAddress, "billing.");
                            }
                        }
                    }
                }
            }
            catch (CommerceException x) {
                if (this.hybrisService.checkConnectException(x, false)) {
                    return;
                }
                throw x;
            }
            catch (Exception e) {
                throw new CommerceException("Refreshing cart failed: ", (Throwable)e);
            }
            finally {
                if (result != null) {
                    result.release();
                }
            }
            this.cartCacheDirty = false;
        }
    }

    public DefaultHybrisCartEntry newCartEntryImpl(Map<String, Object> entry) {
        return new DefaultHybrisCartEntry(this, entry);
    }

    private void putAllWithPrefix(Map<String, Object> out, Map<String, Object> in, String prefix) {
        for (String key : in.keySet()) {
            out.put(prefix + key, in.get(key));
        }
    }

    private PriceInfo addPriceTypes(PriceInfo pi, String ... types) {
        pi.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList(types)));
        return pi;
    }

    public int getCartEntryCount() throws CommerceException {
        this.refreshLocalShoppingCartCache();
        return (Integer)this.cartValues.get("totalItems", Integer.class);
    }

    public List<CommerceSession.CartEntry> getCartEntries() throws CommerceException {
        this.refreshLocalShoppingCartCache();
        return this.cartEntries;
    }

    public String getCartPreTaxPrice() throws CommerceException {
        return this.getCartPrice((Predicate)new PriceFilter(new String[]{"PRE_TAX"}));
    }

    public String getCartTax() throws CommerceException {
        return this.getCartPrice((Predicate)new PriceFilter(new String[]{"TAX"}));
    }

    public String getCartTotalPrice() throws CommerceException {
        return this.getCartPrice((Predicate)new PriceFilter(new String[]{"ORDER"}));
    }

    public String getOrderShipping() throws CommerceException {
        return this.getCartPrice((Predicate)new PriceFilter(new String[]{"SHIPPING"}));
    }

    public String getOrderTotalTax() throws CommerceException {
        return this.getCartTax();
    }

    public String getOrderTotalPrice() throws CommerceException {
        return this.getCartTotalPrice();
    }

    public List<PriceInfo> getCartPriceInfo(Predicate filter) throws CommerceException {
        this.refreshLocalShoppingCartCache();
        if (filter != null) {
            ArrayList<PriceInfo> filteredPrices = new ArrayList<PriceInfo>();
            CollectionUtils.select(this.prices, (Predicate)filter, filteredPrices);
            return filteredPrices;
        }
        return this.prices;
    }

    public String getCartPrice(Predicate filter) throws CommerceException {
        List<PriceInfo> prices = this.getCartPriceInfo(filter);
        return prices.isEmpty() ? "" : prices.get(0).getFormattedString();
    }

    public void addCartEntry(Product product, int quantity) throws CommerceException {
        this.cartCacheDirty = true;
        Resource resource = (Resource)product.adaptTo(Resource.class);
        AddCartEntryCommand cmd = new AddCartEntryCommand(HybrisUtil.getProductId(resource), quantity, this.userLocale);
        try {
            this.connection.execute(cmd, this.config.baseStore, this).release();
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
    }

    public void modifyCartEntry(int entryNumber, int quantity) throws CommerceException {
        this.cartCacheDirty = true;
        ModifyCartEntryCommand cmd = new ModifyCartEntryCommand(entryNumber, quantity, this.userLocale);
        try {
            this.connection.execute(cmd, this.config.baseStore, this).release();
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
    }

    public void deleteCartEntry(int entryNumber) throws CommerceException {
        this.cartCacheDirty = true;
        DeleteCartEntryCommand cmd = new DeleteCartEntryCommand(entryNumber);
        try {
            this.connection.execute(cmd, this.config.baseStore, this).release();
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
    }

    public void addVoucher(String couponCode) throws CommerceException {
        this.cartCacheDirty = true;
        RedeemVoucherCommand cmd = new RedeemVoucherCommand(couponCode);
        try {
            this.connection.execute(cmd, this.config.baseStore, this).release();
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
    }

    public void removeVoucher(String couponCode) throws CommerceException {
        this.cartCacheDirty = true;
        ReleaseVoucherCommand cmd = new ReleaseVoucherCommand(couponCode);
        try {
            this.connection.execute(cmd, this.config.baseStore, this).release();
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
    }

    public List<Voucher> getVouchers() throws CommerceException {
        return new ArrayList<Voucher>();
    }

    public List<VoucherInfo> getVoucherInfos() throws CommerceException {
        return this.collectVouchers(this.cartValues);
    }

    protected List<VoucherInfo> collectVouchers(ValueMap values) {
        ArrayList<VoucherInfo> voucherInfos = new ArrayList<VoucherInfo>();
        if (values.containsKey((Object)"appliedVouchers")) {
            List appliedVouchers = (List)values.get("appliedVouchers", List.class);
            for (Object o : appliedVouchers) {
                Map voucher = (Map)o;
                voucherInfos.add(new VoucherInfo((String)voucher.get("voucherCode"), (String)voucher.get("code"), (String)voucher.get("name"), (String)voucher.get("description"), true, (String)voucher.get("description")));
            }
        }
        return voucherInfos;
    }

    public String getOrderId() throws CommerceException {
        this.refreshLocalShoppingCartCache();
        return (String)this.cartValues.get("code", String.class);
    }

    public void updateOrderDetails(Map<String, String> delta) throws CommerceException {
        this.updateOrder(new HashMap<String, Object>(delta));
    }

    public void updateOrder(Map<String, Object> delta) throws CommerceException {
        try {
            this.updateOrder0(delta);
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrder0(Map<String, Object> delta) throws CommerceException {
        String deliveryMode;
        boolean shippingAddressSame = StringUtils.isNotEmpty((String)((String)delta.get("shippingAddressSameAsBilling")));
        String shippingAddressId = (String)delta.get("shippingAddressId");
        String paymentInfoId = (String)delta.get("paymentInfoId");
        Map<String, Object> paymentInfo = new HashMap<String, Object>();
        HashMap<String, Object> billingAddress = new HashMap<String, Object>();
        HashMap<String, Object> shippingAddress = new HashMap<String, Object>();
        for (Map.Entry<String, Object> detail : delta.entrySet()) {
            String key = detail.getKey();
            if (key.startsWith("billing.")) {
                billingAddress.put(key.substring("billing.".length()), detail.getValue());
                if (!shippingAddressSame) continue;
                shippingAddress.put(key.substring("billing.".length()), detail.getValue());
                continue;
            }
            if (key.startsWith("shipping.")) {
                shippingAddress.put(key.substring("shipping.".length()), detail.getValue());
                continue;
            }
            if (!key.startsWith("payment.") || key.equals("payment.ccv")) continue;
            paymentInfo.put(key.substring("payment.".length()), detail.getValue());
        }
        if (!shippingAddress.isEmpty()) {
            AbstractHybrisCommand cmd;
            Map<String, Object> hybrisAddress;
            try {
                hybrisAddress = this.parser.mapAddressFields(shippingAddress, false);
            }
            catch (Exception e) {
                throw new CommerceException("Mapping address fields failed", (Throwable)e);
            }
            if (StringUtils.isNotEmpty((String)shippingAddressId)) {
                cmd = new UpdateAddressCommand(shippingAddressId, hybrisAddress, this.config.hybrisVersion);
                this.connection.execute(cmd, this.config.baseStore, this).release();
            } else {
                cmd = new AddAddressCommand(hybrisAddress);
                CommandResult result = this.connection.execute(cmd, this.config.baseStore, this);
                try {
                    XMLEventReader xml = XMLEventReaderUtil.createReader(result.getBody());
                    shippingAddressId = (String)this.parser.parseAddress(xml).get("id");
                    this.connection.execute(new SetDeliveryAddressCommand(shippingAddressId), this.config.baseStore, this).release();
                }
                catch (Exception e) {
                    this.log.error("Parsing address failed: ", (Throwable)e);
                }
                finally {
                    result.release();
                }
            }
        }
        if ((deliveryMode = HybrisUtil.fetchHybrisDeliveryMode(delta)) != null) {
            this.connection.execute(new SetDeliveryModeCommand(deliveryMode), this.config.baseStore, this).release();
        }
        if (!paymentInfo.isEmpty() || !billingAddress.isEmpty()) {
            Map<String, Object> hybrisAddress;
            try {
                paymentInfo = this.parser.mapPaymentInfoFields(paymentInfo, false);
                hybrisAddress = this.parser.mapAddressFields(billingAddress, false);
            }
            catch (Exception e) {
                throw new CommerceException("Mapping payment info or address fields failed: ", (Throwable)e);
            }
            if (StringUtils.isNotEmpty((String)paymentInfoId)) {
                this.connection.execute(new UpdatePaymentInfoCommand(paymentInfoId, paymentInfo), this.config.baseStore, this).release();
                this.connection.execute(new UpdatePaymentAddressCommand(paymentInfoId, hybrisAddress), this.config.baseStore, this).release();
            } else {
                this.putAllWithPrefix(paymentInfo, hybrisAddress, "billingAddress.");
                paymentInfo.put("saved", "true");
                this.connection.execute(new AddPaymentInfoCommand(paymentInfo), this.config.baseStore, this).release();
            }
        }
        this.cartCacheDirty = true;
    }

    public Map<String, Object> getOrder() throws CommerceException {
        this.refreshLocalShoppingCartCache();
        return this.cartValues;
    }

    public Map<String, String> getOrderDetails() throws CommerceException {
        this.refreshLocalShoppingCartCache();
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.cartValues.keySet()) {
            String value = (String)this.cartValues.get(key, String.class);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public void submitOrder(Map<String, String> delta) throws CommerceException {
        this.placeOrder(new HashMap<String, Object>(delta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void placeOrder(Map<String, Object> delta) throws CommerceException {
        this.updateOrder(delta);
        String ccv = (String)delta.get("payment.ccv");
        CommandResult result = null;
        try {
            result = this.connection.execute(new AuthorizePaymentCommand(ccv), this.config.baseStore, this);
            if (result.success()) {
                this.connection.execute(new CheckoutCommand(), this.config.baseStore, this).release();
                this.cartCacheDirty = true;
            }
        }
        catch (CommerceException x) {
            this.hybrisService.checkConnectException(x, true);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
    }

    protected Set<String> getOpenOrderStatuses() {
        HashSet<String> statuses = new HashSet<String>();
        statuses.add("processing");
        statuses.add("assigned.admin");
        statuses.add("pending.approval");
        statuses.add("pending.merchant.approval");
        statuses.add("cancelling");
        statuses.add("quote.approved");
        statuses.add("open");
        statuses.add("approved");
        statuses.add("created");
        statuses.add("merchant.approved");
        statuses.add("pending.quote");
        return statuses;
    }

    public List<PlacedOrder> getPlacedOrders(String predicate) throws CommerceException {
        ArrayList<PlacedOrder> placedOrderList = new ArrayList<PlacedOrder>();
        CommandResult result = null;
        try {
            result = this.connection.execute(new GenericHybrisCommand("/orders"), this.config.baseStore, this);
            if (result.success()) {
                XMLEventReader xml = XMLInputFactory.newInstance().createXMLEventReader(result.getBody());
                for (Map<String, String> orderMap : this.parser.parseOrders(xml)) {
                    String status;
                    String code = orderMap.get("code");
                    if (code == null || (status = orderMap.get("statusDisplay")) == null || (status = status.trim()).length() == 0) continue;
                    if ("openOrders".equals(predicate)) {
                        status = status.toLowerCase();
                        if (!this.getOpenOrderStatuses().contains(status)) continue;
                    }
                    placedOrderList.add(this.getPlacedOrder(code));
                }
            }
        }
        catch (CommerceException e) {
            this.hybrisService.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Loading profile failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return placedOrderList;
    }

    public PlacedOrder getPlacedOrder(String orderId) throws CommerceException {
        DefaultHybrisPlacedOrder placedOrder = null;
        CommandResult result = null;
        try {
            result = this.connection.execute(new GenericHybrisCommand("/orders/" + orderId), this.config.baseStore, this);
            if (result.success()) {
                PriceInfo totalPriceWithTax;
                PriceInfo totalTax;
                PriceInfo deliveryCost;
                Map billingAddressMap;
                Map paymentInfoMap;
                XMLEventReader xml = XMLInputFactory.newInstance().createXMLEventReader(result.getBody());
                Map<String, Object> orderMap = this.parser.parseOrder(xml);
                placedOrder = this.newPlacedOrderImpl(orderId);
                Map<String, Object> orderDetails = placedOrder.getOrder();
                Date created = (Date)orderMap.get("created");
                if (created != null) {
                    orderDetails.put("orderPlacedFormatted", new SimpleDateFormat("dd MMM, yyyy").format(created));
                }
                orderDetails.put("orderStatus", orderMap.get("statusDisplay"));
                Map shippingAddressMap = (Map)orderMap.get("deliveryAddress");
                if (shippingAddressMap != null) {
                    orderDetails.put("shipping.firstname", shippingAddressMap.get("firstName"));
                    orderDetails.put("shipping.lastname", shippingAddressMap.get("lastName"));
                    orderDetails.put("shipping.street1", shippingAddressMap.get("street1"));
                    orderDetails.put("shipping.street2", shippingAddressMap.get("street2"));
                    orderDetails.put("shipping.city", shippingAddressMap.get("city"));
                    orderDetails.put("shipping.country", shippingAddressMap.get("country"));
                    orderDetails.put("shipping.zip", shippingAddressMap.get("postalCode"));
                }
                if ((paymentInfoMap = (Map)orderMap.get("paymentInfo")) != null && (billingAddressMap = (Map)paymentInfoMap.get("billingAddress")) != null) {
                    orderDetails.put("billing.firstname", billingAddressMap.get("firstName"));
                    orderDetails.put("billing.lastname", billingAddressMap.get("lastName"));
                    orderDetails.put("billing.street1", billingAddressMap.get("street1"));
                    orderDetails.put("billing.street2", billingAddressMap.get("street2"));
                    orderDetails.put("billing.city", billingAddressMap.get("city"));
                    orderDetails.put("billing.country", billingAddressMap.get("country"));
                    orderDetails.put("billing.zip", billingAddressMap.get("postalCode"));
                }
                ArrayList<PriceInfo> priceList = new ArrayList<PriceInfo>();
                PriceInfo subTotal = (PriceInfo)orderMap.get("subTotal");
                if (subTotal != null) {
                    subTotal.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "PRE_TAX", subTotal.getCurrency().getCurrencyCode())));
                    priceList.add(subTotal);
                }
                if ((deliveryCost = (PriceInfo)orderMap.get("deliveryCost")) != null) {
                    deliveryCost.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "SHIPPING", deliveryCost.getCurrency().getCurrencyCode())));
                    priceList.add(deliveryCost);
                }
                if ((totalTax = (PriceInfo)orderMap.get("totalTax")) != null) {
                    totalTax.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "TAX", totalTax.getCurrency().getCurrencyCode())));
                    priceList.add(totalTax);
                }
                if ((totalPriceWithTax = (PriceInfo)orderMap.get("totalPriceWithTax")) != null) {
                    totalPriceWithTax.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "ORDER", totalPriceWithTax.getCurrency().getCurrencyCode())));
                    priceList.add(totalPriceWithTax);
                }
                placedOrder.setPrices(priceList);
                List entryList = (List)orderMap.get("entries");
                ArrayList<CommerceSession.CartEntry> cartEntryList = new ArrayList<CommerceSession.CartEntry>();
                for (Map entry : entryList) {
                    DefaultHybrisCartEntry cartEntry = this.newCartEntryImpl(entry);
                    cartEntryList.add(cartEntry);
                }
                placedOrder.setEntries(cartEntryList);
                ValueMapDecorator promoValues = new ValueMapDecorator(orderMap);
                placedOrder.setPromotions(this.collectPromotions((ValueMap)promoValues));
                placedOrder.setVouchers(this.collectVouchers((ValueMap)promoValues));
            }
        }
        catch (CommerceException e) {
            this.hybrisService.checkConnectException(e, true);
        }
        catch (Exception e) {
            throw new CommerceException("Loading profile failed: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
        return placedOrder;
    }

    public DefaultHybrisPlacedOrder newPlacedOrderImpl(String orderId) {
        return new DefaultHybrisPlacedOrder(orderId);
    }
}

