/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.ProfileSynchronizer;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.connection.AbstractHybrisCommand;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.cmd.AddAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.SetDefaultAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.UpdateAddressCommand;
import com.adobe.cq.commerce.hybris.connection.cmd.UpdateProfileCommand;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import com.adobe.cq.commerce.hybris.importer.XMLEventReaderUtil;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.UserPropertiesService;
import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.xml.stream.XMLEventReader;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
public class DefaultProfileSynchronizer
implements ProfileSynchronizer {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final String PROFILE_PATH_REGEXP = "/home/.*/profile/.*";
    private static final String ADDRESS_BOOK_PATH = "addresses";
    private static final String PN_REP_PRINCIPAL_NAME = "rep:principalName";
    private static final String PN_DEFAULT_ADDRESS = "cq:defaultAddress";
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private UserPropertiesService userPropertiesService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private UserConnector userConnector;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private HybrisFactory hybrisFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisConnection connection;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisResponseParser parser;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisAuthenticationHandler authHandler;
    private Session adminSession = null;
    private ProfileObserver observer = null;
    private UserManager userManager = null;
    private ResourceResolver adminResolver = null;

    @Activate
    protected void activate() {
        this.log.info("Hybris user profile synchronization component starting.");
        try {
            this.adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            this.adminSession = (Session)this.adminResolver.adaptTo(Session.class);
            this.userManager = (UserManager)this.adminResolver.adaptTo(UserManager.class);
        }
        catch (Exception e) {
            this.observer = null;
            this.log.error("Unable to acquire hybris commerce service: ", (Throwable)e);
        }
        try {
            ObservationManager observationMgr = this.adminSession.getWorkspace().getObservationManager();
            int eventTypes = 63;
            boolean isDeep = true;
            String[] uuids = null;
            String[] nodeTypeNames = null;
            boolean noLocal = true;
            this.observer = new ProfileObserver();
            observationMgr.addEventListener((EventListener)this.observer, eventTypes, "/home/users/", isDeep, uuids, nodeTypeNames, noLocal);
        }
        catch (RepositoryException e) {
            this.observer = null;
            this.log.error("Unable to establish observer on repository: ", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.adminSession != null) {
            if (this.observer != null) {
                try {
                    this.adminSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this.observer);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            this.adminSession.logout();
            this.adminSession = null;
            this.adminResolver = null;
            this.userManager = null;
        }
    }

    private String getHome(String path) throws RepositoryException {
        Node node;
        Item item = this.adminSession.getItem(path);
        Node node2 = node = item.isNode() ? (Node)item : item.getParent();
        while (node != null) {
            if (node.isNode() && node.hasProperty(PN_REP_PRINCIPAL_NAME)) {
                return node.getPath();
            }
            node = node.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUser(String path) {
        ResourceResolver userResolver = null;
        try {
            Authorizable user = this.userManager.getAuthorizableByPath(path);
            String hybrisUsername = this.userConnector.getHybrisUsername(user.getID());
            if (hybrisUsername != null) {
                HashMap<String, String> authInfo = new HashMap<String, String>();
                authInfo.put("user.impersonation", user.getID());
                userResolver = this.resolverFactory.getAdministrativeResourceResolver(authInfo);
                Session userSession = (Session)userResolver.adaptTo(Session.class);
                UserPropertiesManager upm = this.userPropertiesService.createUserPropertiesManager(userSession, userResolver);
                UserProperties profile = upm.getUserProperties(user.getID(), "profile");
                Map<String, String> hybrisAuthInfo = this.userConnector.getHybrisCredentials(user.getID());
                Map<String, String> hybrisSessionInfo = this.authHandler.authenticateSession(hybrisAuthInfo);
                HybrisConnection.ConnectionOptions options = new HybrisConnection.ConnectionOptions(this.hybrisFactory.getServiceContext().baseStore, hybrisSessionInfo, Collections.<String, Object>emptyMap());
                this.syncProfile(profile, options);
            }
        }
        catch (IllegalStateException x) {
            if (x.getCause() instanceof ConnectException) {
                this.log.error("Hybris server is not available: " + x.getCause().getMessage());
            } else {
                this.log.error("Failed to synchronize hybris user profile: ", (Throwable)x);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to synchronize hybris user profile: ", (Throwable)e);
        }
        finally {
            if (userResolver != null) {
                userResolver.close();
            }
        }
    }

    @Override
    public void syncProfile(UserProperties profile, HybrisConnection.ConnectionOptions options) throws CommerceException {
        if (profile != null) {
            try {
                ValueMap values = ResourceUtil.getValueMap((Resource)profile.getResource("."));
                Map<String, Object> hybrisProfile = this.parser.mapProfileFields((Map<String, Object>)values, false);
                UpdateProfileCommand cmd = new UpdateProfileCommand(hybrisProfile);
                this.connection.execute((HybrisCommand)cmd, options).release();
                Resource addressBook = profile.getResource(ADDRESS_BOOK_PATH);
                if (addressBook != null) {
                    this.syncAddressBook(addressBook, options);
                } else {
                    this.syncDefaultAddress(profile, options);
                }
            }
            catch (Exception e) {
                throw new CommerceException("Could not sync profile", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAddressBook(Resource addressBook, HybrisConnection.ConnectionOptions options) {
        String defaultAddrName = (String)ResourceUtil.getValueMap((Resource)addressBook).get(PN_DEFAULT_ADDRESS, String.class);
        Iterator addresses = addressBook.listChildren();
        while (addresses.hasNext()) {
            try {
                AbstractHybrisCommand cmd;
                Resource address = (Resource)addresses.next();
                ValueMap addressValues = ResourceUtil.getValueMap((Resource)address);
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.putAll((Map<String, Object>)addressValues);
                String addressId = (String)addressValues.get("cq:hybrisId", String.class);
                if (addressId != null) {
                    cmd = new UpdateAddressCommand(addressId, this.parser.mapAddressFields(values, false), this.hybrisFactory.getServiceContext().hybrisVersion);
                    this.connection.execute((HybrisCommand)cmd, options).release();
                } else {
                    cmd = new AddAddressCommand(this.parser.mapAddressFields(values, false));
                    CommandResult result = this.connection.execute((HybrisCommand)cmd, options);
                    try {
                        XMLEventReader xml = XMLEventReaderUtil.createReader(result.getBody());
                        addressId = (String)this.parser.parseAddress(xml, "address").get("id");
                    }
                    finally {
                        result.release();
                    }
                    Node addressNode = (Node)address.adaptTo(Node.class);
                    addressNode.setProperty("cq:hybrisId", addressId);
                    addressNode.getSession().save();
                }
                if (defaultAddrName == null || !defaultAddrName.equals(address.getName())) continue;
                this.connection.execute((HybrisCommand)new SetDefaultAddressCommand(addressId), options).release();
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(DefaultProfileSynchronizer.class);
                log.error("Failed to sync address book", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncDefaultAddress(UserProperties profile, HybrisConnection.ConnectionOptions options) throws Exception {
        block7: {
            try {
                HashMap<String, Object> address = new HashMap<String, Object>();
                address.putAll((Map<String, Object>)ResourceUtil.getValueMap((Resource)profile.getResource(".")));
                address.put("firstname", profile.getProperty("givenName"));
                address.put("lastname", profile.getProperty("familyName"));
                address.put("street1", profile.getProperty("streetAddress"));
                address.put("state", profile.getProperty("region"));
                address.put("zip", profile.getProperty("postalCode"));
                address.put("city", profile.getProperty("city"));
                address.put("country", profile.getProperty("country"));
                if (!this.isValidAddress(address)) {
                    this.log.debug("Profile {} is missing required properties for default address sync", (Object)profile.getAuthorizableID());
                    return;
                }
                Map<String, Object> hybrisAddress = this.parser.mapAddressFields(address, false);
                String addressId = profile.getProperty("cq:hybrisId");
                if (addressId != null) {
                    this.connection.execute((HybrisCommand)new UpdateAddressCommand(addressId, hybrisAddress, this.hybrisFactory.getServiceContext().hybrisVersion), options).release();
                    break block7;
                }
                CommandResult result = this.connection.execute((HybrisCommand)new AddAddressCommand(hybrisAddress), options);
                try {
                    XMLEventReader xml = XMLEventReaderUtil.createReader(result.getBody());
                    addressId = (String)this.parser.parseAddress(xml, "address").get("id");
                }
                finally {
                    result.release();
                }
                this.connection.execute((HybrisCommand)new SetDefaultAddressCommand(addressId), options).release();
                profile.getNode().setProperty("cq:hybrisId", addressId);
                profile.getNode().getSession().save();
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(DefaultProfileSynchronizer.class);
                log.error("Failed to sync default address", (Throwable)e);
            }
        }
    }

    private boolean isValidAddress(Map<String, Object> address) {
        return address.containsKey("firstname") && address.containsKey("lastname") && address.containsKey("street1") && address.containsKey("city") && address.containsKey("zip") && address.containsKey("country");
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindUserPropertiesService(UserPropertiesService userPropertiesService) {
        this.userPropertiesService = userPropertiesService;
    }

    protected void unbindUserPropertiesService(UserPropertiesService userPropertiesService) {
        if (this.userPropertiesService == userPropertiesService) {
            this.userPropertiesService = null;
        }
    }

    protected void bindUserConnector(UserConnector userConnector) {
        this.userConnector = userConnector;
    }

    protected void unbindUserConnector(UserConnector userConnector) {
        if (this.userConnector == userConnector) {
            this.userConnector = null;
        }
    }

    protected void bindHybrisFactory(HybrisFactory hybrisFactory) {
        this.hybrisFactory = hybrisFactory;
    }

    protected void unbindHybrisFactory(HybrisFactory hybrisFactory) {
        if (this.hybrisFactory == hybrisFactory) {
            this.hybrisFactory = null;
        }
    }

    protected void bindConnection(HybrisConnection hybrisConnection) {
        this.connection = hybrisConnection;
    }

    protected void unbindConnection(HybrisConnection hybrisConnection) {
        if (this.connection == hybrisConnection) {
            this.connection = null;
        }
    }

    protected void bindParser(HybrisResponseParser hybrisResponseParser) {
        this.parser = hybrisResponseParser;
    }

    protected void unbindParser(HybrisResponseParser hybrisResponseParser) {
        if (this.parser == hybrisResponseParser) {
            this.parser = null;
        }
    }

    protected void bindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        this.authHandler = hybrisAuthenticationHandler;
    }

    protected void unbindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        if (this.authHandler == hybrisAuthenticationHandler) {
            this.authHandler = null;
        }
    }

    private class ProfileObserver
    implements EventListener {
        Set<String> updateList = new HashSet<String>();
        Pattern regexp = Pattern.compile("/home/.*/profile/.*");

        private ProfileObserver() {
        }

        public synchronized void onEvent(EventIterator eventIterator) {
            while (eventIterator.hasNext()) {
                Event event = eventIterator.nextEvent();
                try {
                    String userHome;
                    String resourcePath = event.getPath();
                    if (!this.regexp.matcher(resourcePath).matches() || (userHome = DefaultProfileSynchronizer.this.getHome(resourcePath)) == null) continue;
                    this.updateList.add(userHome);
                }
                catch (RepositoryException e) {
                    DefaultProfileSynchronizer.this.log.warn("Couldn't find user home for profile change: ", (Throwable)e);
                }
            }
            for (String userHome : this.updateList) {
                DefaultProfileSynchronizer.this.syncUser(userHome);
            }
            this.updateList.clear();
        }
    }
}

