/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.granite.crypto.CryptoSupport;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
@Property(name="service.description", value={"CQ - hybris user connector service"})
public class DefaultUserConnector
implements UserConnector {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserConnector.class);
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private static final String PATH_HYBRIS_CONNECTOR = "hybrisConnector";
    private static final String PROPERTY_HYBRIS_USERNAME = "hybrisConnector/username";
    @Deprecated
    private static final String PROPERTY_HYBRIS_PASSWORD = "hybrisConnector/passwordCipher";
    private static final String PATH_HYBRIS_AUTHINFO = "hybrisAuth";

    @Override
    public String generateNewSlavePassword() {
        int SLAVE_PASSWORD_LENGTH = 24;
        char[] PASSWORD_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        SecureRandom randomGenerator = new SecureRandom();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 24; ++i) {
            str.append(PASSWORD_CHARS[randomGenerator.nextInt(PASSWORD_CHARS.length)]);
        }
        return str.toString();
    }

    @Override
    public void setHybrisCredentials(ResourceResolver adminResolver, String userId, String hybrisUsername, String hybrisPassword) throws CommerceException {
        try {
            UserManager userManager = (UserManager)adminResolver.adaptTo(UserManager.class);
            Session adminSession = (Session)adminResolver.adaptTo(Session.class);
            Value username = adminSession.getValueFactory().createValue(hybrisUsername);
            Value pwdCipher = adminSession.getValueFactory().createValue(this.cryptoSupport.protect(hybrisPassword));
            Authorizable user = userManager.getAuthorizable(userId);
            user.setProperty(PROPERTY_HYBRIS_USERNAME, username);
            user.setProperty(PROPERTY_HYBRIS_PASSWORD, pwdCipher);
            AccessControlUtils.denyAllToEveryone((Session)adminSession, (String)(user.getPath() + "/" + PATH_HYBRIS_CONNECTOR));
            adminSession.save();
        }
        catch (Exception e) {
            throw new CommerceException("Couldn't write hybris user account credentials to CQ user's home: ", (Throwable)e);
        }
    }

    @Override
    public void setHybrisCredentials(String userId, String hybrisUsername, String hybrisPassword) throws CommerceException {
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            this.setHybrisCredentials(adminResolver, userId, hybrisUsername, hybrisPassword);
        }
        catch (Exception e) {
            throw new CommerceException("Couldn't write hybris user account credentials to CQ user's home: ", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    @Override
    public String getHybrisUsername(String userId) throws CommerceException {
        String username = null;
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            UserManager userManager = (UserManager)adminResolver.adaptTo(UserManager.class);
            Authorizable user = userManager.getAuthorizable(userId);
            if (user.hasProperty(PROPERTY_HYBRIS_USERNAME)) {
                username = user.getProperty(PROPERTY_HYBRIS_USERNAME)[0].getString();
            }
        }
        catch (Exception e) {
            throw new CommerceException("Failed to fetch hybris user account credentials from CQ user's home: ", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUsername(String hybrisUserId) throws CommerceException {
        String username = null;
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            UserManager userManager = (UserManager)adminResolver.adaptTo(UserManager.class);
            Iterator users = userManager.findAuthorizables(PROPERTY_HYBRIS_USERNAME, hybrisUserId);
            if (users.hasNext()) {
                username = ((Authorizable)users.next()).getID();
            }
        }
        catch (Exception e) {
            log.error("An exception occurred while determining CQ username of hybris user:", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
        return username;
    }

    @Override
    public String getHybrisPassword(String userId) throws CommerceException {
        String password = null;
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            UserManager userManager = (UserManager)adminResolver.adaptTo(UserManager.class);
            Authorizable user = userManager.getAuthorizable(userId);
            if (user.hasProperty(PROPERTY_HYBRIS_USERNAME)) {
                password = user.getProperty(PROPERTY_HYBRIS_PASSWORD)[0].getString();
                password = this.cryptoSupport.unprotect(password);
            }
        }
        catch (Exception e) {
            throw new CommerceException("Failed to fetch hybris user account credentials from CQ user's home: ", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getHybrisCredentials(String userId) {
        ResourceResolver adminResolver = null;
        HashMap<String, String> authData = new HashMap<String, String>();
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            UserManager userManager = (UserManager)adminResolver.adaptTo(UserManager.class);
            User user = (User)userManager.getAuthorizable(userId);
            Resource userResource = adminResolver.getResource(user.getPath());
            if (userResource.getChild(PATH_HYBRIS_AUTHINFO) != null) {
                Iterator propertyNames = user.getPropertyNames(PATH_HYBRIS_AUTHINFO);
                while (propertyNames.hasNext()) {
                    String propertyName = (String)propertyNames.next();
                    authData.put(propertyName, user.getProperty("hybrisAuth/" + propertyName)[0].getString());
                }
            } else {
                log.warn("User " + userId + " has no hybris authentication information.");
            }
        }
        catch (Exception e) {
            log.error("Could not get hybris credentials for user: " + userId, (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
        return authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHybrisCredentials(String userId, String hybrisUsername, Map<String, String> authData) {
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            Session adminSession = (Session)adminResolver.adaptTo(Session.class);
            UserManager userManager = (UserManager)adminResolver.adaptTo(UserManager.class);
            User user = (User)userManager.getAuthorizable(userId);
            user.setProperty(PROPERTY_HYBRIS_USERNAME, (Value)new StringValue(hybrisUsername));
            for (Map.Entry<String, String> property : authData.entrySet()) {
                user.setProperty("hybrisAuth/" + property.getKey(), (Value)new StringValue(property.getValue()));
            }
            AccessControlUtils.denyAllToEveryone((Session)adminSession, (String)(user.getPath() + "/" + PATH_HYBRIS_CONNECTOR));
            AccessControlUtils.denyAllToEveryone((Session)adminSession, (String)(user.getPath() + "/" + PATH_HYBRIS_AUTHINFO));
        }
        catch (Exception e) {
            log.error("Could not set hybris credentials for user: " + userId + "/" + hybrisUsername, (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    @Override
    public boolean isAnonymous(String username) {
        return "anonymous".equals(username) || StringUtils.isBlank((String)username);
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

