/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class HttpMethodWrapper
implements HttpMethod {
    protected final HybrisConnection connection;
    protected final HttpMethod method;
    protected static final ThreadLocal<Integer> connectionCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public HttpMethodWrapper(HybrisConnection connection, HttpMethod method) {
        this.connection = connection;
        this.method = method;
        connectionCount.set(connectionCount.get() + 1);
    }

    public String getName() {
        return this.method.getName();
    }

    @Deprecated
    public HostConfiguration getHostConfiguration() {
        return this.method.getHostConfiguration();
    }

    public void setPath(String path) {
        this.method.setPath(path);
    }

    public String getPath() {
        return this.method.getPath();
    }

    public URI getURI() throws URIException {
        return this.method.getURI();
    }

    public void setURI(URI uri) throws URIException {
        this.method.setURI(uri);
    }

    @Deprecated
    public void setStrictMode(boolean strictMode) {
        this.method.setStrictMode(strictMode);
    }

    @Deprecated
    public boolean isStrictMode() {
        return this.method.isStrictMode();
    }

    public void setRequestHeader(String headerName, String headerValue) {
        this.method.setRequestHeader(headerName, headerValue);
    }

    public void setRequestHeader(Header header) {
        this.method.setRequestHeader(header);
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.method.addRequestHeader(headerName, headerValue);
    }

    public void addRequestHeader(Header header) {
        this.method.addRequestHeader(header);
    }

    public Header getRequestHeader(String headerName) {
        return this.method.getRequestHeader(headerName);
    }

    public void removeRequestHeader(String headerName) {
        this.method.removeRequestHeader(headerName);
    }

    public void removeRequestHeader(Header header) {
        this.method.removeRequestHeader(header);
    }

    public boolean getFollowRedirects() {
        return this.method.getFollowRedirects();
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.method.setFollowRedirects(followRedirects);
    }

    public void setQueryString(String queryString) {
        this.method.setQueryString(queryString);
    }

    public void setQueryString(NameValuePair[] params) {
        this.method.setQueryString(params);
    }

    public String getQueryString() {
        return this.method.getQueryString();
    }

    public Header[] getRequestHeaders() {
        return this.method.getRequestHeaders();
    }

    public Header[] getRequestHeaders(String headerName) {
        return this.method.getRequestHeaders(headerName);
    }

    public boolean validate() {
        return this.method.validate();
    }

    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    public String getStatusText() {
        return this.method.getStatusText();
    }

    public Header[] getResponseHeaders() {
        return this.method.getResponseHeaders();
    }

    public Header getResponseHeader(String headerName) {
        return this.method.getResponseHeader(headerName);
    }

    public Header[] getResponseHeaders(String headerName) {
        return this.method.getResponseHeaders(headerName);
    }

    public Header[] getResponseFooters() {
        return this.method.getResponseFooters();
    }

    public Header getResponseFooter(String footerName) {
        return this.method.getResponseFooter(footerName);
    }

    public byte[] getResponseBody() throws IOException {
        return this.method.getResponseBody();
    }

    public String getResponseBodyAsString() throws IOException {
        return this.method.getResponseBodyAsString();
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return this.method.getResponseBodyAsStream();
    }

    public boolean hasBeenUsed() {
        return this.method.hasBeenUsed();
    }

    public int execute(HttpState state, HttpConnection connection) throws IOException {
        return this.method.execute(state, connection);
    }

    public void abort() {
        this.method.abort();
    }

    @Deprecated
    public void recycle() {
        this.method.recycle();
    }

    public void releaseConnection() {
        connectionCount.set(connectionCount.get() - 1);
        if (connectionCount.get() == 0) {
            connectionCount.remove();
        }
        this.method.releaseConnection();
    }

    public void addResponseFooter(Header footer) {
        this.method.addResponseFooter(footer);
    }

    public StatusLine getStatusLine() {
        return this.method.getStatusLine();
    }

    public boolean getDoAuthentication() {
        return this.method.getDoAuthentication();
    }

    public void setDoAuthentication(boolean doAuthentication) {
        this.method.setDoAuthentication(doAuthentication);
    }

    public HttpMethodParams getParams() {
        return this.method.getParams();
    }

    public void setParams(HttpMethodParams params) {
        this.method.setParams(params);
    }

    public AuthState getHostAuthState() {
        return this.method.getHostAuthState();
    }

    public AuthState getProxyAuthState() {
        return this.method.getProxyAuthState();
    }

    public boolean isRequestSent() {
        return this.method.isRequestSent();
    }

    protected void finalize() throws Throwable {
        this.releaseConnection();
        super.finalize();
    }
}

