/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.common.AbstractJcrCommerceServiceFactory;
import com.adobe.cq.commerce.common.ServiceContext;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.ProfileSynchronizer;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.common.DefaultHybrisFactory;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import java.util.Dictionary;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.settings.SlingSettingsService;

public class HybrisConfiguration
extends ServiceContext {
    public String catalogVersion;
    public String catalogVersionOnline;
    public String productUriTemplate;
    public String productUriRegex;
    public String baseStore;
    public int pingInterval;
    public HybrisConnection connection;
    public HybrisResponseParser parser;
    public HybrisFactory hybrisFactory;
    public ResourceResolverFactory resolverFactory;
    public UserConnector userConnector;
    public SlingSettingsService settingsService;
    public HybrisAuthenticationHandler authHandler;
    public DefaultHybrisFactory.HybrisVersion hybrisVersion;
    public ProfileSynchronizer profileSynchronizer;

    public HybrisConfiguration(DefaultHybrisFactory serviceFactory) {
        super((AbstractJcrCommerceServiceFactory)serviceFactory);
        this.profileSynchronizer = serviceFactory.profileSynchronizer;
        if (serviceFactory.context != null) {
            Dictionary config = serviceFactory.context.getProperties();
            this.catalogVersion = PropertiesUtil.toString(config.get("hybris.catalog.version"), (String)"Online");
            this.catalogVersionOnline = PropertiesUtil.toString(config.get("hybris.catalog.version.online"), (String)"Online");
            this.productUriTemplate = PropertiesUtil.toString(config.get("hybris.product.uri.template"), (String)"/products/{id}");
            this.productUriRegex = PropertiesUtil.toString(config.get("hybris.product.uri.regex"), (String)"(.*)/products/([a-zA-Z_0-9\\-\\.]+)");
            this.baseStore = PropertiesUtil.toString(config.get("hybris.basestore"), (String)"outdoors");
            this.pingInterval = PropertiesUtil.toInteger(config.get("hybris.ping_interval"), (int)5);
            this.hybrisVersion = DefaultHybrisFactory.HybrisVersion.valueOf(PropertiesUtil.toString(config.get("hybris.version"), (String)DefaultHybrisFactory.HybrisVersion.V5.name()));
        } else {
            this.hybrisVersion = DefaultHybrisFactory.HybrisVersion.V5;
        }
        this.connection = serviceFactory.connection;
        this.parser = serviceFactory.parser;
        this.hybrisFactory = serviceFactory;
        this.resolverFactory = serviceFactory.resolverFactory;
        this.userConnector = serviceFactory.userConnector;
        this.authHandler = serviceFactory.authHandler;
    }
}

