/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;
import com.adobe.cq.commerce.common.AbstractJcrProduct;
import com.adobe.cq.commerce.hybris.HybrisUtil;
import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybrisProduct
extends AbstractJcrProduct {
    private Resource productReferenceResource;
    private Resource productDataResource;
    private InheritanceValueMap properties;
    protected Product baseProduct;

    public HybrisProduct(Resource productReference, Resource productData) {
        super(productReference == null ? productData : productReference);
        this.productReferenceResource = productReference;
        this.productDataResource = productData;
    }

    public String getPath() {
        if (this.productReferenceResource != null) {
            return this.productReferenceResource.getPath();
        }
        return this.productDataResource.getPath();
    }

    public String getPagePath() {
        if (this.productReferenceResource != null) {
            PageManager pm = (PageManager)this.productReferenceResource.getResourceResolver().adaptTo(PageManager.class);
            return pm.getContainingPage(this.productReferenceResource).getPath() + ".html#" + this.getSKU();
        }
        return null;
    }

    public String getSKU() {
        return (String)this.getProperties().get("sku", String.class);
    }

    public String getTitle() {
        return (String)this.getProperties().get("jcr:title", String.class);
    }

    public String getDescription() {
        return (String)this.getProperties().get("jcr:description", String.class);
    }

    public boolean axisIsVariant(String axis) {
        Iterator<String> axes = this.getVariantAxes();
        while (axes != null && axes.hasNext()) {
            if (!axes.next().equals(axis)) continue;
            return true;
        }
        return false;
    }

    public Iterator<String> getVariantAxes() {
        String[] axes = (String[])this.getProperties().get("variantAttribute.name", String[].class);
        if (axes == null || axes.length == 0) {
            try {
                Iterator<Product> variants = this.getVariants();
                if (variants.hasNext()) {
                    ArrayList<String> values = new ArrayList<String>();
                    while (variants.hasNext()) {
                        Product variant = variants.next();
                        if (variant.getPath().equals(this.getPath())) continue;
                        Iterator axesItr = variant.getVariantAxes();
                        while (axesItr.hasNext()) {
                            String axis = (String)axesItr.next();
                            if (values.contains(axis)) continue;
                            values.add(axis);
                        }
                    }
                    return values.iterator();
                }
            }
            catch (CommerceException x) {
                log.error("Unexpected error: ", (Throwable)x);
            }
        }
        return axes != null ? Arrays.asList(axes).iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Iterator<Product> getVariants() throws CommerceException {
        return this.getVariants(null);
    }

    public Iterator<Product> getVariants(VariantFilter filter) throws CommerceException {
        ArrayList<Product> products = new ArrayList<Product>();
        if (filter == null || filter.includes(this.getBaseProduct())) {
            products.add(this.getBaseProduct());
        }
        this.getVariants(this.getBaseProduct(), filter, products);
        return products.iterator();
    }

    protected void getVariants(Product product, VariantFilter filter, List<Product> products) {
        Resource productResource = (Resource)product.adaptTo(Resource.class);
        Iterator iter = productResource.getResourceResolver().listChildren(productResource);
        while (iter.hasNext()) {
            Resource child = (Resource)iter.next();
            if (!ResourceUtil.isA((Resource)child, (String)"commerce/components/product")) continue;
            Product p = (Product)child.adaptTo(Product.class);
            if (filter != null && !filter.includes(p)) continue;
            products.add(p);
            this.getVariants(p, filter, products);
        }
    }

    public Product getBaseProduct() {
        if (this.baseProduct == null) {
            Resource r = this.productDataResource;
            while (r.getParent() != null && HybrisUtil.isProduct(r.getParent())) {
                r = r.getParent();
            }
            this.baseProduct = (Product)r.adaptTo(Product.class);
        }
        return this.baseProduct;
    }

    public Product getPIMProduct() {
        return (Product)this.productDataResource.adaptTo(Product.class);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class || type == InheritanceValueMap.class) {
            return (AdapterType)this.getProperties();
        }
        if (type == Resource.class) {
            if (this.productReferenceResource != null) {
                return (AdapterType)this.productReferenceResource;
            }
            return (AdapterType)this.productDataResource;
        }
        Object ret = super.adaptTo(type);
        if (ret == null && this.productReferenceResource != null) {
            ret = this.productReferenceResource.adaptTo(type);
        }
        if (ret == null) {
            ret = this.productDataResource.adaptTo(type);
        }
        return (AdapterType)ret;
    }

    private InheritanceValueMap getProperties() {
        if (this.properties == null) {
            this.properties = new ComponentInheritanceValueMap(this.productDataResource);
        }
        return this.properties;
    }

    void setProperties(ValueMap properties) {
        this.properties = new ComponentInheritanceValueMap(properties);
    }

    public String toString() {
        ValueMap props = ResourceUtil.getValueMap((Resource)this.productDataResource);
        return this.productDataResource.toString() + ", " + "cq:hybrisProductId" + "=" + (String)props.get("cq:hybrisProductId", (Object)"");
    }
}

