/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.hybris.SessionInfo;
import com.adobe.cq.commerce.hybris.connection.HybrisSessionUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.settings.SlingSettingsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybrisSessionInfo
implements SessionInfo {
    private String userId;
    private boolean anonymous;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private SlingSettingsService slingSettings;
    private Map<String, String> cookieInfo;

    HybrisSessionInfo(String userId, boolean anonymous, SlingHttpServletRequest request, SlingHttpServletResponse response, SlingSettingsService slingSettings) {
        this.userId = userId;
        this.anonymous = anonymous;
        this.request = request;
        this.response = response;
        this.slingSettings = slingSettings;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public Map<String, String> getCookieInfo() {
        if (this.cookieInfo == null || this.cookieInfo.isEmpty()) {
            this.cookieInfo = HybrisSessionUtil.getCookieInfo((HttpServletRequest)this.request);
        }
        return this.cookieInfo;
    }

    @Override
    public void setCookieInfo(Map<String, String> cookieInfo) {
        this.cookieInfo = cookieInfo;
        HybrisSessionUtil.setCookieInfo(cookieInfo, (HttpServletRequest)this.request, (HttpServletResponse)this.response, this.slingSettings);
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }
}

