/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceFacet;
import com.adobe.cq.commerce.api.CommerceFacetValue;
import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.api.CommerceResult;
import com.adobe.cq.commerce.api.CommerceSort;
import com.adobe.cq.commerce.api.PaginationInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.DefaultCommerceFacet;
import com.adobe.cq.commerce.common.DefaultCommerceFacetValue;
import com.adobe.cq.commerce.common.DefaultCommerceResult;
import com.adobe.cq.commerce.common.DefaultCommerceSort;
import com.adobe.cq.commerce.common.DefaultPaginationInfo;
import com.adobe.cq.commerce.hybris.api.HybrisService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SearchResultParser {
    protected static final Logger log = LoggerFactory.getLogger(SearchResultParser.class);
    protected HybrisService hybrisService;
    protected List<Product> products;
    protected List<CommerceSort> sorts;
    protected List<CommerceFacet> facets;
    protected PaginationInfo paginationInfo;
    protected CommerceQuery actualQuery;

    public SearchResultParser(HybrisService hybrisService) {
        this.hybrisService = hybrisService;
    }

    public CommerceResult parse(CommerceQuery query, InputStream is) throws SAXException, IOException, ParserConfigurationException {
        this.products = new ArrayList<Product>();
        this.sorts = new ArrayList<CommerceSort>();
        this.facets = new ArrayList<CommerceFacet>();
        SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)new ParseHandler());
        DefaultCommerceResult result = new DefaultCommerceResult();
        result.setActualQuery(this.actualQuery);
        result.setFacets(this.facets);
        result.setOriginalQuery(query);
        result.setPaginationInfo(this.paginationInfo);
        result.setProducts(this.products);
        result.setSorts(this.sorts);
        return result;
    }

    private static class HybrisBreadcrumb {
        private String facetId;
        private String facetName;
        private String valueId;
        private String valueName;

        private HybrisBreadcrumb() {
        }

        public String getFacetId() {
            return this.facetId;
        }

        public String getFacetName() {
            return this.facetName;
        }

        public String getValueId() {
            return this.valueId;
        }

        public String getValueName() {
            return this.valueName;
        }

        public void setFacetId(String facetId) {
            this.facetId = facetId;
        }

        public void setFacetName(String facetName) {
            this.facetName = facetName;
        }

        public void setValueId(String valueId) {
            this.valueId = valueId;
        }

        public void setValueName(String valueName) {
            this.valueName = valueName;
        }
    }

    private class ParseHandler
    extends DefaultHandler {
        private static final String PRODUCT_TAG = "product";
        private static final String URL_TAG = "url";
        private static final String SORT_TAG = "sort";
        private static final String CODE_TAG = "code";
        private static final String NAME_TAG = "name";
        private static final String SELECTED_TAG = "selected";
        private static final String PAGINATION_TAG = "pagination";
        private static final String PAGESIZE_TAG = "pageSize";
        private static final String CURRENTPAGE_TAG = "currentPage";
        private static final String TOTALPAGES_TAG = "totalPages";
        private static final String TOTALRESULTS_TAG = "totalResults";
        private static final String CURRENTQUERY_TAG = "currentQuery";
        private static final String FACETS_TAG = "facets";
        private static final String FACET_TAG = "facet";
        private static final String MULTISELECT_TAG = "multiSelect";
        private static final String TOPVALUES_TAG = "topValues";
        private static final String VALUES_TAG = "values";
        private static final String VALUE_TAG = "value";
        private static final String COUNT_TAG = "count";
        private static final String QUERY_TAG = "query";
        private static final String BREADCRUMBS_TAG = "breadcrumbs";
        private static final String BREADCRUMB_TAG = "de.hybris.platform.commerceservices.search.facetdata.BreadcrumbData";
        private static final String FACETCODE_TAG = "facetCode";
        private static final String FACETNAME_TAG = "facetName";
        private static final String VALUECODE_TAG = "facetValueCode";
        private static final String VALUENAME_TAG = "facetValueName";
        private static final String BOOLEAN_TRUE = "true";
        private static final String URL_REGEX = "/([^/]+)$";
        private boolean inProduct;
        private boolean inUrl;
        private boolean inSort;
        private boolean inCode;
        private boolean inName;
        private boolean inSelected;
        private boolean inPagination;
        private boolean inCurrentQuery;
        private boolean inFacets;
        private boolean inFacet;
        private boolean inFacetTopValues;
        private boolean inFacetValues;
        private boolean inValue;
        private boolean inBreadcrumbs;
        private boolean inBreadcrumb;
        private DefaultCommerceSort currentSort;
        private DefaultPaginationInfo pagination;
        private DefaultCommerceFacet currentFacet;
        private String currentFacetId;
        private DefaultCommerceFacetValue currentValue;
        private List<HybrisBreadcrumb> breadcrumbs;
        private HybrisBreadcrumb currentBreadcrumb;
        private final StringBuilder cdata = new StringBuilder();

        private ParseHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (PRODUCT_TAG.equalsIgnoreCase(qName)) {
                this.inProduct = true;
            } else if (URL_TAG.equalsIgnoreCase(qName)) {
                this.inUrl = true;
            } else if (SORT_TAG.equalsIgnoreCase(qName) && !this.inPagination) {
                this.inSort = true;
                this.currentSort = new DefaultCommerceSort();
            } else if (CODE_TAG.equalsIgnoreCase(qName)) {
                this.inCode = true;
            } else if (NAME_TAG.equalsIgnoreCase(qName)) {
                this.inName = true;
            } else if (SELECTED_TAG.equalsIgnoreCase(qName)) {
                this.inSelected = true;
            } else if (PAGINATION_TAG.equalsIgnoreCase(qName)) {
                this.inPagination = true;
                this.pagination = new DefaultPaginationInfo();
            } else if (CURRENTQUERY_TAG.equalsIgnoreCase(qName)) {
                this.inCurrentQuery = true;
            } else if (FACETS_TAG.equalsIgnoreCase(qName)) {
                this.inFacets = true;
            } else if (FACET_TAG.equalsIgnoreCase(qName) && this.inFacets) {
                this.inFacet = true;
                this.currentFacet = new DefaultCommerceFacet();
                this.currentFacet.setValues(new ArrayList());
            } else if (TOPVALUES_TAG.equalsIgnoreCase(qName) && this.inFacet) {
                this.inFacetTopValues = true;
            } else if (VALUES_TAG.equalsIgnoreCase(qName) && this.inFacet) {
                this.inFacetValues = true;
            } else if (VALUE_TAG.equalsIgnoreCase(qName) && this.inFacetValues) {
                this.inValue = true;
                this.currentValue = new DefaultCommerceFacetValue();
            } else if (BREADCRUMBS_TAG.equalsIgnoreCase(qName)) {
                this.inBreadcrumbs = true;
                this.breadcrumbs = new ArrayList<HybrisBreadcrumb>();
            } else if (BREADCRUMB_TAG.equalsIgnoreCase(qName) && this.inBreadcrumbs) {
                this.inBreadcrumb = true;
                this.currentBreadcrumb = new HybrisBreadcrumb();
            }
            this.cdata.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inProduct && this.inUrl) {
                this.cdata.append(new String(ch, start, length));
            }
            if (this.inSort && (this.inCode || this.inName || this.inSelected)) {
                this.cdata.append(new String(ch, start, length));
            }
            if (this.inPagination) {
                this.cdata.append(new String(ch, start, length));
            }
            if (this.inCurrentQuery) {
                this.cdata.append(new String(ch, start, length));
            }
            if (this.inFacet) {
                this.cdata.append(new String(ch, start, length));
            }
            if (this.inBreadcrumb) {
                this.cdata.append(new String(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inProduct) {
                if (URL_TAG.equalsIgnoreCase(qName)) {
                    block77: {
                        String url = this.cdata.toString();
                        Matcher matcher = Pattern.compile(URL_REGEX).matcher(url);
                        if (matcher.find()) {
                            String productId = matcher.group(1);
                            try {
                                Product product = SearchResultParser.this.hybrisService.getProductByHybrisId(productId);
                                if (product != null) {
                                    SearchResultParser.this.products.add(product);
                                    break block77;
                                }
                                log.warn("Could not find product ({}:{}) returned by search", (Object)url, (Object)productId);
                            }
                            catch (CommerceException e) {
                                log.warn("Could not find product ({}:{}) returned by search", (Object)url, (Object)productId);
                                log.warn("Exception was:", (Throwable)e);
                            }
                        } else {
                            log.warn("Could not find product id ({})", (Object)url);
                        }
                    }
                    this.inUrl = false;
                } else if (PRODUCT_TAG.equalsIgnoreCase(qName)) {
                    this.inProduct = false;
                }
            } else if (this.inSort) {
                if (CODE_TAG.equalsIgnoreCase(qName)) {
                    this.currentSort.setId(this.cdata.toString());
                    this.inCode = false;
                } else if (NAME_TAG.equalsIgnoreCase(qName)) {
                    this.currentSort.setDisplayName(this.cdata.toString());
                    this.inName = false;
                } else if (SELECTED_TAG.equalsIgnoreCase(qName)) {
                    this.currentSort.setSelected(BOOLEAN_TRUE.equalsIgnoreCase(this.cdata.toString()));
                    this.inSelected = false;
                } else if (SORT_TAG.equalsIgnoreCase(qName)) {
                    SearchResultParser.this.sorts.add((CommerceSort)this.currentSort);
                    this.inSort = false;
                }
            } else if (this.inPagination) {
                if (PAGESIZE_TAG.equalsIgnoreCase(qName)) {
                    this.pagination.setPageSize(Integer.parseInt(this.cdata.toString()));
                } else if (CURRENTPAGE_TAG.equalsIgnoreCase(qName)) {
                    this.pagination.setCurrentPage(Integer.parseInt(this.cdata.toString()));
                } else if (TOTALPAGES_TAG.equalsIgnoreCase(qName)) {
                    this.pagination.setTotalPages(Integer.parseInt(this.cdata.toString()));
                } else if (TOTALRESULTS_TAG.equalsIgnoreCase(qName)) {
                    this.pagination.setTotalResults(Integer.parseInt(this.cdata.toString()));
                } else if (PAGINATION_TAG.equalsIgnoreCase(qName)) {
                    SearchResultParser.this.paginationInfo = this.pagination;
                    this.inPagination = false;
                }
            } else if (this.inCurrentQuery) {
                if (CURRENTQUERY_TAG.equalsIgnoreCase(qName)) {
                    String query = this.cdata.toString();
                    String[] queryParts = query.split(":");
                    CommerceQuery.Builder builder = new CommerceQuery.Builder();
                    builder.setQueryText(queryParts[0]);
                    if (queryParts.length > 1) {
                        builder.setSortId(queryParts[1]);
                    }
                    SearchResultParser.this.actualQuery = builder.build();
                    this.inCurrentQuery = false;
                }
            } else if (this.inFacets) {
                if (this.inFacet) {
                    if (this.inFacetValues) {
                        if (this.inValue) {
                            if (NAME_TAG.equalsIgnoreCase(qName)) {
                                this.currentValue.setDisplayName(this.cdata.toString());
                            } else if (COUNT_TAG.equalsIgnoreCase(qName)) {
                                if (StringUtils.isNumeric((String)this.cdata.toString())) {
                                    this.currentValue.setProductCount(Integer.parseInt(this.cdata.toString()));
                                }
                            } else if (QUERY_TAG.equalsIgnoreCase(qName)) {
                                String[] parts = this.cdata.toString().split(":");
                                if (this.currentFacet.getId() == null) {
                                    this.currentFacetId = parts[parts.length - 2];
                                }
                                this.currentValue.setId(parts[parts.length - 1]);
                            } else if (SELECTED_TAG.equalsIgnoreCase(qName)) {
                                this.currentValue.setSelected(BOOLEAN_TRUE.equalsIgnoreCase(this.cdata.toString()));
                            } else if (VALUE_TAG.equalsIgnoreCase(qName)) {
                                this.inValue = false;
                                if (this.currentFacet.getId() == null && this.currentFacetId != null && !this.currentValue.isSelected()) {
                                    this.currentFacet.setId(this.currentFacetId);
                                }
                                this.currentFacet.getValues().add(this.currentValue);
                                this.currentFacetId = null;
                            }
                        } else if (VALUES_TAG.equalsIgnoreCase(qName)) {
                            this.inFacetValues = false;
                        }
                    } else if (this.inFacetTopValues) {
                        if (TOPVALUES_TAG.equalsIgnoreCase(qName)) {
                            this.inFacetTopValues = false;
                        }
                    } else if (NAME_TAG.equalsIgnoreCase(qName)) {
                        this.currentFacet.setDisplayName(this.cdata.toString());
                    } else if (MULTISELECT_TAG.equalsIgnoreCase(qName)) {
                        this.currentFacet.setMultiSelect(BOOLEAN_TRUE.equalsIgnoreCase(this.cdata.toString()));
                    } else if (FACET_TAG.equalsIgnoreCase(qName)) {
                        SearchResultParser.this.facets.add((CommerceFacet)this.currentFacet);
                        this.inFacet = false;
                    }
                } else if (FACETS_TAG.equalsIgnoreCase(qName)) {
                    this.inFacets = false;
                }
            } else if (this.inBreadcrumbs) {
                if (this.inBreadcrumb) {
                    if (FACETCODE_TAG.equalsIgnoreCase(qName)) {
                        this.currentBreadcrumb.setFacetId(this.cdata.toString());
                    } else if (FACETNAME_TAG.equalsIgnoreCase(qName)) {
                        this.currentBreadcrumb.setFacetName(this.cdata.toString());
                    } else if (VALUENAME_TAG.equalsIgnoreCase(qName)) {
                        this.currentBreadcrumb.setValueName(this.cdata.toString());
                    } else if (VALUECODE_TAG.equalsIgnoreCase(qName)) {
                        this.currentBreadcrumb.setValueId(this.cdata.toString());
                    } else if (BREADCRUMB_TAG.equalsIgnoreCase(qName)) {
                        this.breadcrumbs.add(this.currentBreadcrumb);
                        this.inBreadcrumb = false;
                    }
                } else if (BREADCRUMBS_TAG.equalsIgnoreCase(qName)) {
                    this.inBreadcrumbs = false;
                }
            }
        }

        public void endDocument() throws SAXException {
            block0: for (HybrisBreadcrumb breadcrumb : this.breadcrumbs) {
                for (CommerceFacet facet : SearchResultParser.this.facets) {
                    if (!facet.getDisplayName().equals(breadcrumb.getFacetName())) continue;
                    for (CommerceFacetValue value : facet.getValues()) {
                        if (!value.getDisplayName().equals(breadcrumb.getValueName())) continue;
                        ((DefaultCommerceFacetValue)value).setId(breadcrumb.getValueId());
                    }
                    if (facet.getId() != null) continue block0;
                    ((DefaultCommerceFacet)facet).setId(breadcrumb.getFacetId());
                    continue block0;
                }
            }
        }
    }
}

