/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.connection;

import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractHybrisCommand
implements HybrisCommand {
    private static final URLCodec URL_CODEC = new URLCodec();
    private ArrayList<NameValuePair> parameters = new ArrayList();
    private ArrayList<NameValuePair> headers = new ArrayList();
    private String method;
    private String path;

    public AbstractHybrisCommand() {
        this.setMethod("GET");
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<NameValuePair> getHeaders() {
        return this.headers;
    }

    @Override
    public String getRequestBody() {
        return "";
    }

    @Override
    public InputStream getRequestBodyStream() {
        return null;
    }

    @Override
    public String getRequestContentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public String getQueryString() {
        LinkedList output = new LinkedList();
        CollectionUtils.collect(this.parameters, (Transformer)new Transformer(){

            public Object transform(Object input) {
                NameValuePair pair = (NameValuePair)input;
                return AbstractHybrisCommand.this.urlEncode(pair.getName()) + "=" + AbstractHybrisCommand.this.urlEncode(pair.getValue());
            }
        }, output);
        return StringUtils.join((Object[])output.toArray(), (String)"&");
    }

    protected void addParameter(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("key may not be blank");
        }
        if (StringUtils.isNotBlank((String)value)) {
            this.parameters.add(new NameValuePair(key, value));
        }
    }

    protected void addHeader(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("key may not be blank");
        }
        if (StringUtils.isNotBlank((String)value)) {
            this.headers.add(new NameValuePair(key, value));
        }
    }

    protected void setMethod(String method) {
        this.method = method;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    private String urlEncode(String s) {
        try {
            return URL_CODEC.encode(s);
        }
        catch (EncoderException encoderException) {
            return s;
        }
    }

    public String toString() {
        return this.getMethod() + " " + this.getPath() + "?" + this.getQueryString();
    }

    @Override
    public boolean needsServerAuth() {
        return false;
    }
}

