/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.connection;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.NotAuthorizedException;
import com.adobe.cq.commerce.hybris.HybrisSession;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;

public interface HybrisConnection {
    public String getServerUrl();

    public CommandResult execute(HybrisCommand var1, ConnectionOptions var2) throws CommerceException;

    public CommandResult execute(HybrisCommand var1, String var2) throws CommerceException;

    public CommandResult execute(HybrisCommand var1, String var2, CommerceSession var3) throws NotAuthorizedException, CommerceException;

    public CommandResult execute(HybrisCommand var1, String var2, String var3, String var4) throws NotAuthorizedException, CommerceException;

    public HttpClient getConfiguredHttpClient();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConnectionOptions {
        private String baseStore;
        private Map<String, Object> context;
        private Map<String, String> sessionData;
        private HybrisSession session;

        public ConnectionOptions(String baseStore, Map<String, Object> context) {
            this.baseStore = baseStore;
            this.context = context;
            this.session = null;
            this.sessionData = null;
        }

        public ConnectionOptions(String baseStore, HybrisSession session, Map<String, Object> context) {
            this(baseStore, context);
            this.session = session;
            this.sessionData = session != null && session.getSessionInfo() != null ? session.getSessionInfo().getCookieInfo() : null;
        }

        public ConnectionOptions(String baseStore, Map<String, String> sessionData, Map<String, Object> context) {
            this(baseStore, context);
            this.sessionData = sessionData;
        }

        public String getBaseStore() {
            return this.baseStore;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public HybrisSession getSession() {
            return this.session;
        }

        public Map<String, String> getSessionData() {
            return this.sessionData;
        }
    }
}

