/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.connection;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybrisSessionUtil {
    private static final Logger log = LoggerFactory.getLogger(HybrisSessionUtil.class);
    private static final URLCodec urlCodec = new URLCodec();
    private static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    private static final String CQ_SESSION_COOKIE_NAME = "HybrisSession";
    private static final String HYBRIS_SESSION_COOKIE_NAME = "JSESSIONID";
    private static final String SESSION_COOKIE_DOMAIN = "Domain";

    @Deprecated
    public static Map<String, String> getCookieInfo(HttpServletRequest request, SlingSettingsService settingsService) {
        return HybrisSessionUtil.getCookieInfo(request);
    }

    public static Map<String, String> getCookieInfo(HttpServletRequest request) {
        if (request.getCookies() != null) {
            for (javax.servlet.http.Cookie cookie : request.getCookies()) {
                if (!CQ_SESSION_COOKIE_NAME.equals(cookie.getName())) continue;
                try {
                    return HybrisSessionUtil.deserialize(URLDecoder.decode(cookie.getValue(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("utf-8 not supported?", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static void setCookieInfo(Map<String, String> cookieInfo, HttpServletRequest request, HttpServletResponse response, SlingSettingsService settingsService) {
        try {
            javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(CQ_SESSION_COOKIE_NAME, URLEncoder.encode(HybrisSessionUtil.serialize(cookieInfo), "utf-8"));
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException e) {
            log.error("utf-8 not supported?", (Throwable)e);
        }
    }

    protected static String serialize(Map<String, String> cookieData) {
        JSONObject json = new JSONObject(cookieData);
        return json.toString();
    }

    protected static Map<String, String> deserialize(String serialized) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            JSONObject json = new JSONObject(serialized);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                data.put(key, json.getString(key));
            }
            return data;
        }
        catch (JSONException e) {
            log.error("Could not deserialize cookie data.", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static Cookie constructSessionCookie(Map<String, String> cookieInfo) {
        return new Cookie(cookieInfo.get(SESSION_COOKIE_DOMAIN), HYBRIS_SESSION_COOKIE_NAME, cookieInfo.get(HYBRIS_SESSION_COOKIE_NAME), "/", -1, true);
    }

    @Deprecated
    public static Map<String, String> getUpdatedCookieInfo(HttpMethod method) {
        if (method.hasBeenUsed()) {
            try {
                HashMap<String, String> cookieInfo = new HashMap<String, String>();
                Header[] headers = method.getResponseHeaders(HTTP_HEADER_SET_COOKIE);
                for (int i = 0; i < headers.length; ++i) {
                    String header = headers[i].getValue();
                    String[] parts = urlCodec.decode(header).split(";");
                    if (!parts[0].startsWith(HYBRIS_SESSION_COOKIE_NAME)) continue;
                    cookieInfo.put(HYBRIS_SESSION_COOKIE_NAME, parts[0].split("=")[1]);
                    cookieInfo.put(SESSION_COOKIE_DOMAIN, method.getURI().getHost());
                    return cookieInfo;
                }
            }
            catch (Exception e) {
                log.error("Could not get jcrSession cookies from request: ", (Throwable)e);
            }
        }
        return null;
    }
}

