/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.connection.cmd;

import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.hybris.connection.AbstractHybrisCommand;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SearchCommand
extends AbstractHybrisCommand {
    private static final String SEARCH_PATH = "/products";
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_PAGE = "currentPage";
    private static final String PARAM_PAGESIZE = "pageSize";
    private static final String PARAM_SORT = "sort";

    public SearchCommand(CommerceQuery query) {
        this.setPath(SEARCH_PATH);
        StringBuilder queryText = new StringBuilder(query.getQueryText().replaceAll(":", " ") + ":");
        if (query.getPage() >= 0) {
            this.addParameter(PARAM_PAGE, String.valueOf(query.getPage()));
        }
        if (query.getPageSize() > 0) {
            this.addParameter(PARAM_PAGESIZE, String.valueOf(query.getPageSize()));
        }
        if (StringUtils.isNotBlank((String)query.getSortId())) {
            this.addParameter(PARAM_SORT, query.getSortId());
        }
        for (Map.Entry entry : query.getFacets().entrySet()) {
            for (String value : (List)entry.getValue()) {
                queryText.append(":" + (String)entry.getKey() + ":" + value);
            }
        }
        this.addParameter(PARAM_QUERY, queryText.toString());
        this.addHeader("Accept", "application/xml");
    }
}

