/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.common.HttpMethodWrapper;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="Hybris Basic Authentication Handler", metatype=true, description="Service that handles basic HTTP authentication to the Hybris API")
@Service(value={HybrisAuthenticationHandler.class})
@Property(label="Service Ranking", name="service.ranking", intValue={1000}, description="Service Ranking", propertyPrivate=false)
public class BasicAuthHandler
implements HybrisAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthHandler.class);
    private static final String[] DEFAULT_SESSIONLESS_USERS = new String[]{"admin"};
    @Property(label="Sessionless Users", value={"admin"}, description="A list of users for which basic authentication should always be used (i.e. never use a session cookie).")
    public static final String PROPERTY_SESSIONLESS_USERS = "basicauth.sessionless_users";
    protected static final int DEFAULT_SESSION_TIMEOUT = 3600;
    @Property(label="Session timeout", intValue={3600}, description="Hybris session timeout in seconds. This is set in hybris/bin/platform/project.properties.")
    public static final String PROPERTY_SESSION_TIMEOUT = "basicauth.session_timeout";
    public static final String SESSION_COOKIE_NAME = "JSESSIONID";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_SESSIONID = "sessionid";
    public static final String KEY_OBTAINED = "obtained";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected UserConnector userConnector;
    @Reference
    protected CryptoSupport crypto;
    private ComponentContext context;
    private List<String> sessionlessUsers;
    private int sessionTimeout;

    public void activate(ComponentContext ctx) {
        this.context = ctx;
        this.sessionlessUsers = Arrays.asList(PropertiesUtil.toStringArray(ctx.getProperties().get(PROPERTY_SESSIONLESS_USERS), (String[])DEFAULT_SESSIONLESS_USERS));
        this.sessionTimeout = PropertiesUtil.toInteger(ctx.getProperties().get(PROPERTY_SESSION_TIMEOUT), (int)3600);
    }

    public void deactivate() {
        this.context = null;
        this.sessionlessUsers = null;
    }

    @Override
    public Map<String, String> authenticateUser(String username, String password) {
        HashMap<String, String> authData = new HashMap<String, String>();
        authData.put("username", username);
        try {
            authData.put(KEY_PASSWORD, this.crypto.protect(password));
        }
        catch (CryptoException e) {
            log.error("Could not encrypt password!");
            return null;
        }
        return authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> authenticateSession(Map<String, String> authData) {
        ServiceReference connectionReference = this.context.getBundleContext().getServiceReference(HybrisConnection.class.getName());
        ServiceReference serviceFactoryReference = this.context.getBundleContext().getServiceReference(HybrisFactory.class.getName());
        log.debug("Got connectionReference: " + connectionReference);
        log.debug("Got serviceFactoryReference: " + serviceFactoryReference);
        if (connectionReference == null || serviceFactoryReference == null) {
            log.warn("HybrisConnection and/or HybrisFactory not available, unable to authenticate session!");
            return null;
        }
        HashMap<String, String> sessionData = new HashMap<String, String>();
        HttpMethodWrapper request = null;
        try {
            HybrisConnection connection = (HybrisConnection)this.context.getBundleContext().getService(connectionReference);
            HybrisFactory hybrisFactory = (HybrisFactory)this.context.getBundleContext().getService(serviceFactoryReference);
            String username = authData.get("username") == null ? "anonymous" : authData.get("username");
            String password = "";
            if (authData.get(KEY_PASSWORD) != null) {
                try {
                    password = this.crypto.unprotect(authData.get(KEY_PASSWORD));
                }
                catch (CryptoException e) {
                    log.warn("Could not decrypt password: using as plaintext!");
                    password = authData.get(KEY_PASSWORD);
                }
            }
            sessionData.put("username", username);
            if (this.sessionlessUsers.contains(username)) {
                sessionData.put(KEY_PASSWORD, password);
            } else {
                HttpClient httpClient = connection.getConfiguredHttpClient();
                if (!this.userConnector.isAnonymous(username)) {
                    httpClient.getParams().setAuthenticationPreemptive(true);
                    httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
                String uri = connection.getServerUrl() + "/rest/v1/" + hybrisFactory.getServiceContext().baseStore + "/cart";
                request = new HttpMethodWrapper(connection, (HttpMethod)new GetMethod(uri));
                int status = httpClient.executeMethod((HttpMethod)request);
                if (log.isDebugEnabled()) {
                    log.debug("GET " + uri + " returned:");
                    log.debug(request.getResponseBodyAsString());
                }
                if (status >= 200 && status < 300) {
                    sessionData.putAll(BasicAuthHandler.extractSessionData(httpClient, request));
                } else {
                    log.warn("Authentication failed for user " + username);
                }
            }
        }
        catch (IOException e) {
            log.error("Could not execute authentication request.", (Throwable)e);
        }
        finally {
            if (connectionReference != null) {
                this.context.getBundleContext().ungetService(connectionReference);
            }
            if (serviceFactoryReference != null) {
                this.context.getBundleContext().ungetService(serviceFactoryReference);
            }
            if (request != null) {
                request.releaseConnection();
            }
        }
        return sessionData;
    }

    @Override
    public Map<String, String> executeAuthenticated(HttpClient client, HttpMethod method, Map<String, String> sessionData) throws IOException, CommerceException {
        Map<String, String> newSessionData = null;
        if (sessionData != null) {
            if (sessionData.containsKey(KEY_SESSIONID)) {
                String sessionId = sessionData.get(KEY_SESSIONID);
                if (!sessionData.containsKey(KEY_OBTAINED) || System.currentTimeMillis() > Long.parseLong(sessionData.get(KEY_OBTAINED)) + (long)(this.sessionTimeout * 1000)) {
                    Map<String, String> authData = this.userConnector.getHybrisCredentials(sessionData.get("username"));
                    newSessionData = this.authenticateSession(authData);
                    sessionId = newSessionData.get(KEY_SESSIONID);
                }
                client.getState().addCookie(new Cookie(method.getURI().getHost(), SESSION_COOKIE_NAME, sessionId, "/", null, false));
            } else if (sessionData.containsKey(KEY_PASSWORD)) {
                String username = sessionData.get("username");
                String password = sessionData.get(KEY_PASSWORD) == null ? "" : sessionData.get(KEY_PASSWORD);
                client.getParams().setAuthenticationPreemptive(true);
                client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        client.executeMethod(method);
        return newSessionData;
    }

    @Override
    public Map<String, String> executeAuthenticated(HttpClient client, HttpMethod method, String username, String password) throws IOException, CommerceException {
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.executeMethod(method);
        return BasicAuthHandler.extractSessionData(client, method);
    }

    private static Map<String, String> extractSessionData(HttpClient client, HttpMethod executedRequest) {
        Header cookieHeader = executedRequest.getResponseHeader("Set-Cookie");
        if (cookieHeader != null && cookieHeader.getValue().indexOf(SESSION_COOKIE_NAME) >= 0) {
            HashMap<String, String> sessionData = new HashMap<String, String>();
            for (Cookie cookie : client.getState().getCookies()) {
                if (!SESSION_COOKIE_NAME.equals(cookie.getName())) continue;
                sessionData.put(KEY_SESSIONID, cookie.getValue());
                sessionData.put(KEY_OBTAINED, String.valueOf(System.currentTimeMillis()));
                break;
            }
            if (!sessionData.isEmpty()) {
                log.debug("got new session ID");
                return sessionData;
            }
        }
        log.debug("no new session ID found");
        return null;
    }

    protected void bindUserConnector(UserConnector userConnector) {
        this.userConnector = userConnector;
    }

    protected void unbindUserConnector(UserConnector userConnector) {
        if (this.userConnector == userConnector) {
            this.userConnector = null;
        }
    }

    protected void bindCrypto(CryptoSupport cryptoSupport) {
        this.crypto = cryptoSupport;
    }

    protected void unbindCrypto(CryptoSupport cryptoSupport) {
        if (this.crypto == cryptoSupport) {
            this.crypto = null;
        }
    }
}

