/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Adobe CQ Hybris Login Filter", description="Servlet filter that authenticates requests with Hybris so that cookies can be set before any content is potentially written to the response")
@Service
@Properties(value={@Property(name="sling.filter.scope", value={"REQUEST"}, propertyPrivate=true)})
public class LoginRequestFilter
implements Filter {
    protected static final Logger log = LoggerFactory.getLogger(LoginRequestFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)servletRequest;
            SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)servletResponse;
            Resource resource = slingRequest.getResource();
            Page page = (Page)resource.adaptTo(Page.class);
            if (page != null && WCMUtils.getInheritedProperty((Page)page, (ResourceResolver)resource.getResourceResolver(), (String)"cq:hybrisBaseStore") != null) {
                CommerceService commerceService = (CommerceService)resource.adaptTo(CommerceService.class);
                commerceService.login(slingRequest, slingResponse);
            }
        }
        catch (CommerceException e) {
            log.error("Could not authenticate request in hybris", (Throwable)e);
        }
        finally {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

