/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="Hybris OAuth handler", description="Authenticates REST calls made to the Hybris API using OAuth.", metatype=true)
@Service
@Property(label="Service Ranking", name="service.ranking", intValue={1100}, description="Service Ranking", propertyPrivate=false)
public class OAuthHandler
implements HybrisAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthHandler.class);
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_EXPIRES = "expires";
    private static final String SESSION_COOKIE_NAME = "JSESSIONID";
    @Property(label="Client ID", description="OAuth client ID to use.", value={"mobile_android"})
    public static final String PROPERTY_CLIENT_ID = "hybris.oauth.client_id";
    @Property(label="Client Secret", description="OAuth client secret for the above ID.", value={"secret"})
    public static final String PROPERTY_CLIENT_SECRET = "hybris.oauth.client_secret";
    protected static final int DEFAULT_SESSION_TIMEOUT = 3600;
    @Property(label="Session timeout", intValue={3600}, description="Hybris session timeout in seconds. This is set in hybris/bin/platform/project.properties.")
    public static final String PROPERTY_SESSION_TIMEOUT = "oauth.session_timeout";
    static final String KEY_SESSIONID = "sessionid";
    private static final String KEY_OBTAINED = "obtained";
    private ComponentContext context;
    private String clientId;
    private String clientSecret;
    private int sessionTimeout;
    private String accessToken;
    private long accessTokenExpires;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private UserConnector userConnector;
    private final Map<String, ServiceReference> services = new HashMap<String, ServiceReference>();

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
        this.clientId = (String)context.getProperties().get(PROPERTY_CLIENT_ID);
        this.clientSecret = (String)context.getProperties().get(PROPERTY_CLIENT_SECRET);
        this.sessionTimeout = PropertiesUtil.toInteger(context.getProperties().get(PROPERTY_SESSION_TIMEOUT), (int)3600);
    }

    @Deactivate
    protected void deactivate() {
        for (String className : this.services.keySet()) {
            this.ungetService(className);
        }
        this.context = null;
        this.clientId = null;
        this.clientSecret = null;
    }

    protected Object getService(String className) {
        if (this.services.containsKey(className)) {
            log.debug("getService: Getting service from cache: " + className);
            return this.context.getBundleContext().getService(this.services.get(className));
        }
        ServiceReference serviceReference = this.context.getBundleContext().getServiceReference(className);
        if (serviceReference != null) {
            this.services.put(className, serviceReference);
            Object service = this.context.getBundleContext().getService(serviceReference);
            log.debug("getService: Service not in cache: " + className + ", got instance: " + service);
            return service;
        }
        return null;
    }

    protected void ungetService(String className) {
        log.debug("ungetService: " + className + ", in cache: " + this.services.containsKey(className));
        if (this.services.containsKey(className)) {
            ServiceReference serviceReference = this.services.get(className);
            this.context.getBundleContext().ungetService(serviceReference);
            this.services.remove(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> authenticateUser(String username, String password) {
        if (this.userConnector.isAnonymous(username)) {
            return Collections.emptyMap();
        }
        PostMethod method = null;
        try {
            HybrisConnection connection = (HybrisConnection)this.getService(HybrisConnection.class.getName());
            HybrisFactory hybrisFactory = (HybrisFactory)this.getService(HybrisFactory.class.getName());
            if (connection == null || hybrisFactory == null) {
                log.error("HybrisConnection and/or HybrisFactory not available, cannot continue.");
                Map<String, String> map = null;
                return map;
            }
            HttpClient client = connection.getConfiguredHttpClient();
            method = new PostMethod(connection.getServerUrl() + "/rest/oauth/token");
            method.addParameter("client_id", this.clientId);
            method.addParameter("client_secret", this.clientSecret);
            method.addParameter("grant_type", "password");
            method.addParameter("username", username);
            method.addParameter("password", password);
            log.debug("POST " + method.getURI());
            int status = client.executeMethod((HttpMethod)method);
            if (log.isDebugEnabled()) {
                log.debug("Response: " + method.getResponseBodyAsString());
            }
            if (status >= 200 && status < 300) {
                Map<String, String> map = this.extractAuthData(username, method.getResponseBodyAsString());
                return map;
            }
            log.error("Server responded with " + status + " -> authentication failed.");
        }
        catch (ConnectException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            log.error("Could not authenticate user", (Throwable)e);
        }
        finally {
            this.ungetService(HybrisConnection.class.getName());
            this.ungetService(HybrisFactory.class.getName());
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> authenticateSession(Map<String, String> authData) {
        HashMap<String, String> sessionData;
        block18: {
            sessionData = new HashMap<String, String>();
            String accessToken = authData.get(KEY_ACCESS_TOKEN);
            GetMethod method = null;
            try {
                HybrisConnection connection = (HybrisConnection)this.getService(HybrisConnection.class.getName());
                HybrisFactory hybrisFactory = (HybrisFactory)this.getService(HybrisFactory.class.getName());
                if (connection == null || hybrisFactory == null) {
                    log.error("HybrisConnection and/or HybrisFactory not available, cannot continue.");
                    Map<String, String> map = null;
                    return map;
                }
                HttpClient client = connection.getConfiguredHttpClient();
                String uri = connection.getServerUrl() + "/rest/v1/" + hybrisFactory.getServiceContext().baseStore + "/cart";
                method = new GetMethod(uri);
                method.setDoAuthentication(false);
                if (accessToken != null) {
                    log.debug("Obtaining JSESSIONID using OAuth access token...");
                    if (authData.get(KEY_EXPIRES) != null && System.currentTimeMillis() > Long.parseLong(authData.get(KEY_EXPIRES))) {
                        log.debug("Refreshing OAuth token...");
                        Map<String, String> newAuthData = this.refreshToken(authData.get("username"), authData.get(KEY_REFRESH_TOKEN));
                        if (newAuthData.get(KEY_ACCESS_TOKEN) != null) {
                            accessToken = newAuthData.get(KEY_ACCESS_TOKEN);
                        }
                    }
                } else {
                    accessToken = this.getAccessToken();
                }
                if (accessToken != null) {
                    method.setRequestHeader("Authorization", "Bearer " + accessToken);
                }
                int status = client.executeMethod((HttpMethod)method);
                if (log.isDebugEnabled()) {
                    log.debug("GET " + uri + " finished with status " + status);
                    log.debug(method.getResponseBodyAsString());
                }
                if (status >= 200 && status < 300) {
                    for (Cookie cookie : client.getState().getCookies()) {
                        if (!SESSION_COOKIE_NAME.equals(cookie.getName())) continue;
                        if (authData.containsKey("username")) {
                            sessionData.put("username", authData.get("username"));
                        }
                        sessionData.put(KEY_SESSIONID, cookie.getValue());
                        sessionData.put(KEY_OBTAINED, String.valueOf(System.currentTimeMillis()));
                        break block18;
                    }
                    break block18;
                }
                log.warn("Server responded with status " + status + " on attempt to obtain session ID.");
            }
            catch (ConnectException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                log.warn("Error while fetching cart for session id (have authtoken: " + (accessToken != null) + ").", (Throwable)e);
            }
            finally {
                this.ungetService(HybrisConnection.class.getName());
                this.ungetService(HybrisFactory.class.getName());
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return sessionData.isEmpty() ? null : sessionData;
    }

    @Override
    public Map<String, String> executeAuthenticated(HttpClient client, HttpMethod method, Map<String, String> sessionData) throws IOException, CommerceException {
        String sessionId;
        Map<String, String> newSessionData = null;
        if (sessionData != null && sessionData.containsKey(KEY_SESSIONID)) {
            sessionId = sessionData.get(KEY_SESSIONID);
            if (sessionData.containsKey(KEY_OBTAINED) && System.currentTimeMillis() > Long.parseLong(sessionData.get(KEY_OBTAINED)) + (long)(this.sessionTimeout * 1000)) {
                try {
                    if (sessionData.containsKey("username")) {
                        String cqUserId = this.userConnector.getUsername(sessionData.get("username"));
                        Map<String, String> authData = this.userConnector.getHybrisCredentials(cqUserId);
                        newSessionData = this.authenticateSession(authData);
                    } else {
                        newSessionData = this.authenticateSession(Collections.<String, String>emptyMap());
                    }
                    if (newSessionData == null) {
                        throw new CommerceException("Could not authenticate request");
                    }
                }
                catch (IllegalStateException x) {
                    if (x.getCause() instanceof ConnectException) {
                        throw new CommerceException("", x.getCause());
                    }
                    throw x;
                }
                sessionId = newSessionData.get(KEY_SESSIONID);
            }
        } else {
            throw new CommerceException("Could not authenticate request");
        }
        client.getState().addCookie(new Cookie(method.getURI().getHost(), SESSION_COOKIE_NAME, sessionId, "/", null, false));
        client.executeMethod(method);
        return newSessionData;
    }

    protected Map<String, String> extractAuthData(String username, String jsonString) throws JSONException, IOException {
        HashMap<String, String> authData = new HashMap<String, String>();
        JSONObject json = new JSONObject(jsonString);
        authData.put("username", username);
        authData.put(KEY_ACCESS_TOKEN, json.getString(KEY_ACCESS_TOKEN));
        if (json.has(KEY_REFRESH_TOKEN)) {
            authData.put(KEY_REFRESH_TOKEN, json.getString(KEY_REFRESH_TOKEN));
            int expiresIn = json.getInt("expires_in");
            long expires = System.currentTimeMillis() + (long)(expiresIn * 1000);
            authData.put(KEY_EXPIRES, String.valueOf(expires));
        }
        return authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        if (this.accessToken != null && this.accessTokenExpires < System.currentTimeMillis()) {
            log.debug("Returning cached access_token...");
            return this.accessToken;
        }
        PostMethod refresh = null;
        try {
            HybrisConnection connection = (HybrisConnection)this.getService(HybrisConnection.class.getName());
            HybrisFactory hybrisFactory = (HybrisFactory)this.getService(HybrisFactory.class.getName());
            if (connection == null || hybrisFactory == null) {
                throw new CommerceException("HybrisConnection / HybrisFactory not available.");
            }
            refresh = new PostMethod(connection.getServerUrl() + "/rest/oauth/token");
            refresh.addParameter("client_id", this.clientId);
            refresh.addParameter("client_secret", this.clientSecret);
            refresh.addParameter("grant_type", "client_credentials");
            log.debug("POST " + refresh.getURI());
            int status = connection.getConfiguredHttpClient().executeMethod((HttpMethod)refresh);
            if (log.isDebugEnabled()) {
                log.debug("Response: " + refresh.getResponseBodyAsString());
            }
            if (status >= 200 && status < 300) {
                Map<String, String> authData = this.extractAuthData(null, refresh.getResponseBodyAsString());
                if (authData.containsKey(KEY_EXPIRES)) {
                    this.accessTokenExpires = Long.parseLong(authData.get(KEY_EXPIRES));
                }
                String string = this.accessToken = authData.get(KEY_ACCESS_TOKEN);
                return string;
            }
            log.error("Server did not respond with 2xx -> authentication failed.");
        }
        catch (Exception e) {
            log.error("Could not get access token", (Throwable)e);
        }
        finally {
            this.ungetService(HybrisConnection.class.getName());
            this.ungetService(HybrisFactory.class.getName());
            if (refresh != null) {
                refresh.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> refreshToken(String username, String refreshToken) {
        PostMethod refresh = null;
        try {
            HybrisConnection connection = (HybrisConnection)this.getService(HybrisConnection.class.getName());
            HybrisFactory hybrisFactory = (HybrisFactory)this.getService(HybrisFactory.class.getName());
            if (connection == null || hybrisFactory == null) {
                throw new CommerceException("HybrisConnection / HybrisFactory not available.");
            }
            refresh = new PostMethod(connection.getServerUrl() + "/rest/oauth/token");
            refresh.addParameter("client_id", this.clientId);
            refresh.addParameter("client_secret", this.clientSecret);
            refresh.addParameter("grant_type", KEY_REFRESH_TOKEN);
            refresh.addParameter(KEY_REFRESH_TOKEN, refreshToken);
            log.debug("POST " + refresh.getURI());
            int status = connection.getConfiguredHttpClient().executeMethod((HttpMethod)refresh);
            if (log.isDebugEnabled()) {
                log.debug("Response: " + refresh.getResponseBodyAsString());
            }
            if (status >= 200 && status < 300) {
                Map<String, String> authData = this.extractAuthData(username, refresh.getResponseBodyAsString());
                this.userConnector.setHybrisCredentials(this.userConnector.getUsername(username), username, authData);
                Map<String, String> map = authData;
                return map;
            }
            log.error("Server did not respond with 2xx -> authentication failed.");
        }
        catch (Exception e) {
            log.error("Could not authenticate user", (Throwable)e);
        }
        finally {
            this.ungetService(HybrisConnection.class.getName());
            this.ungetService(HybrisFactory.class.getName());
            if (refresh != null) {
                refresh.releaseConnection();
            }
        }
        return null;
    }

    @Override
    public Map<String, String> executeAuthenticated(HttpClient client, HttpMethod method, String username, String password) throws IOException, CommerceException {
        try {
            Map<String, String> authData = this.authenticateUser(username, password);
            Map<String, String> sessionData = this.authenticateSession(authData);
            if (method.getPath().startsWith("/ws410/rest")) {
                client.getParams().setAuthenticationPreemptive(true);
                client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                client.executeMethod(method);
            } else {
                this.executeAuthenticated(client, method, sessionData);
            }
            return sessionData;
        }
        catch (IllegalStateException x) {
            if (x.getCause() instanceof ConnectException) {
                throw new CommerceException("", x.getCause());
            }
            throw x;
        }
    }

    protected void bindUserConnector(UserConnector userConnector) {
        this.userConnector = userConnector;
    }

    protected void unbindUserConnector(UserConnector userConnector) {
        if (this.userConnector == userConnector) {
            this.userConnector = null;
        }
    }
}

