/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl.group;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.hybris.api.GroupConnector;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.impl.group.GetGroupCommand;
import com.adobe.cq.commerce.hybris.impl.group.UpdateGroupCommand;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true)
public class GroupSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(GroupSynchronizer.class);
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected GroupConnector groupConnector;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected UserConnector userConnector;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisConnection connection;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisFactory hybrisFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisResponseParser parser;
    protected ResourceResolver adminResolver;
    protected UserManager userManager;
    protected Session adminSession;
    protected ObservationManager observationManager;
    protected EventListener listener;
    protected String baseStore;
    protected XMLInputFactory xmlFactory;

    protected void activate() throws LoginException, RepositoryException {
        this.adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        this.adminSession = (Session)this.adminResolver.adaptTo(Session.class);
        this.observationManager = this.adminSession.getWorkspace().getObservationManager();
        this.userManager = (UserManager)this.adminResolver.adaptTo(UserManager.class);
        this.baseStore = this.hybrisFactory.getServiceContext().baseStore;
        this.xmlFactory = XMLInputFactory.newInstance();
        this.startListening();
    }

    protected void deactivate() {
        this.stopListening();
        if (this.adminResolver != null) {
            this.adminResolver.close();
            this.adminResolver = null;
            this.adminSession = null;
            this.userManager = null;
            this.baseStore = null;
            this.xmlFactory = null;
        }
    }

    protected void stopListening() {
        try {
            this.observationManager.removeEventListener(this.listener);
            log.debug("Removed event listener.");
        }
        catch (RepositoryException e) {
            log.error("Could not stop listening", (Throwable)e);
        }
    }

    protected void startListening() {
        try {
            if (this.listener == null) {
                this.listener = new GroupObserver();
            }
            int eventTypes = 28;
            String absPath = "/home/groups";
            this.observationManager.addEventListener(this.listener, 28, "/home/groups", true, null, new String[]{"rep:Group"}, true);
            log.debug("Registered event listener.");
        }
        catch (RepositoryException e) {
            log.error("Could not start listening", (Throwable)e);
        }
    }

    protected Resource getGroupResource(String path) {
        Resource r = this.adminResolver.getResource(path);
        if (r == null) {
            r = this.adminResolver.getResource(path.substring(0, path.lastIndexOf(47)));
        }
        while (r != null) {
            if ("rep:Group".equals(r.getResourceType())) {
                return r;
            }
            r = r.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGroup(String groupId, Set<String> memberUids) throws CommerceException, ParserConfigurationException, IOException, SAXException, TransformerConfigurationException, TransformerException {
        CommandResult groupResult = this.connection.execute((HybrisCommand)new GetGroupCommand(groupId), this.baseStore);
        ByteArrayOutputStream documentOutputStream = null;
        ByteArrayInputStream requestInputStream = null;
        try {
            if (groupResult.success()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(groupResult.getBody());
                HashSet<String> membersToAdd = new HashSet<String>(memberUids);
                boolean dirty = false;
                Node membersNode = doc.getElementsByTagName("members").item(0);
                if (membersNode != null) {
                    NodeList principals = membersNode.getChildNodes();
                    for (int i = 0; i < principals.getLength(); ++i) {
                        NamedNodeMap attributes = principals.item(i).getAttributes();
                        if (attributes.getNamedItem("uid") == null) continue;
                        String principalUid = attributes.getNamedItem("uid").getTextContent();
                        if (!memberUids.contains(principalUid)) {
                            if (this.userConnector.getUsername(principalUid) == null) continue;
                            membersNode.removeChild(principals.item(i));
                            dirty = true;
                            continue;
                        }
                        membersToAdd.remove(principalUid);
                    }
                } else {
                    membersNode = doc.createElement("members");
                    doc.appendChild(membersNode);
                }
                if (dirty || membersToAdd.size() > 0) {
                    for (String member : membersToAdd) {
                        Element principal = doc.createElement("principal");
                        principal.setAttribute("uid", member);
                        membersNode.appendChild(principal);
                    }
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    documentOutputStream = new ByteArrayOutputStream();
                    transformer.transform(new DOMSource(doc), new StreamResult(documentOutputStream));
                    requestInputStream = new ByteArrayInputStream(documentOutputStream.toByteArray());
                    this.connection.execute((HybrisCommand)new UpdateGroupCommand(groupId, requestInputStream), this.baseStore).release();
                } else {
                    log.info("No need to update group {}, memberships up to date", (Object)groupId);
                }
            }
        }
        finally {
            groupResult.release();
            IOUtils.closeQuietly(documentOutputStream);
            IOUtils.closeQuietly(requestInputStream);
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindGroupConnector(GroupConnector groupConnector) {
        this.groupConnector = groupConnector;
    }

    protected void unbindGroupConnector(GroupConnector groupConnector) {
        if (this.groupConnector == groupConnector) {
            this.groupConnector = null;
        }
    }

    protected void bindUserConnector(UserConnector userConnector) {
        this.userConnector = userConnector;
    }

    protected void unbindUserConnector(UserConnector userConnector) {
        if (this.userConnector == userConnector) {
            this.userConnector = null;
        }
    }

    protected void bindConnection(HybrisConnection hybrisConnection) {
        this.connection = hybrisConnection;
    }

    protected void unbindConnection(HybrisConnection hybrisConnection) {
        if (this.connection == hybrisConnection) {
            this.connection = null;
        }
    }

    protected void bindHybrisFactory(HybrisFactory hybrisFactory) {
        this.hybrisFactory = hybrisFactory;
    }

    protected void unbindHybrisFactory(HybrisFactory hybrisFactory) {
        if (this.hybrisFactory == hybrisFactory) {
            this.hybrisFactory = null;
        }
    }

    protected void bindParser(HybrisResponseParser hybrisResponseParser) {
        this.parser = hybrisResponseParser;
    }

    protected void unbindParser(HybrisResponseParser hybrisResponseParser) {
        if (this.parser == hybrisResponseParser) {
            this.parser = null;
        }
    }

    private class GroupObserver
    implements EventListener {
        private GroupObserver() {
        }

        public synchronized void onEvent(EventIterator events) {
            Group group;
            HashMap<String, Group> updatedGroups = new HashMap<String, Group>();
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    String hybrisUid;
                    Resource groupResource;
                    String path;
                    if ("com.adobe.cq.commerce.hybris.impl.group.GroupSynchronizer.skip".equals(event.getUserData()) || (path = event.getPath()) == null || !path.endsWith("rep:members") || (groupResource = GroupSynchronizer.this.getGroupResource(path)) == null || (group = (Group)GroupSynchronizer.this.getGroupResource(path).adaptTo(Group.class)) == null || (hybrisUid = GroupSynchronizer.this.groupConnector.getHybrisUid(group.getID(), GroupSynchronizer.this.adminResolver)) == null) continue;
                    updatedGroups.put(hybrisUid, group);
                }
                catch (RepositoryException e) {
                    log.error("Error reading authorizable from path", (Throwable)e);
                }
            }
            if (updatedGroups.size() > 0) {
                log.info("Updating groups in hybris: {}", (Object)StringUtils.join(updatedGroups.keySet(), (String)", "));
            }
            for (Map.Entry entry : updatedGroups.entrySet()) {
                String hybrisUid = (String)entry.getKey();
                try {
                    group = (Group)entry.getValue();
                    Iterator members = group.getDeclaredMembers();
                    HashSet<String> memberIDs = new HashSet<String>();
                    while (members.hasNext()) {
                        Authorizable member = (Authorizable)members.next();
                        String memberUid = GroupSynchronizer.this.userConnector.getHybrisUsername(member.getID());
                        if (memberUid == null) continue;
                        memberIDs.add(memberUid);
                    }
                    GroupSynchronizer.this.updateGroup(hybrisUid, memberIDs);
                }
                catch (Exception e) {
                    log.error("Could not update group: " + hybrisUid, (Throwable)e);
                }
            }
        }
    }
}

