/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl.importer;

import com.adobe.cq.commerce.hybris.importer.HybrisImporter;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@SlingServlet(paths={"/libs/commerce/content/import"}, methods={"POST"})
public class CatalogImportServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -2569450911827743980L;
    private static final String DEFAULT_PRODUCTS_PATH = "/etc/commerce/products";
    @Reference
    private HybrisImporter importer;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if ("groups".equals(request.getParameter("what"))) {
            this.doGroups(request, response);
        } else {
            this.doProducts(request, response);
        }
    }

    @Deprecated
    private void doProducts(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String baseStore = request.getParameter("store");
        String catalog = request.getParameter("catalog");
        String targetPath = request.getParameter("path");
        String language = request.getParameter("language");
        if (targetPath == null) {
            targetPath = DEFAULT_PRODUCTS_PATH;
        }
        if (baseStore != null && catalog != null) {
            ResourceResolver resolver = request.getResourceResolver();
            Resource target = resolver.getResource(targetPath);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain");
            response.getWriter().println("Warning: using deprecated import servlet. Use /libs/commerce/products (ProductDataServlet) instead.\n");
            this.importer.importCatalog(target, baseStore, catalog, language, response.getWriter());
        } else {
            response.sendError(400);
        }
    }

    private void doGroups(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String path = request.getParameter("path");
        String baseStore = request.getParameter("store");
        if (!StringUtils.isBlank((String)path) && !StringUtils.isBlank((String)baseStore)) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain");
            this.importer.importGroups(path, baseStore, response.getWriter(), request.getResourceResolver());
        } else {
            response.sendError(400, "Incorrect parameters (need to supply path and store)");
        }
    }

    protected void bindImporter(HybrisImporter hybrisImporter) {
        this.importer = hybrisImporter;
    }

    protected void unbindImporter(HybrisImporter hybrisImporter) {
        if (this.importer == hybrisImporter) {
            this.importer = null;
        }
    }
}

