/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl.importer;

import com.adobe.cq.commerce.hybris.HybrisUtil;
import com.adobe.cq.commerce.hybris.importer.HybrisImporter;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, policy=ConfigurationPolicy.REQUIRE, label="Day CQ Commerce Hybris Polling Catalog Updater")
@Service
@Property(name="importer.scheme", value={"hybris"})
public class PollingCatalogUpdater
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(PollingCatalogUpdater.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisImporter importer;

    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        Resource base = HybrisUtil.findBaseStore(target);
        if (base != null) {
            log.info("Updating catalog at {}", (Object)target.getPath());
            this.importer.updateCatalog(target);
        } else {
            log.warn("Catalog update is configured for {}, but base store could not be found.", (Object)target.getPath());
        }
    }

    protected void bindImporter(HybrisImporter hybrisImporter) {
        this.importer = hybrisImporter;
    }

    protected void unbindImporter(HybrisImporter hybrisImporter) {
        if (this.importer == hybrisImporter) {
            this.importer = null;
        }
    }
}

