/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl.importer;

import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.importer.HybrisImporter;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Day CQ Commerce Hybris Polling Customer Groups Updater")
@Service
@Properties(value={@Property(name="importer.scheme", value={"hybris-groups"}, propertyPrivate=true)})
public class PollingGroupsImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(PollingGroupsImporter.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisImporter importer;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisFactory hybrisFactory;

    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        String baseStore;
        log.info("Importing groups from {} into {}", (Object)dataSource, (Object)target.getPath());
        if (StringUtils.isBlank((String)dataSource)) {
            log.warn("dataSource does not contain a baseStore (expected uri: hybris-groups:baseStore), reverting to default baseStore");
            baseStore = this.hybrisFactory.getServiceContext().baseStore;
        } else {
            baseStore = dataSource;
        }
        this.importer.importGroups(target.getPath(), baseStore, null, target.getResourceResolver());
    }

    protected void bindImporter(HybrisImporter hybrisImporter) {
        this.importer = hybrisImporter;
    }

    protected void unbindImporter(HybrisImporter hybrisImporter) {
        if (this.importer == hybrisImporter) {
            this.importer = null;
        }
    }

    protected void bindHybrisFactory(HybrisFactory hybrisFactory) {
        this.hybrisFactory = hybrisFactory;
    }

    protected void unbindHybrisFactory(HybrisFactory hybrisFactory) {
        if (this.hybrisFactory == hybrisFactory) {
            this.hybrisFactory = null;
        }
    }
}

