/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.impl.user;

import com.adobe.cq.commerce.hybris.api.GroupConnector;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.UserConnector;
import com.adobe.cq.commerce.hybris.common.HybrisConfiguration;
import com.adobe.cq.commerce.hybris.connection.AbstractHybrisCommand;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisAuthenticationHandler;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.HybrisSessionUtil;
import com.adobe.cq.commerce.hybris.impl.group.GroupSynchronizer;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import com.adobe.cq.commerce.hybris.importer.ImportHandler;
import com.adobe.cq.commerce.hybris.importer.XMLEventReaderUtil;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.AuthenticationInfoPostProcessor;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
@Properties(value={@Property(name="service.description", value={"On-the-fly user importer for hybris"}), @Property(name="hybris.groups.lazy_import", boolValue={true}), @Property(label="Update Interval", description="If the same user logs in faster than this interval (seconds) his information will not be synced, as to prevent latency / DoS issues.", name="hybris.userimporter.interval", intValue={10})})
public class LazyUserImporter
implements AuthenticationInfoPostProcessor {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisFactory hybrisFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private UserConnector userConnector;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private GroupConnector groupConnector;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected GroupSynchronizer groupSynchronizer;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisResponseParser parser;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected ImportHandler handler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisAuthenticationHandler authHandler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisConnection connection;
    public static final String PROP_UPDATE_GROUPS = "hybris.groups.lazy_import";
    public static final boolean DEFAULT_UPDATE_GROUPS = true;
    public static final String PROP_UPDATE_INTERVAL = "hybris.userimporter.interval";
    public static final int DEFAULT_UPDATE_INTERVAL = 10;
    private Session adminSession = null;
    private ResourceResolver adminResolver;
    private UserManager userManager;
    private XMLInputFactory xmlFactory;
    private boolean updateGroups;
    private String lastUserId;
    private long lastUserTimestamp;
    private int updateInterval;

    public void postProcess(AuthenticationInfo info, HttpServletRequest request, HttpServletResponse response) {
        try {
            Object credentials;
            if (this.adminSession == null) {
                return;
            }
            String userId = info.getUser();
            char[] pwdChars = info.getPassword();
            if (userId == null && (credentials = info.get((Object)"user.jcr.credentials")) instanceof SimpleCredentials) {
                SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
                userId = simpleCredentials.getUserID();
                pwdChars = simpleCredentials.getPassword();
            }
            if (userId == null || pwdChars == null || pwdChars.length == 0) {
                return;
            }
            if (userId.equals(this.lastUserId) && this.lastUserTimestamp > System.currentTimeMillis() - (long)(this.updateInterval * 1000)) {
                return;
            }
            this.lastUserId = userId;
            this.lastUserTimestamp = System.currentTimeMillis();
            String password = new String(pwdChars);
            User user = (User)this.userManager.getAuthorizable(userId);
            if (user == null) {
                HybrisConfiguration options = this.hybrisFactory.getServiceContext();
                Map<String, String> authInfo = this.authHandler.authenticateUser(userId, password);
                if (authInfo == null) {
                    return;
                }
                user = this.userManager.createUser(userId, password);
                this.userConnector.setHybrisCredentials(userId, userId, authInfo);
                Map<String, String> sessionData = this.authHandler.authenticateSession(authInfo);
                HybrisSessionUtil.setCookieInfo(sessionData, request, response, options.settingsService);
                this.adminSession.save();
            }
            if (this.updateGroups) {
                this.updateGroups(user);
            }
        }
        catch (IllegalStateException x) {
            if (x.getCause() instanceof ConnectException) {
                this.log.error("Hybris server is not available: " + x.getCause().getMessage());
            } else {
                this.log.error("Failed to synchronize hybris user profile: ", (Throwable)x);
            }
        }
        catch (Exception e) {
            this.log.error("Error attempting to import user from hybris: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroups(User user) {
        CommandResult result = null;
        try {
            GetCustomerCommand cmd;
            this.adminSession.getWorkspace().getObservationManager().setUserData("com.adobe.cq.commerce.hybris.impl.group.GroupSynchronizer.skip");
            String hybrisUserId = this.userConnector.getHybrisUsername(user.getID());
            if (hybrisUserId != null && (result = this.connection.execute((HybrisCommand)(cmd = new GetCustomerCommand(hybrisUserId)), this.hybrisFactory.getServiceContext().baseStore)).success()) {
                XMLEventReader xml = this.xmlFactory.createXMLEventReader(result.getBody());
                HashSet<Group> hybrisGroups = new HashSet<Group>();
                XMLEvent groups = XMLEventReaderUtil.findFirstTag(xml, "allGroups");
                if (groups != null) {
                    Group group;
                    while (xml.hasNext() && !XMLEventReaderUtil.isNextEndElement(xml, "allGroups")) {
                        if (XMLEventReaderUtil.isNextStartElement(xml, "principalGroup")) {
                            try {
                                Map<String, String> groupData = this.parser.parseUserGroup(xml);
                                group = this.groupConnector.setHybrisData(groupData, null, this.adminResolver);
                                hybrisGroups.add(group);
                                group.addMember((Authorizable)user);
                            }
                            catch (Exception e) {
                                this.log.error("Could not add user to group", (Throwable)e);
                            }
                            continue;
                        }
                        XMLEventReaderUtil.nextTag(xml);
                    }
                    Iterator userGroups = user.declaredMemberOf();
                    while (userGroups.hasNext()) {
                        group = (Group)userGroups.next();
                        if (!group.hasProperty("hybris/uid") || hybrisGroups.contains(group)) continue;
                        group.removeMember((Authorizable)user);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error attempting to update groups on " + user, (Throwable)e);
        }
        finally {
            if (result != null) {
                result.release();
            }
        }
    }

    public String getServiceName() {
        return "org.apache.sling.auth.core.spi.AuthenticationInfoPostProcessor";
    }

    protected void activate(ComponentContext context) throws Exception {
        this.adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        this.adminSession = (Session)this.adminResolver.adaptTo(Session.class);
        this.userManager = (UserManager)this.adminResolver.adaptTo(UserManager.class);
        this.xmlFactory = XMLInputFactory.newInstance();
        this.updateGroups = PropertiesUtil.toBoolean(context.getProperties().get(PROP_UPDATE_GROUPS), (boolean)true);
        this.updateInterval = PropertiesUtil.toInteger(context.getProperties().get(PROP_UPDATE_INTERVAL), (int)10);
    }

    protected void deactivate(ComponentContext context) throws InterruptedException {
        if (this.adminSession != null) {
            this.adminSession.logout();
            this.adminSession = null;
            this.adminResolver = null;
            this.userManager = null;
            this.xmlFactory = null;
        }
    }

    protected void bindHybrisFactory(HybrisFactory hybrisFactory) {
        this.hybrisFactory = hybrisFactory;
    }

    protected void unbindHybrisFactory(HybrisFactory hybrisFactory) {
        if (this.hybrisFactory == hybrisFactory) {
            this.hybrisFactory = null;
        }
    }

    protected void bindUserConnector(UserConnector userConnector) {
        this.userConnector = userConnector;
    }

    protected void unbindUserConnector(UserConnector userConnector) {
        if (this.userConnector == userConnector) {
            this.userConnector = null;
        }
    }

    protected void bindGroupConnector(GroupConnector groupConnector) {
        this.groupConnector = groupConnector;
    }

    protected void unbindGroupConnector(GroupConnector groupConnector) {
        if (this.groupConnector == groupConnector) {
            this.groupConnector = null;
        }
    }

    protected void bindGroupSynchronizer(GroupSynchronizer groupSynchronizer) {
        this.groupSynchronizer = groupSynchronizer;
    }

    protected void unbindGroupSynchronizer(GroupSynchronizer groupSynchronizer) {
        if (this.groupSynchronizer == groupSynchronizer) {
            this.groupSynchronizer = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindParser(HybrisResponseParser hybrisResponseParser) {
        this.parser = hybrisResponseParser;
    }

    protected void unbindParser(HybrisResponseParser hybrisResponseParser) {
        if (this.parser == hybrisResponseParser) {
            this.parser = null;
        }
    }

    protected void bindHandler(ImportHandler importHandler) {
        this.handler = importHandler;
    }

    protected void unbindHandler(ImportHandler importHandler) {
        if (this.handler == importHandler) {
            this.handler = null;
        }
    }

    protected void bindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        this.authHandler = hybrisAuthenticationHandler;
    }

    protected void unbindAuthHandler(HybrisAuthenticationHandler hybrisAuthenticationHandler) {
        if (this.authHandler == hybrisAuthenticationHandler) {
            this.authHandler = null;
        }
    }

    protected void bindConnection(HybrisConnection hybrisConnection) {
        this.connection = hybrisConnection;
    }

    protected void unbindConnection(HybrisConnection hybrisConnection) {
        if (this.connection == hybrisConnection) {
            this.connection = null;
        }
    }

    protected static class GetCustomerCommand
    extends AbstractHybrisCommand {
        public GetCustomerCommand(String username) {
            this.setPath("/ws410/rest/customers/" + username);
        }

        public boolean needsServerAuth() {
            return true;
        }
    }
}

