/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.importer;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.hybris.HybrisUtil;
import com.adobe.cq.commerce.hybris.api.GroupConnector;
import com.adobe.cq.commerce.hybris.api.HybrisFactory;
import com.adobe.cq.commerce.hybris.api.HybrisService;
import com.adobe.cq.commerce.hybris.connection.AbstractHybrisCommand;
import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.cmd.GetProductCommand;
import com.adobe.cq.commerce.hybris.importer.HybrisImporter;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import com.adobe.cq.commerce.hybris.importer.ImportHandler;
import com.adobe.cq.commerce.hybris.importer.ImporterContext;
import com.adobe.cq.commerce.hybris.importer.XMLEventReaderUtil;
import com.adobe.cq.commerce.pim.api.ProductImporter;
import com.adobe.cq.commerce.pim.common.AbstractProductImporter;
import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Day CQ Commerce Hybris Catalog Importer")
@Service
@Properties(value={@Property(name="commerceProvider", value={"hybris"}, propertyPrivate=true)})
public class DefaultHybrisImporter
extends AbstractProductImporter
implements HybrisImporter,
ProductImporter {
    private static final int DEFAULT_IMPORT_INTERVAL = 3600;
    private static final int DEFAULT_PAGE_SIZE = 30;
    protected static String DEFAULT_PRODUCTS_PATH = "/etc/commerce/products";
    private static final Logger log = LoggerFactory.getLogger(DefaultHybrisImporter.class);
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @Property(longValue={3600L})
    public static final String IMPORT_INTERVAL = "hybris.import.interval";
    @Property(longValue={30L})
    public static final String PAGE_SIZE = "hybris.import.pagesize";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisConnection connection;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisResponseParser parser;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private HybrisFactory hybrisFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ImportHandler handler;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected GroupConnector groupConnector;
    private int pageSize;
    private XMLInputFactory xmlFactory;
    protected String baseStore;
    protected String catalog;
    protected String language;
    private boolean expressUpdate;
    private String damPath;
    protected Writer logWriter = new Writer(){
        final StringBuffer buffer = new StringBuffer();

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.append(cbuf, off, len);
        }

        public void flush() throws IOException {
            DefaultHybrisImporter.this.logMessage(this.buffer.toString(), this.buffer.charAt(0) == 'E');
            this.buffer.setLength(0);
        }

        public void close() throws IOException {
        }
    };

    @Override
    public void importCatalog(Resource base, String baseStore, String catalog, String language, PrintWriter writer) {
        this.importCatalog(base, baseStore, catalog, language, writer, false);
    }

    public void importCatalog(Resource base, String baseStore, String catalog, String language, PrintWriter writer, boolean incremental) {
        ImporterContext ctx;
        long beginMillis;
        block4: {
            log.trace("importCatalog(" + base + ", " + baseStore + ", " + catalog + ", " + language + ", " + writer + ")");
            HybrisService hybrisService = this.hybrisFactory.getCommerceService(base);
            beginMillis = System.currentTimeMillis();
            ctx = null;
            try {
                String catalogVersion = this.hybrisFactory.getServiceContext().catalogVersion;
                String lang = language != null ? language : hybrisService.getLanguage();
                ctx = new ImporterContext(base, baseStore, catalog, catalogVersion, lang, this.damPath, writer);
                ComponentInheritanceValueMap values = new ComponentInheritanceValueMap(base);
                Date lastImported = incremental ? (Date)values.getInherited("cq:hybrisLastImported", Date.class) : null;
                this.importCatalogVersion(ctx);
                this.importProducts(ctx, lastImported);
            }
            catch (Exception e) {
                log.error("Importing catalog \"{}\" from Hybris failed: ", (Object)catalog, (Object)e);
                if (ctx == null) break block4;
                ctx.error("Importing catalog \"" + catalog + "\" from Hybris failed: " + e.getMessage());
            }
        }
        long importMillis = System.currentTimeMillis() - beginMillis;
        if (ctx.hasErrors()) {
            writer.append("Catalog import finished with errors in " + importMillis + " milliseconds");
            log.info("Catalog import finished with errors in {} milliseconds", (Object)importMillis);
        } else {
            writer.append("Catalog imported successfully in " + importMillis + " milliseconds");
            log.info("Catalog imported successfully in {} milliseconds", (Object)importMillis);
        }
    }

    protected void doImport(ResourceResolver resourceResolver, Node node, boolean incrementalImport) throws RepositoryException, IOException {
        log.trace("doImport(" + resourceResolver + ", " + node + ")");
        Resource base = resourceResolver.getResource(node.getPath());
        if (this.expressUpdate) {
            this.importExpressUpdate(base);
        } else {
            PrintWriter writer = new PrintWriter(this.logWriter);
            this.importCatalog(base, this.baseStore, this.catalog, this.language, writer, incrementalImport);
            writer.flush();
        }
    }

    @Override
    public void updateCatalog(Resource base) {
        HybrisService hybrisService = this.hybrisFactory.getCommerceService(base);
        ComponentInheritanceValueMap values = new ComponentInheritanceValueMap(base);
        String provider = (String)values.getInherited("cq:commerceProvider", String.class);
        this.catalog = (String)values.getInherited("cq:hybrisCatalogId", String.class);
        this.baseStore = (String)values.getInherited("cq:hybrisBaseStore", String.class);
        this.language = hybrisService.getLanguage();
        this.basePath = base.getPath();
        this.damPath = (String)values.getInherited("hybris:damPath", String.class);
        this.run(base.getResourceResolver(), this.basePath, null, true, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCatalogVersion(ImporterContext ctx) throws Exception {
        XMLEventReader xml = null;
        CommandResult result = null;
        try {
            GetCatalogVersionCommand cmd = new GetCatalogVersionCommand(ctx.getCatalog(), ctx.getCatalogVersion(), ctx.getLanguage());
            result = this.connection.execute((HybrisCommand)cmd, ctx.getBaseStore());
            xml = this.xmlFactory.createXMLEventReader(result.getBody());
            String catalogPath = this.handler.createCatalog(ctx);
            ctx.addCategory(ctx.getCatalog(), null, catalogPath);
            List<Map<String, Object>> rootCategories = this.parser.parseCatalogVersion(xml);
            for (Map<String, Object> category : rootCategories) {
                this.importCategory(ctx, category, null);
            }
        }
        finally {
            if (xml != null) {
                xml.close();
            }
            if (result != null) {
                result.release();
            }
        }
    }

    private void importCategory(ImporterContext ctx, Map<String, Object> values, String parent) throws Exception {
        ValueMapDecorator vm = new ValueMapDecorator(values);
        String code = (String)vm.get("code", String.class);
        String tagID = this.handler.createTag(ctx, (ValueMap)vm);
        ctx.addTag(code, tagID);
        String path = this.handler.createCategory(ctx, (ValueMap)vm, parent);
        ctx.addCategory(code, parent, path);
        for (Object o : (List)values.get("subcategories")) {
            Map category = (Map)o;
            this.importCategory(ctx, category, code);
        }
    }

    protected String getProductPath(ImporterContext ctx, ValueMap values, List<String> categories) {
        String parentCategoryPath = ctx.getCategoryPath(categories.get(0));
        String code = (String)values.get("code", String.class);
        return parentCategoryPath + "/" + code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProducts(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.expressUpdate = request.getParameter("expressUpdate") != null;
        this.damPath = request.getParameter("damPath");
        try {
            super.importProducts(request, response);
        }
        finally {
            this.expressUpdate = false;
            this.damPath = null;
        }
    }

    protected Node setupStore(ResourceResolver resourceResolver, String basePath, String storeName, boolean clear, String provider) {
        if (this.expressUpdate) {
            clear = false;
        }
        return super.setupStore(resourceResolver, basePath, storeName, clear, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importProducts(ImporterContext ctx, Date lastImported) throws Exception {
        boolean hasProducts;
        XMLEventReader xml = null;
        CommandResult result = null;
        Session importSession = (Session)ctx.getResolver().adaptTo(Session.class);
        Resource root = ctx.getResolver().getResource(ctx.getCategoryPath(ctx.getCatalog()));
        ProductPathCachePopulator ppcp = new ProductPathCachePopulator(ctx);
        ppcp.accept(root);
        int page = 0;
        do {
            try {
                GetProductsCommand cmd = new GetProductsCommand(ctx.getCatalog(), ctx.getCatalogVersion(), ctx.getLanguage(), page, this.pageSize, lastImported, this.parser.getConfiguredProductAttributes(false));
                result = this.connection.execute((HybrisCommand)cmd, ctx.getBaseStore());
                xml = this.xmlFactory.createXMLEventReader(result.getBody());
                xml.nextTag();
                xml.nextTag();
                hasProducts = false;
                while (!XMLEventReaderUtil.isNextEndElement(xml, "products")) {
                    ValueMapDecorator vm = new ValueMapDecorator(this.parser.parseProductFeedEntry(xml));
                    String code = (String)vm.get("code", String.class);
                    this.importProduct(ctx, xml, importSession, (ValueMap)vm, code, false);
                    hasProducts = true;
                }
            }
            finally {
                if (xml != null) {
                    xml.close();
                }
                if (result != null) {
                    result.release();
                }
            }
            ++page;
        } while (hasProducts);
        if (ctx.hasOrphans()) {
            this.logMessage("Warning: have variants for (" + StringUtils.join(ctx.getOrphanBaseProductCodes(), (String)", ") + "), but no base product.", false);
        }
    }

    private void importProduct(ImporterContext ctx, XMLEventReader xml, Session importSession, ValueMap vm, String code, boolean b) throws Exception {
        List categories = (List)vm.get("categories", List.class);
        if (categories != null && categories.size() > 0) {
            String productBasePath = this.getProductPath(ctx, vm, categories);
            Resource productResource = HybrisUtil.findProductInBucket(ctx.getResolver().getResource(Text.getRelativeParent((String)productBasePath, (int)1)), code);
            Node productNode = productResource != null ? (Node)productResource.adaptTo(Node.class) : this.createProduct(productBasePath, importSession);
            ctx.addProduct(code, productNode.getPath(), (List)vm.get("variants", List.class));
            this.handler.updateProduct(productNode, ctx, vm, categories);
            Node imageNode = productNode.hasNode("image") ? productNode.getNode("image") : this.createImage(productNode);
            this.handler.updateAsset(imageNode, ctx, vm);
            Set<ValueMap> orphans = ctx.getOrphans(code);
            if (orphans != null) {
                for (ValueMap orphan : orphans) {
                    Node variantNode;
                    Resource variantResource;
                    Resource resource = variantResource = productResource != null ? productResource.getChild(code) : null;
                    if (variantResource != null && code.equals(HybrisUtil.getProductId(variantResource))) {
                        variantNode = (Node)variantResource.adaptTo(Node.class);
                    } else {
                        String orphanCode = (String)orphan.get("code", String.class);
                        variantNode = this.createVariant(productNode, orphanCode);
                    }
                    this.handler.updateVariantProduct(variantNode, ctx, orphan, productNode.getPath());
                    Node variantImageNode = variantNode.hasNode("image") ? variantNode.getNode("image") : this.createImage(variantNode);
                    this.handler.updateAsset(variantImageNode, ctx, orphan);
                }
                ctx.pruneOrphans(code);
            }
            if (this.expressUpdate) {
                this.productUpdated(productNode);
            }
        } else {
            String baseProductPath;
            String baseProductCode = vm.containsKey((Object)"baseProductCode") ? (String)vm.get("baseProductCode", String.class) : (vm.containsKey((Object)"baseProduct") ? (String)vm.get("baseProduct", String.class) : ctx.getBaseProduct(code));
            String string = baseProductPath = baseProductCode != null ? ctx.getProductPath(baseProductCode) : null;
            if (baseProductPath != null) {
                Resource baseProductResource = ctx.getResolver().getResource(baseProductPath);
                Resource variantResource = baseProductResource.getChild(code);
                Node variantNode = variantResource != null && code.equals(HybrisUtil.getProductId(variantResource)) ? (Node)variantResource.adaptTo(Node.class) : this.createVariant(importSession.getNode(baseProductPath), code);
                this.handler.updateVariantProduct(variantNode, ctx, vm, baseProductPath);
                Node imageNode = variantNode.hasNode("image") ? variantNode.getNode("image") : this.createImage(variantNode);
                this.handler.updateAsset(imageNode, ctx, vm);
                if (this.expressUpdate) {
                    this.productUpdated(variantNode);
                }
            } else if (baseProductCode != null) {
                ctx.addOrphan(baseProductCode, vm);
            } else {
                ctx.error("Skipping product due to missing base product information (code/path): " + code);
                log.info("Skipping product due to missing base product information (code/path): " + code);
            }
        }
        XMLEventReaderUtil.skipNonElementEvents(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expressUpdate(Resource target) {
        this.expressUpdate = true;
        try {
            this.updateCatalog(target);
        }
        finally {
            this.expressUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importExpressUpdate(Resource base) {
        long beginMillis = System.currentTimeMillis();
        HybrisService hybrisService = this.hybrisFactory.getCommerceService(base);
        ComponentInheritanceValueMap values = new ComponentInheritanceValueMap(base);
        Resource baseResource = HybrisUtil.findBaseStore(base);
        this.catalog = (String)values.getInherited("cq:hybrisCatalogId", String.class);
        this.baseStore = (String)values.getInherited("cq:hybrisBaseStore", String.class);
        this.language = hybrisService.getLanguage();
        this.basePath = baseResource.getPath() + "/" + this.catalog + "/" + this.language;
        Date lastImported = (Date)values.getInherited("cq:hybrisLastImported", Date.class);
        if (lastImported == null) {
            Calendar instance = Calendar.getInstance();
            instance.add(6, -1);
            lastImported = instance.getTime();
        }
        CommandResult result = null;
        XMLEventReader xml = null;
        Set<String> productCodes = null;
        try {
            GetExpressUpdateCommand cmd = new GetExpressUpdateCommand(lastImported, this.catalog);
            result = this.connection.execute((HybrisCommand)cmd, this.baseStore);
            xml = this.xmlFactory.createXMLEventReader(result.getBody());
            productCodes = this.parser.parseExpressUpdate(xml);
        }
        catch (CommerceException e) {
            try {
                hybrisService.checkConnectException(e, false);
            }
            catch (CommerceException x) {
                // empty catch block
            }
        }
        catch (Exception x) {
            log.error("Express update failed", (Throwable)x);
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (XMLStreamException x) {}
            }
            if (result != null) {
                result.release();
            }
        }
        if (productCodes == null || productCodes.isEmpty()) {
            return;
        }
        PrintWriter writer = new PrintWriter(this.logWriter);
        Session importSession = (Session)base.getResourceResolver().adaptTo(Session.class);
        Resource targetResource = base.getResourceResolver().getResource(this.basePath);
        ImporterContext ctx = new ImporterContext(targetResource, this.baseStore, this.catalog, this.hybrisFactory.getServiceContext().catalogVersion, this.language, writer);
        xml = null;
        try {
            log.debug("Product codes to update: " + productCodes);
            this.importCatalogVersion(ctx);
            Resource root = ctx.getResolver().getResource(ctx.getCategoryPath(ctx.getCatalog()));
            ProductPathCachePopulator ppcp = new ProductPathCachePopulator(ctx);
            ppcp.accept(root);
            for (String code : productCodes) {
                result = null;
                try {
                    String productUriTemplate = this.hybrisFactory.getServiceContext().productUriTemplate;
                    String uri = code.indexOf(46) > -1 ? HybrisUtil.createProductUri(code + "/", productUriTemplate) : HybrisUtil.createProductUri(code, productUriTemplate);
                    result = this.connection.execute((HybrisCommand)new GetProductCommand(uri, this.language, false, this.parser.getConfiguredProductAttributes(false)), this.baseStore);
                    if (!result.success()) continue;
                    xml = XMLInputFactory.newInstance().createXMLEventReader(result.getBody());
                    ValueMapDecorator vm = new ValueMapDecorator(this.parser.parseProductData(xml, false));
                    this.importProduct(ctx, xml, importSession, (ValueMap)vm, code, true);
                }
                catch (CommerceException e) {
                    hybrisService.checkConnectException(e, false);
                }
                catch (Exception e) {
                    throw new CommerceException("Parsing product data failed: ", (Throwable)e);
                }
                finally {
                    if (xml != null) {
                        xml.close();
                    }
                    if (result == null) continue;
                    result.release();
                }
            }
        }
        catch (Exception x) {
            log.error("Express update failed", (Throwable)x);
            ctx.error("Express update failed: " + x.getMessage());
        }
        finally {
            long importMillis = System.currentTimeMillis() - beginMillis;
            if (ctx.hasErrors()) {
                writer.append("Import express update finished with errors in " + importMillis + " milliseconds");
                log.info("Import express update finished with errors in {} milliseconds", (Object)importMillis);
            } else {
                writer.append("Import express update finished successfully in " + importMillis + " milliseconds");
                log.info("Import express update finished successfully in {} milliseconds", (Object)importMillis);
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importGroups(String path, String baseStore, PrintWriter writer, ResourceResolver resolver) {
        XMLEventReader xml = null;
        CommandResult result = null;
        ImporterContext ctx = null;
        long beginMillis = System.currentTimeMillis();
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            session.getWorkspace().getObservationManager().setUserData("com.adobe.cq.commerce.hybris.impl.group.GroupSynchronizer.skip");
            JcrUtils.getOrCreateByPath((String)path, (String)"rep:AuthorizableFolder", (Session)session);
            Resource target = resolver.getResource(path);
            ctx = new ImporterContext(target, baseStore, null, null, null, writer);
            result = this.connection.execute((HybrisCommand)new GetGroupsCommand(), ctx.getBaseStore());
            if (!result.success()) {
                throw new CommerceException("Could not get user groups.");
            }
            xml = this.xmlFactory.createXMLEventReader(result.getBody());
            while (xml.hasNext() && !XMLEventReaderUtil.isNextEndElement(xml, "usergroups")) {
                if (XMLEventReaderUtil.isNextStartElement(xml, "usergroup")) {
                    Map<String, String> userGroupData = this.parser.parseUserGroup(xml);
                    try {
                        Group g = this.groupConnector.setHybrisData(userGroupData, target.getPath(), resolver);
                        ctx.info("A", g.getPath());
                    }
                    catch (Exception e) {
                        ctx.error("Could not add group, check error.log for more details");
                    }
                    continue;
                }
                XMLEventReaderUtil.nextTag(xml);
            }
        }
        catch (Exception e) {
            log.error("Importing hybris groups failed", (Throwable)e);
            if (ctx != null) {
                ctx.error("Importing hybris groups failed, check error.log for more details.");
            }
        }
        finally {
            long importMillis = System.currentTimeMillis() - beginMillis;
            if (writer != null) {
                writer.write("\nFinished in " + importMillis + " milliseconds.\n");
            }
            try {
                if (xml != null) {
                    xml.close();
                }
            }
            catch (XMLStreamException e) {}
            if (result != null) {
                result.release();
            }
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) throws Exception {
        super.activate(ctx);
        this.pageSize = PropertiesUtil.toInteger(ctx.getProperties().get(PAGE_SIZE), (int)30);
        this.xmlFactory = XMLInputFactory.newInstance();
    }

    protected boolean validateInput(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.baseStore = request.getParameter("store");
        this.catalog = request.getParameter("catalog");
        String targetPath = request.getParameter("path");
        this.language = request.getParameter("language");
        if (targetPath == null) {
            targetPath = DEFAULT_PRODUCTS_PATH;
        }
        if (this.baseStore != null && this.catalog != null) {
            this.basePath = targetPath + "/" + this.baseStore + "/" + this.catalog + "/" + this.language;
            return true;
        }
        return false;
    }

    protected void logMessage(String message, boolean isError) {
        super.logMessage(message, isError);
        if (isError) {
            log.error(message);
        } else {
            log.info(message);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.xmlFactory = null;
    }

    protected void bindConnection(HybrisConnection hybrisConnection) {
        this.connection = hybrisConnection;
    }

    protected void unbindConnection(HybrisConnection hybrisConnection) {
        if (this.connection == hybrisConnection) {
            this.connection = null;
        }
    }

    protected void bindParser(HybrisResponseParser hybrisResponseParser) {
        this.parser = hybrisResponseParser;
    }

    protected void unbindParser(HybrisResponseParser hybrisResponseParser) {
        if (this.parser == hybrisResponseParser) {
            this.parser = null;
        }
    }

    protected void bindHybrisFactory(HybrisFactory hybrisFactory) {
        this.hybrisFactory = hybrisFactory;
    }

    protected void unbindHybrisFactory(HybrisFactory hybrisFactory) {
        if (this.hybrisFactory == hybrisFactory) {
            this.hybrisFactory = null;
        }
    }

    protected void bindHandler(ImportHandler importHandler) {
        this.handler = importHandler;
    }

    protected void unbindHandler(ImportHandler importHandler) {
        if (this.handler == importHandler) {
            this.handler = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindGroupConnector(GroupConnector groupConnector) {
        this.groupConnector = groupConnector;
    }

    protected void unbindGroupConnector(GroupConnector groupConnector) {
        if (this.groupConnector == groupConnector) {
            this.groupConnector = null;
        }
    }

    class ProductPathCachePopulator
    extends AbstractResourceVisitor {
        private ImporterContext ctx;

        ProductPathCachePopulator(ImporterContext ctx) {
            this.ctx = ctx;
        }

        protected void visit(Resource res) {
            block3: {
                ArrayList<String> variantProductCodes;
                block6: {
                    block4: {
                        ValueMap properties;
                        block5: {
                            if (!HybrisUtil.isProduct(res)) break block3;
                            properties = ResourceUtil.getValueMap((Resource)res);
                            variantProductCodes = new ArrayList<String>();
                            if (!properties.containsKey((Object)"variants")) break block4;
                            String[] variants = (String[])properties.get("variants", String[].class);
                            if (variants == null) break block5;
                            Collections.addAll(variantProductCodes, variants);
                            break block6;
                        }
                        String variant = (String)properties.get("variants", String.class);
                        if (variant == null) break block6;
                        variantProductCodes.add(variant);
                        break block6;
                    }
                    for (Resource c : res.getChildren()) {
                        if (!HybrisUtil.isProduct(c)) continue;
                        variantProductCodes.add(HybrisUtil.getProductId(c));
                    }
                }
                if (variantProductCodes.isEmpty()) {
                    this.ctx.addProduct(HybrisUtil.getProductId(res), res.getPath());
                } else {
                    this.ctx.addProduct(HybrisUtil.getProductId(res), res.getPath(), variantProductCodes);
                }
            }
        }
    }

    class GetExpressUpdateCommand
    extends AbstractHybrisCommand {
        private GetExpressUpdateCommand(Date since, String catalog) {
            this.setPath("/products/expressUpdate");
            this.addParameter("timestamp", DefaultHybrisImporter.this.dateFormatter.format(since));
            this.addParameter("catalog", catalog);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetProductsCommand
    extends AbstractHybrisCommand {
        public GetProductsCommand(String catalog, String catalogVersion, String lang, Integer page, Integer pageSize, Date since, Set<String> attributes) {
            if (since == null) {
                this.setPath("/products/export/full");
            } else {
                this.setPath("/products/export/incremental");
                this.addParameter("timestamp", DefaultHybrisImporter.this.dateFormatter.format(since));
            }
            this.addParameter("catalog", catalog);
            this.addParameter("version", catalogVersion);
            this.addParameter("lang", lang);
            this.addParameter("currentPage", page.toString());
            this.addParameter("pageSize", pageSize.toString());
            if (attributes != null) {
                this.addParameter("options", StringUtils.join(attributes, (String)","));
            }
        }
    }

    class GetCatalogVersionCommand
    extends AbstractHybrisCommand {
        public GetCatalogVersionCommand(String catalog, String catalogVersion, String lang) {
            this.setPath("/catalogs/" + catalog + "/" + catalogVersion);
            this.addParameter("options", "CATEGORIES,SUBCATEGORIES");
            this.addParameter("lang", lang);
        }
    }

    protected static class GetGroupsCommand
    extends AbstractHybrisCommand {
        public GetGroupsCommand() {
            this.setPath("/ws410/rest/usergroups");
        }

        public boolean needsServerAuth() {
            return true;
        }
    }
}

