/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.importer;

import com.adobe.cq.commerce.hybris.connection.CommandResult;
import com.adobe.cq.commerce.hybris.connection.HybrisCommand;
import com.adobe.cq.commerce.hybris.connection.HybrisConnection;
import com.adobe.cq.commerce.hybris.connection.cmd.GenericHybrisCommand;
import com.adobe.cq.commerce.hybris.importer.ImportHandler;
import com.adobe.cq.commerce.hybris.importer.ImporterContext;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Day CQ Commerce Hybris Default Import Handler")
@Service
public class DefaultImportHandler
implements ImportHandler {
    @Deprecated
    protected static final String MIME_TYPE_REGEX = ".*\\?.*mime=([^&]*)";
    @Deprecated
    protected static final String PRODUCT_COMPONENT_PATH_SUFFIX = "/jcr:content/par/product";
    @Property(value={"/etc/commerce/products"})
    public static final String PRODUCTS_PATH = "hybris.products.path";
    @Property(value={"/apps/geometrixx-outdoors/templates/page_category"})
    public static final String CATEGORY_TEMPLATE = "hybris.category.template";
    @Property(value={"/apps/geometrixx-outdoors/templates/page_product"})
    public static final String PRODUCT_TEMPLATE = "hybris.product.template";
    @Property(value={"commerce/components/product"})
    public static final String PRODUCT_RESOURCE_TYPE = "hybris.product.resourcetype";
    @Property(value={"commerce/components/product"})
    public static final String VARIANT_PRODUCT_RESOURCE_TYPE = "hybris.variantproduct.resourcetype";
    @Property(value={"color"})
    public static final String VARIANT_PRODUCT_LEAD_ATTRIBUTE = "hybris.variantproduct.leadattribute";
    @Property(value={"commerce/components/product/image"})
    public static final String PRODUCT_IMAGE_RESOURCE_TYPE = "hybris.image.resourcetype";
    @Property(value={"/content/dam/geometrixx-outdoors/products/import"})
    public static final String DAM_PATH = "hybris.dam.path";
    @Property(value={"geometrixx-outdoors"})
    public static final String TAG_NAMESPACE = "hybris.tag.namespace";
    @Property(value={"_(\\d)+"})
    public static final String TAG_REGEX = "hybris.tag.regex";
    @Property(value={"par/nav_products/tags"})
    public static final String TAG_PATH = "hybris.tag.path";
    @Deprecated
    public static final String DEFAULT_PRODUCTS_PATH = "/etc/commerce/products";
    @Deprecated
    public static final String DEFAULT_CATEGORY_TEMPLATE = "/apps/geometrixx-outdoors/templates/page_category";
    @Deprecated
    public static final String DEFAULT_PRODUCT_TEMPLATE = "/apps/geometrixx-outdoors/templates/page_product";
    public static final String DEFAULT_PRODUCT_RESOURCE_TYPE = "commerce/components/product";
    public static final String DEFAULT_VARIANT_PRODUCT_RESOURCE_TYPE = "commerce/components/product";
    public static final String DEFAULT_VARIANT_PRODUCT_LEAD_ATTRIBUTE = "color";
    public static final String DEFAULT_PRODUCT_IMAGE_RESOURCE_TYPE = "commerce/components/product/image";
    public static final String DEFAULT_DAM_PATH = "/content/dam/geometrixx-outdoors/products/import";
    public static final String DEFAULT_TAG_NAMESPACE = "geometrixx-outdoors";
    public static final String DEFAULT_TAG_REGEX = "_(\\d)+";
    @Deprecated
    public static final String DEFAULT_TAG_PATH = "par/nav_products/tags";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected HybrisConnection connection;
    @Reference
    protected PageManagerFactory pageManagerFactory;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Deprecated
    protected String productsPath;
    @Deprecated
    protected String categoryTemplate;
    @Deprecated
    protected String productTemplate;
    protected String productResourceType;
    protected String variantProductResourceType;
    protected String leadVariantAttribute;
    protected String imageResourceType;
    protected String damPath;
    protected String tagNamespace;
    protected String tagRegex;
    @Deprecated
    protected String tagPropertyPath;

    @Override
    public String createTag(ImporterContext ctx, ValueMap values) throws Exception {
        TagManager tagManager = (TagManager)ctx.getResolver().adaptTo(TagManager.class);
        String tagId = ((String)values.get("code", (Object)"")).replaceAll(this.tagRegex, "");
        return tagManager.createTag(this.tagNamespace + ":" + tagId, (String)values.get("name", String.class), "").getTagID();
    }

    @Override
    public String createCatalog(ImporterContext ctx) throws Exception {
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        String path = ctx.getBaseResource().getPath();
        Node n = JcrUtil.createPath((String)path, (String)"sling:Folder", (Session)s);
        Node c = n.getParent();
        c.setProperty("cq:hybrisCatalogId", ctx.getCatalog());
        c.setProperty("cq:hybrisLastImported", Calendar.getInstance());
        Node bs = c.getParent();
        bs.setProperty("cq:commerceProvider", "hybris");
        bs.setProperty("cq:hybrisBaseStore", ctx.getBaseStore());
        ctx.info("A", n.getPath());
        return n.getPath();
    }

    private void writeProperties(Node node, ValueMap values) throws RepositoryException {
        for (String key : values.keySet()) {
            Object value = values.get((Object)key);
            if (value instanceof List && ((List)value).size() > 0) {
                List list = (List)value;
                if (!(list.get(0) instanceof String)) continue;
                node.setProperty(key, list.toArray(new String[0]));
                continue;
            }
            if (value instanceof String) {
                node.setProperty(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                node.setProperty(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Double) {
                node.setProperty(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Long) {
                node.setProperty(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                node.setProperty(key, (BigDecimal)value);
                continue;
            }
            if (!(value instanceof Date)) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            node.setProperty(key, cal);
        }
        if (values.containsKey((Object)"variantAttribute.name") && values.containsKey((Object)"variantAttribute.value")) {
            if (values.get("variantAttribute.name", List.class) != null) {
                List axes = (List)values.get("variantAttribute.name", List.class);
                List axesValues = (List)values.get("variantAttribute.value", List.class);
                for (int i = 0; i < axes.size(); ++i) {
                    node.setProperty((String)axes.get(i), (String)axesValues.get(i));
                }
            } else {
                values.put((Object)((String)values.get((Object)"variantAttribute.name")), values.get((Object)"variantAttribute.value"));
            }
        }
    }

    @Override
    public String createProduct(ImporterContext ctx, ValueMap values, List<String> categories) throws Exception {
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        String parentCategoryPath = ctx.getCategoryPath(categories.get(0));
        String code = (String)values.get("code", String.class);
        String path = parentCategoryPath + "/" + code;
        ctx.info(s.nodeExists(path) ? "M" : "A", path);
        Node prod = JcrUtil.createPath((String)path, (String)"nt:unstructured", (Session)s);
        this.updateProduct(prod, ctx, values, categories);
        return path;
    }

    @Override
    public void updateProduct(Node productNode, ImporterContext ctx, ValueMap values, List<String> categories) throws RepositoryException {
        String code = (String)values.get("code", String.class);
        productNode.setProperty("cq:hybrisProductId", code);
        productNode.setProperty("sling:resourceType", this.productResourceType);
        productNode.setProperty("cq:commerceType", "product");
        productNode.addMixin("cq:Taggable");
        this.writeProperties(productNode, values);
        TagManager tagManager = (TagManager)ctx.getResolver().adaptTo(TagManager.class);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String c : categories) {
            tags.add(tagManager.resolve(ctx.getTagID(c)));
            List<String> parents = ctx.getParentCategories(c);
            for (String p : parents) {
                tags.add(tagManager.resolve(ctx.getTagID(p)));
            }
        }
        tagManager.setTags(ctx.getResolver().getResource(productNode.getPath()), tags.toArray(new Tag[0]), false);
    }

    @Override
    public String createVariantProduct(ImporterContext ctx, ValueMap values, String baseProductPath) throws Exception {
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        String code = (String)values.get("code", String.class);
        String path = baseProductPath + "/" + code;
        ctx.info(s.nodeExists(path) ? "M" : "A", path);
        Node p = JcrUtil.createPath((String)path, (String)"nt:unstructured", (Session)s);
        this.updateVariantProduct(p, ctx, values, baseProductPath);
        return path;
    }

    @Override
    public void updateVariantProduct(Node variantNode, ImporterContext ctx, ValueMap values, String baseProductPath) throws Exception {
        String code = (String)values.get("code", String.class);
        variantNode.setProperty("cq:hybrisProductId", code);
        variantNode.setProperty("sling:resourceType", this.variantProductResourceType);
        variantNode.setProperty("cq:commerceType", "variant");
        this.writeProperties(variantNode, values);
        Node b = ((Session)ctx.getResolver().adaptTo(Session.class)).getNode(baseProductPath);
        if (!b.hasProperty("leadAxis") && values.containsKey((Object)"variantAttribute.name")) {
            String axis = this.getVariantAxis(values);
            b.setProperty("leadAxis", axis);
        }
    }

    private String getVariantAxis(ValueMap values) {
        List attrs = (List)values.get("variantAttribute.name", List.class);
        if (attrs != null) {
            return attrs.contains(this.leadVariantAttribute) ? this.leadVariantAttribute : (String)attrs.get(0);
        }
        return (String)values.get("variantAttribute.name", String.class);
    }

    @Override
    public String createCategory(ImporterContext ctx, ValueMap values, String parentCategory) throws Exception {
        String path;
        String parentCategoryPath = parentCategory != null ? ctx.getCategoryPath(parentCategory) : ctx.getCategoryPath(ctx.getCatalog());
        String code = (String)values.get("code", String.class);
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        if (!s.nodeExists(path = parentCategoryPath + "/" + code)) {
            Node p = JcrUtil.createPath((String)path, (String)"sling:Folder", (Session)s);
            p.setProperty("cq:hybrisId", code);
            this.writeProperties(p, values);
            p.addMixin("cq:Taggable");
            p.setProperty("cq:tags", new String[]{ctx.getTagID(code)});
            ctx.info("A", p.getPath());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsset(Node imageNode, ImporterContext ctx, ValueMap values) throws Exception {
        String locationPropertyPath;
        String baseProductCode;
        String code = (String)values.get("code", String.class);
        String string = values.containsKey((Object)"baseProductCode") ? (String)values.get("baseProductCode", String.class) : (baseProductCode = values.containsKey((Object)"baseProduct") ? (String)values.get("baseProduct", String.class) : ctx.getBaseProduct(code));
        if (!values.containsKey((Object)"images") || ((List)values.get("images", List.class)).size() == 0) {
            return;
        }
        String url = null;
        List images = (List)values.get("images", List.class);
        for (Map image : images) {
            if (!((String)image.get("imageType")).equals("PRIMARY")) continue;
            url = (String)image.get("url");
            break;
        }
        if (url == null) {
            for (Map image : images) {
                if (!image.get("imageType").equals("GALLERY")) continue;
                url = (String)image.get("url");
                break;
            }
            if (url == null) {
                return;
            }
        }
        if (baseProductCode != null) {
            List attrs = (List)values.get("variantAttribute.name", List.class);
            int index = attrs.indexOf(this.leadVariantAttribute);
            String variantValue = (String)((List)values.get("variantAttribute.value", List.class)).get(index != -1 ? index : 0);
            code = baseProductCode + "-" + variantValue;
        }
        if (baseProductCode == null) {
            baseProductCode = code;
        }
        String catalogPath = ctx.getCategoryPath(ctx.getCatalog());
        String assetSuffixPath = ctx.getProductPath(baseProductCode).substring(catalogPath.length()) + "/" + code;
        String assetPath = this.damPath + assetSuffixPath;
        if (!StringUtils.isEmpty((String)ctx.getDAMPath())) {
            assetPath = ctx.getDAMPath() + assetSuffixPath;
        }
        boolean assetChanged = false;
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        if (!s.propertyExists(locationPropertyPath = assetPath + "/jcr:content/cq:hybrisLocation") || !url.equals(s.getProperty(locationPropertyPath).getString())) {
            class GetImageCommand
            extends GenericHybrisCommand {
                GetImageCommand(String uri) {
                    String queryString;
                    int equalsIndex;
                    super(uri);
                    int questionIndex = uri.indexOf(63);
                    if (questionIndex > -1 && (equalsIndex = (queryString = uri.substring(questionIndex + 1)).indexOf(61)) > -1) {
                        this.addParameter(queryString.substring(0, equalsIndex), queryString.substring(equalsIndex + 1));
                    }
                }
            }
            GetImageCommand command = new GetImageCommand(url);
            CommandResult result = this.connection.execute((HybrisCommand)command, ctx.getBaseStore());
            try {
                AssetManager assetManager = (AssetManager)ctx.getResolver().adaptTo(AssetManager.class);
                assetManager.createAsset(assetPath, result.getBody(), null, false);
            }
            finally {
                result.release();
            }
            Node metadataNode = s.getNode(assetPath + "/jcr:content");
            metadataNode.setProperty("cq:hybrisLocation", url);
            ctx.info("A", assetPath);
            assetChanged = true;
        }
        if (!imageNode.hasProperty("fileReference") || assetChanged) {
            imageNode.setProperty("sling:resourceType", this.imageResourceType);
            imageNode.setProperty("fileReference", assetPath);
        }
    }

    @Override
    public String createAsset(ImporterContext ctx, ValueMap values, String productPath) throws Exception {
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        Node imageNode = !s.nodeExists(productPath + "/image") ? JcrUtil.createPath((String)(productPath + "/image"), (String)"nt:unstructured", (String)"nt:unstructured", (Session)s, (boolean)false) : s.getNode(productPath + "/image");
        this.updateAsset(imageNode, ctx, values);
        return imageNode.getProperty("fileReference").getString();
    }

    @Deprecated
    protected String detectMimeType(String url) throws UnsupportedEncodingException {
        String mimeType = "image/jpeg";
        Pattern pattern = Pattern.compile(MIME_TYPE_REGEX);
        Matcher matcher = pattern.matcher(url);
        if (matcher.matches()) {
            mimeType = URLDecoder.decode(matcher.group(1), "UTF-8");
        }
        return mimeType;
    }

    protected void touchContainingPage(ImporterContext ctx, String path) {
        PageManager pageManager = this.pageManagerFactory.getPageManager(ctx.getResolver());
        Session s = (Session)ctx.getResolver().adaptTo(Session.class);
        try {
            pageManager.touch(s.getNode(path), true, Calendar.getInstance(), false);
        }
        catch (Exception e) {
            ctx.error("Touching containing page failed: " + path);
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) throws Exception {
        Dictionary props = ctx.getProperties();
        this.productsPath = PropertiesUtil.toString(props.get(PRODUCTS_PATH), (String)DEFAULT_PRODUCTS_PATH);
        this.categoryTemplate = PropertiesUtil.toString(props.get(CATEGORY_TEMPLATE), (String)DEFAULT_CATEGORY_TEMPLATE);
        this.productTemplate = PropertiesUtil.toString(props.get(PRODUCT_TEMPLATE), (String)DEFAULT_PRODUCT_TEMPLATE);
        this.productResourceType = PropertiesUtil.toString(props.get(PRODUCT_RESOURCE_TYPE), (String)"commerce/components/product");
        this.variantProductResourceType = PropertiesUtil.toString(props.get(VARIANT_PRODUCT_RESOURCE_TYPE), (String)"commerce/components/product");
        this.leadVariantAttribute = PropertiesUtil.toString(props.get(VARIANT_PRODUCT_LEAD_ATTRIBUTE), (String)DEFAULT_VARIANT_PRODUCT_LEAD_ATTRIBUTE);
        this.imageResourceType = PropertiesUtil.toString(props.get(PRODUCT_IMAGE_RESOURCE_TYPE), (String)DEFAULT_PRODUCT_IMAGE_RESOURCE_TYPE);
        this.damPath = PropertiesUtil.toString(props.get(DAM_PATH), (String)DEFAULT_DAM_PATH);
        this.tagNamespace = PropertiesUtil.toString(props.get(TAG_NAMESPACE), (String)DEFAULT_TAG_NAMESPACE);
        this.tagRegex = PropertiesUtil.toString(props.get(TAG_REGEX), (String)DEFAULT_TAG_REGEX);
        this.tagPropertyPath = PropertiesUtil.toString(props.get(TAG_PATH), (String)DEFAULT_TAG_PATH);
    }

    protected void bindConnection(HybrisConnection hybrisConnection) {
        this.connection = hybrisConnection;
    }

    protected void unbindConnection(HybrisConnection hybrisConnection) {
        if (this.connection == hybrisConnection) {
            this.connection = null;
        }
    }

    protected void bindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    protected void unbindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        if (this.pageManagerFactory == pageManagerFactory) {
            this.pageManagerFactory = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

