/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.importer;

import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.hybris.importer.HybrisResponseParser;
import com.adobe.cq.commerce.hybris.importer.XMLEventReaderUtil;
import com.day.cq.commons.date.DateUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Day CQ Commerce Hybris Default Response Parser")
@Service
public class DefaultResponseParser
implements HybrisResponseParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseParser.class);
    @Property(value={"BASIC", "DESCRIPTION", "SUMMARY", "PRICE", "GALLERY", "CATEGORIES", "VARIANT_FULL"})
    public static final String PRODUCT_OPTIONS = "hybris.product.options";
    @Property(value={"jcr:title;name", "jcr:description;summary", "summary;description", "sku;code"})
    public static final String ADDITIONAL_ATTRIBUTE_MAPPING = "hybris.parser.mapping.additional";
    @Property(value={"title;titleCode", "firstname;firstName", "lastname;lastName", "street1;line1", "street2;line2", "zip;postalCode", "zip;postcode", "city;town", "state;state", "country;countryIsoCode"})
    public static final String ADDRESS_MAPPING = "hybris.parser.mapping.address";
    @Property(value={"credit-card-type;cardType", "primary-account-number;cardNumber", "name-on-card;accountHolderName", "expiration-date-month;expiryMonth", "expiration-date-year;expiryYear"})
    public static final String PAYMENT_INFO_MAPPING = "hybris.parser.mapping.paymentinfo";
    @Property(value={"givenName;firstName", "familyName;lastName", "gender;gender"})
    public static final String PROFILE_MAPPING = "hybris.parser.mapping.profile";
    @Property(boolValue={true})
    public static final String HYBRIS_5_ENABLED = "hybris.5.enabled";
    protected Set<String> productAttributes;
    protected Map<String, String> additionalAttributeMapping;
    protected Map<String, String> addressMapping;
    protected Map<String, String> paymentInfoMapping;
    protected Map<String, String> profileMapping;
    protected boolean hybris5Enabled;

    @Override
    public List<Map<String, Object>> parseCatalogVersion(XMLEventReader xml) throws Exception {
        String categoriesTagName;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String catalogVersionTagName = this.hybris5Enabled ? "catalogVersion" : "catalogversion";
        String string = categoriesTagName = this.hybris5Enabled ? "categories" : "categoriesHierarchyData";
        if (XMLEventReaderUtil.isNextStartElement(xml, catalogVersionTagName)) {
            XMLEventReaderUtil.findFirstTag(xml, categoriesTagName, catalogVersionTagName);
            while (!XMLEventReaderUtil.isNextEndElement(xml, categoriesTagName)) {
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) {
                    XMLEventReaderUtil.nextTag(xml);
                    continue;
                }
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("category".equals(tagName)) {
                    list.add(this.parseCategory(xml));
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, catalogVersionTagName);
        }
        return list;
    }

    @Override
    public Map<String, Object> parseCategory(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "category")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "category")) {
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) {
                    XMLEventReaderUtil.nextTag(xml);
                    continue;
                }
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("id".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("code", xml.getElementText());
                    continue;
                }
                if ("lastModified".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("lastModified", DateUtil.parseISO8601((String)xml.getElementText()));
                    continue;
                }
                if ("name".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("name", xml.getElementText());
                    continue;
                }
                if ("url".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    if (this.hybris5Enabled) {
                        values.put("url", xml.getElementText());
                        continue;
                    }
                    values.put("url", "/catalogs/" + xml.getElementText());
                    continue;
                }
                if ("subcategories".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    ArrayList<Map<String, Object>> subcategories = new ArrayList<Map<String, Object>>();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "subcategories")) {
                        subcategories.add(this.parseCategory(xml));
                    }
                    values.put("subcategories", subcategories);
                    XMLEventReaderUtil.skipElement(xml, "subcategories");
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "category");
        }
        return values;
    }

    @Override
    public Map<String, Object> parseProductFeedEntry(XMLEventReader xml) throws Exception {
        return this.parseProductData(xml, false);
    }

    @Override
    public Map<String, Object> parseProductData(XMLEventReader xml, boolean variant) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "product")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "product")) {
                String variantTagName;
                StartElement variantTag;
                XMLEvent variantEvent;
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) {
                    XMLEventReaderUtil.nextTag(xml);
                    continue;
                }
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("code".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("code", xml.getElementText());
                    continue;
                }
                if ("baseProduct".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("baseProduct", xml.getElementText());
                    continue;
                }
                if ("name".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("name", xml.getElementText());
                    continue;
                }
                if ("url".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("url", xml.getElementText().replaceFirst("/v1", ""));
                    continue;
                }
                if ("description".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("description", xml.getElementText());
                    continue;
                }
                if ("purchasable".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("purchasable", Boolean.parseBoolean(xml.getElementText()));
                    continue;
                }
                if ("summary".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("summary", xml.getElementText());
                    continue;
                }
                if ("price".equals(tagName)) {
                    ArrayList<PriceInfo> prices = new ArrayList<PriceInfo>();
                    PriceInfo pi = this.parsePrice(xml, "price");
                    pi.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "POST_TAX", pi.getCurrency().getCurrencyCode())));
                    prices.add(pi);
                    values.put("prices", prices);
                    continue;
                }
                if ("images".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    ArrayList images = new ArrayList();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "images")) {
                        if (XMLEventReaderUtil.findFirstTag(xml, "image", "images") == null) continue;
                        HashMap<String, String> image = new HashMap<String, String>();
                        while (!XMLEventReaderUtil.isNextEndElement(xml, "image")) {
                            XMLEvent imageEvent = XMLEventReaderUtil.nextTag(xml);
                            if (!imageEvent.isStartElement()) continue;
                            image.put(imageEvent.asStartElement().getName().getLocalPart(), xml.getElementText());
                        }
                        images.add(image);
                        XMLEventReaderUtil.skipElement(xml, "image");
                    }
                    values.put("images", images);
                    XMLEventReaderUtil.skipElement(xml, "images");
                    continue;
                }
                if ("categories".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    ArrayList<String> categories = new ArrayList<String>();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "categories")) {
                        XMLEventReaderUtil.findFirstTag(xml, "category");
                        while (!XMLEventReaderUtil.isNextEndElement(xml, "category")) {
                            XMLEvent categoryEvent = XMLEventReaderUtil.nextTag(xml);
                            if (!categoryEvent.isStartElement() || !"code".equals(categoryEvent.asStartElement().getName().getLocalPart())) continue;
                            categories.add(xml.getElementText());
                            break;
                        }
                        XMLEventReaderUtil.skipElement(xml, "category");
                    }
                    values.put("categories", categories);
                    XMLEventReaderUtil.skipElement(xml, "categories");
                    continue;
                }
                if ("variantOptions".equals(tagName)) {
                    String variantOptionTagName;
                    XMLEventReaderUtil.nextTag(xml);
                    ArrayList<String> variants = new ArrayList<String>();
                    String string = variantOptionTagName = this.hybris5Enabled ? "variantOption" : "de.hybris.platform.commercefacades.product.data.VariantOptionData";
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "variantOptions")) {
                        String variantCode = null;
                        String variantURL = null;
                        XMLEventReaderUtil.findFirstTag(xml, variantOptionTagName);
                        while (!XMLEventReaderUtil.isNextEndElement(xml, variantOptionTagName)) {
                            variantEvent = XMLEventReaderUtil.nextTag(xml);
                            if (variantEvent == null || !variantEvent.isStartElement()) continue;
                            variantTag = variantEvent.asStartElement();
                            variantTagName = variantTag.getName().getLocalPart();
                            if ("code".equals(variantTagName)) {
                                variantCode = xml.getElementText();
                                break;
                            }
                            if ("url".equals(variantTagName)) {
                                variantURL = xml.getElementText();
                                continue;
                            }
                            XMLEventReaderUtil.skipElement(xml, variantTagName);
                        }
                        if (variantCode == null && variantURL != null) {
                            variantCode = variantURL.substring(variantURL.lastIndexOf(47) + 1);
                        }
                        if (variantCode != null) {
                            variants.add(variantCode);
                        }
                        XMLEventReaderUtil.skipElement(xml, variantOptionTagName);
                    }
                    values.put("variants", variants);
                    XMLEventReaderUtil.skipElement(xml, "variantOptions");
                    continue;
                }
                if ("baseOptions".equals(tagName)) {
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "baseOptions")) {
                        XMLEvent variantsEvent;
                        XMLEvent baseOptionEvent = XMLEventReaderUtil.nextTag(xml);
                        if (!baseOptionEvent.isStartElement()) continue;
                        StartElement baseOptionTag = baseOptionEvent.asStartElement();
                        String baseOptionTagName = baseOptionTag.getName().getLocalPart();
                        if ("baseProductCode".equals(baseOptionTagName)) {
                            values.put("baseProductCode", xml.getElementText());
                            continue;
                        }
                        if (!"selected".equals(baseOptionTagName) || (variantsEvent = XMLEventReaderUtil.findFirstTag(xml, "variantOptionQualifiers", "selected")) == null) continue;
                        while (!XMLEventReaderUtil.isNextEndElement(xml, "variantOptionQualifiers")) {
                            variantEvent = XMLEventReaderUtil.nextTag(xml);
                            if (!variantEvent.isStartElement()) continue;
                            variantTag = variantEvent.asStartElement();
                            variantTagName = variantTag.getName().getLocalPart();
                            if ("qualifier".equals(variantTagName)) {
                                this.putValue(values, "variantAttribute.name", xml.getElementText());
                                continue;
                            }
                            if ("name".equals(variantTagName)) {
                                this.putValue(values, "variantAttribute.title", xml.getElementText());
                                continue;
                            }
                            if (!"value".equals(variantTagName)) continue;
                            this.putValue(values, "variantAttribute.value", xml.getElementText());
                        }
                        XMLEventReaderUtil.skipElement(xml, "selected");
                    }
                    XMLEventReaderUtil.skipElement(xml, "baseOptions");
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "product");
        }
        return this.mapValues(values, this.additionalAttributeMapping, true);
    }

    @Override
    public Map<String, Object> parseCart(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "cart")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "cart")) {
                Map<String, Object> entry;
                ArrayList<Map<String, Object>> entries;
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) {
                    XMLEventReaderUtil.nextTag(xml);
                    continue;
                }
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("code".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("code", xml.getElementText());
                    continue;
                }
                if ("guid".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("guid", xml.getElementText());
                    continue;
                }
                if ("net".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("net", Boolean.parseBoolean(xml.getElementText()));
                    continue;
                }
                if ("totalPrice".equals(tagName)) {
                    values.put("totalPrice", this.parsePrice(xml, "totalPrice"));
                    continue;
                }
                if ("totalTax".equals(tagName)) {
                    values.put("totalTax", this.parsePrice(xml, "totalTax"));
                    continue;
                }
                if ("subTotal".equals(tagName)) {
                    values.put("subTotal", this.parsePrice(xml, "subTotal"));
                    continue;
                }
                if ("deliveryCost".equals(tagName)) {
                    values.put("deliveryCost", this.parsePrice(xml, "deliveryCost"));
                    continue;
                }
                if ("entries".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList<Map<String, Object>>();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "entries")) {
                        entry = this.parseCartEntry(xml);
                        entries.add(entry);
                    }
                    values.put("entries", entries);
                    continue;
                }
                if ("totalItems".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("totalItems", Integer.parseInt(xml.getElementText()));
                    continue;
                }
                if ("deliveryAddress".equals(tagName)) {
                    values.put("deliveryAddress", this.parseAddress(xml));
                    continue;
                }
                if ("paymentInfo".equals(tagName)) {
                    values.put("paymentInfo", this.parsePaymentInfo(xml));
                    continue;
                }
                if ("totalUnitCount".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("totalUnitCount", Integer.parseInt(xml.getElementText()));
                    continue;
                }
                if ("appliedProductPromotions".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "appliedProductPromotions")) {
                        entry = this.parseAppliedPromotionEntry(xml);
                        entries.add(entry);
                    }
                    XMLEventReaderUtil.skipElement(xml, "appliedProductPromotions");
                    values.put("appliedProductPromotions", entries);
                    continue;
                }
                if ("appliedOrderPromotions".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "appliedOrderPromotions")) {
                        entry = this.parseAppliedPromotionEntry(xml);
                        entries.add(entry);
                    }
                    XMLEventReaderUtil.skipElement(xml, "appliedOrderPromotions");
                    values.put("appliedOrderPromotions", entries);
                    continue;
                }
                if ("appliedVouchers".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "appliedVouchers")) {
                        entry = this.parseAppliedVoucherEntry(xml);
                        entries.add(entry);
                    }
                    XMLEventReaderUtil.skipElement(xml, "appliedVouchers");
                    values.put("appliedVouchers", entries);
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "cart");
        }
        return values;
    }

    @Override
    public Map<String, Object> parseCartEntry(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "orderEntry")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "orderEntry")) {
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) {
                    XMLEventReaderUtil.nextTag(xml);
                    continue;
                }
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("entryNumber".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("entryNumber", Integer.parseInt(xml.getElementText()));
                    continue;
                }
                if ("quantity".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("quantity", Integer.parseInt(xml.getElementText()));
                    continue;
                }
                if ("basePrice".equals(tagName)) {
                    values.put("basePrice", this.parsePrice(xml, "basePrice"));
                    continue;
                }
                if ("totalPrice".equals(tagName)) {
                    values.put("totalPrice", this.parsePrice(xml, "totalPrice"));
                    continue;
                }
                if ("code".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("code", xml.getElementText());
                    continue;
                }
                if ("name".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("name", xml.getElementText());
                    continue;
                }
                if ("url".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("url", xml.getElementText());
                    continue;
                }
                if ("product".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "orderEntry");
        }
        return values;
    }

    @Override
    public PriceInfo parsePrice(XMLEventReader xml, String elementName) throws Exception {
        BigDecimal amount = null;
        Currency currency = null;
        if (XMLEventReaderUtil.isNextStartElement(xml, elementName)) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, elementName)) {
                XMLEvent event = XMLEventReaderUtil.nextTag(xml);
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("currencyIso".equals(tagName)) {
                    currency = Currency.getInstance(xml.getElementText());
                } else if ("value".equals(tagName)) {
                    amount = new BigDecimal(xml.getElementText());
                } else {
                    XMLEventReaderUtil.skipElement(xml, tagName);
                }
                if (currency == null || amount == null) continue;
                break;
            }
            XMLEventReaderUtil.skipElement(xml, elementName);
        }
        return new PriceInfo(amount, currency);
    }

    @Override
    public Map<String, Object> parseAddress(XMLEventReader xml) throws Exception {
        while (!xml.peek().isStartElement()) {
            xml.next();
        }
        return this.parseAddress(xml, xml.peek().asStartElement().getName().getLocalPart());
    }

    @Override
    public Map<String, Object> parseAddress(XMLEventReader xml, String elementName) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, elementName)) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, elementName)) {
                XMLEvent event = XMLEventReaderUtil.nextTag(xml);
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("id".equals(tagName)) {
                    values.put("id", xml.getElementText());
                    continue;
                }
                if ("title".equals(tagName)) {
                    values.put("title", xml.getElementText());
                    continue;
                }
                if ("titleCode".equals(tagName)) {
                    values.put("titleCode", xml.getElementText());
                    continue;
                }
                if ("firstName".equals(tagName)) {
                    values.put("firstName", xml.getElementText());
                    continue;
                }
                if ("lastName".equals(tagName)) {
                    values.put("lastName", xml.getElementText());
                    continue;
                }
                if ("line1".equals(tagName)) {
                    values.put("line1", xml.getElementText());
                    continue;
                }
                if ("line2".equals(tagName)) {
                    values.put("line2", xml.getElementText());
                    continue;
                }
                if ("town".equals(tagName)) {
                    values.put("town", xml.getElementText());
                    continue;
                }
                if ("state".equals(tagName)) {
                    values.put("state", xml.getElementText());
                    continue;
                }
                if ("postalCode".equals(tagName)) {
                    values.put("postalCode", xml.getElementText());
                    continue;
                }
                if ("email".equals(tagName)) {
                    values.put("email", xml.getElementText());
                    continue;
                }
                if ("country".equals(tagName)) {
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "country")) {
                        XMLEvent countryEvent = XMLEventReaderUtil.nextTag(xml);
                        if (!countryEvent.isStartElement()) continue;
                        StartElement countryTag = countryEvent.asStartElement();
                        String countryTagName = countryTag.getName().getLocalPart();
                        if ("isocode".equals(countryTagName)) {
                            values.put("countryIsoCode", xml.getElementText());
                            continue;
                        }
                        if (!"name".equals(countryTagName)) continue;
                        values.put("countryName", xml.getElementText());
                    }
                    XMLEventReaderUtil.skipElement(xml, "country");
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, elementName);
        }
        return this.mapAddressFields(values, true);
    }

    @Override
    public Map<String, Object> mapAddressFields(Map<String, Object> values, boolean fromHybris) throws Exception {
        Map<String, Object> mappedValues = this.mapValues(values, this.addressMapping, fromHybris);
        if (mappedValues.get("titleCode") == null) {
            mappedValues.put("titleCode", "mr");
        }
        if (mappedValues.get("line2") == null) {
            mappedValues.put("line2", " ");
        }
        return mappedValues;
    }

    @Override
    public Map<String, Object> parseAppliedPromotionEntry(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "promotionResult")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "promotionResult")) {
                XMLEvent event = XMLEventReaderUtil.nextTag(xml);
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("description".equals(tagName)) {
                    values.put("description", xml.getElementText());
                    continue;
                }
                if ("promotionData".equals(tagName)) {
                    HashMap<String, Object> promotionValues = new HashMap<String, Object>();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "promotionData")) {
                        XMLEvent promoDataEvent = XMLEventReaderUtil.nextTag(xml);
                        if (!promoDataEvent.isStartElement()) continue;
                        StartElement promoDataTag = promoDataEvent.asStartElement();
                        String promoDataTagName = promoDataTag.getName().getLocalPart();
                        if ("promotionType".equals(promoDataTagName)) {
                            promotionValues.put("promotionType", xml.getElementText());
                            continue;
                        }
                        if ("code".equals(promoDataTagName)) {
                            promotionValues.put("code", xml.getElementText());
                            continue;
                        }
                        if ("description".equals(promoDataTagName)) {
                            promotionValues.put("description", xml.getElementText());
                            continue;
                        }
                        if ("endDate".equals(promoDataTagName)) {
                            String dateString = xml.getElementText();
                            promotionValues.put("endDate", this.parseHybrisDate(dateString));
                            continue;
                        }
                        if ("firedMessages".equals(promoDataTagName)) {
                            while (!XMLEventReaderUtil.isNextEndElement(xml, "firedMessages")) {
                                XMLEventReaderUtil.nextTag(xml);
                                this.putValue(promotionValues, "firedMessages", xml.getElementText());
                            }
                            XMLEventReaderUtil.skipElement(xml, "firedMessages");
                            continue;
                        }
                        if ("couldFireMessages".equals(promoDataTagName)) {
                            while (!XMLEventReaderUtil.isNextEndElement(xml, "couldFireMessages")) {
                                XMLEventReaderUtil.nextTag(xml);
                                this.putValue(promotionValues, "couldFireMessages", xml.getElementText());
                            }
                            XMLEventReaderUtil.skipElement(xml, "couldFireMessages");
                            continue;
                        }
                        XMLEventReaderUtil.skipElement(xml, tagName);
                    }
                    values.put("promotionData", promotionValues);
                    XMLEventReaderUtil.skipElement(xml, "promotionData");
                    continue;
                }
                if ("consumedEntries".equals(tagName)) {
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "consumedEntries")) {
                        XMLEvent promoDataEvent = XMLEventReaderUtil.nextTag(xml);
                        if (!promoDataEvent.isStartElement()) continue;
                        StartElement promoDataTag = promoDataEvent.asStartElement();
                        String promoDataTagName = promoDataTag.getName().getLocalPart();
                        if ("consumedOrderEntry".equals(promoDataTagName)) {
                            while (!XMLEventReaderUtil.isNextEndElement(xml, "consumedOrderEntry")) {
                                XMLEvent consumedEvent = XMLEventReaderUtil.nextTag(xml);
                                if (!consumedEvent.isStartElement()) continue;
                                StartElement consumedTag = consumedEvent.asStartElement();
                                String consumedTagName = consumedTag.getName().getLocalPart();
                                if ("orderEntryNumber".equals(consumedTagName)) {
                                    this.putValue(values, "orderEntryNumber", Integer.parseInt(xml.getElementText()));
                                    continue;
                                }
                                XMLEventReaderUtil.skipElement(xml, consumedTagName);
                            }
                            XMLEventReaderUtil.skipElement(xml, "consumedOrderEntry");
                            continue;
                        }
                        XMLEventReaderUtil.skipElement(xml, promoDataTagName);
                    }
                    XMLEventReaderUtil.skipElement(xml, "consumedEntries");
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "promotionResult");
        }
        return values;
    }

    @Override
    public Map<String, Object> parseAppliedVoucherEntry(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "voucher")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "voucher")) {
                XMLEvent event = XMLEventReaderUtil.nextTag(xml);
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("code".equals(tagName)) {
                    values.put("code", xml.getElementText());
                    continue;
                }
                if ("voucherCode".equals(tagName)) {
                    values.put("voucherCode", xml.getElementText());
                    continue;
                }
                if ("name".equals(tagName)) {
                    values.put("name", xml.getElementText());
                    continue;
                }
                if ("description".equals(tagName)) {
                    values.put("description", xml.getElementText());
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "voucher");
        }
        return values;
    }

    protected Map<String, Object> mapValues(Map<String, Object> values, Map<String, String> mapping, boolean fromHybris) {
        HashMap<String, Object> mappedValues = new HashMap<String, Object>();
        if (fromHybris) {
            mappedValues.putAll(values);
        }
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String targetKey;
            String sourceKey = fromHybris ? entry.getValue() : entry.getKey();
            String string = targetKey = fromHybris ? entry.getKey() : entry.getValue();
            if (values.get(sourceKey) == null) continue;
            mappedValues.put(targetKey, values.get(sourceKey));
        }
        return mappedValues;
    }

    @Override
    public Map<String, Object> parsePaymentInfo(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "paymentInfo")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "paymentInfo")) {
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("id".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("id", xml.getElementText());
                    continue;
                }
                if ("accountHolderName".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("accountHolderName", xml.getElementText());
                    continue;
                }
                if ("cardType".equals(tagName)) {
                    if (this.hybris5Enabled) {
                        XMLEventReaderUtil.nextTag(xml);
                        if (XMLEventReaderUtil.isNextStartElement(xml, "code")) {
                            XMLEventReaderUtil.nextTag(xml);
                            values.put("cardType", xml.getElementText());
                            XMLEventReaderUtil.skipElement(xml, "cardType");
                            continue;
                        }
                        XMLEventReaderUtil.skipElement(xml, tagName);
                        continue;
                    }
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("cardType", xml.getElementText());
                    continue;
                }
                if ("cardNumber".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("cardNumber", xml.getElementText());
                    continue;
                }
                if ("expiryMonth".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("expiryMonth", xml.getElementText());
                    continue;
                }
                if ("expiryYear".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("expiryYear", xml.getElementText());
                    continue;
                }
                if ("billingAddress".equals(tagName)) {
                    values.put("billingAddress", this.mapValues(this.parseAddress(xml, tagName), this.addressMapping, true));
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "paymentInfo");
        }
        return this.mapPaymentInfoFields(values, true);
    }

    @Override
    public Map<String, Object> mapPaymentInfoFields(Map<String, Object> values, boolean fromHybris) throws Exception {
        return this.mapValues(values, this.paymentInfoMapping, fromHybris);
    }

    @Override
    public Map<String, Object> parseProfile(XMLEventReader xml) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "customer")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "customer")) {
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("uid".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("uid", xml.getElementText());
                    continue;
                }
                if ("name".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("name", xml.getElementText());
                    continue;
                }
                if ("defaultAddress".equals(tagName)) {
                    values.put("defaultAddress", this.mapValues(this.parseAddress(xml, tagName), this.addressMapping, true));
                    continue;
                }
                if ("titleCode".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("titleCode", xml.getElementText());
                    continue;
                }
                if ("firstName".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("firstName", xml.getElementText());
                    continue;
                }
                if ("lastName".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    values.put("lastName", xml.getElementText());
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
            XMLEventReaderUtil.skipElement(xml, "customer");
        }
        return values;
    }

    @Override
    public Map<String, Object> mapProfileFields(Map<String, Object> values, boolean fromHybris) throws Exception {
        Object gender;
        Map<String, Object> result = this.mapValues(values, this.profileMapping, fromHybris);
        if (!fromHybris && !this.profileMapping.containsValue("titleCode") && (gender = values.get("gender")) != null) {
            result.put("titleCode", gender.equals("male") ? "mr" : "mrs");
        }
        return result;
    }

    @Override
    public Map<String, String> parseUserGroup(XMLEventReader xml) throws Exception {
        HashMap<String, String> userGroup = new HashMap<String, String>();
        XMLEvent ev = XMLEventReaderUtil.nextTag(xml);
        Iterator<Attribute> attrs = ev.asStartElement().getAttributes();
        while (attrs.hasNext()) {
            Attribute a = attrs.next();
            userGroup.put(a.getName().toString(), a.getValue());
        }
        XMLEventReaderUtil.nextTag(xml);
        return userGroup;
    }

    @Override
    public Map<String, String> parsePrincipal(XMLEventReader xml) throws XMLStreamException {
        HashMap<String, String> member = new HashMap<String, String>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "principal")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "principal")) {
                XMLEvent ev = XMLEventReaderUtil.nextTag(xml);
                if (!ev.isStartElement()) continue;
                try {
                    member.put(ev.asStartElement().getName().getLocalPart(), xml.getElementText());
                }
                catch (XMLStreamException e) {}
            }
            XMLEventReaderUtil.skipElement(xml, "principal");
        }
        return member;
    }

    @Override
    public List<Map<String, String>> parseOrders(XMLEventReader xml) throws Exception {
        ArrayList<Map<String, String>> orderList = new ArrayList<Map<String, String>>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "orders")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "orders")) {
                XMLEventReaderUtil.nextTag(xml);
                HashMap<String, String> order = new HashMap<String, String>();
                while (!XMLEventReaderUtil.isNextEndElement(xml, "order")) {
                    XMLEvent event = xml.peek();
                    if (!event.isStartElement()) continue;
                    StartElement tag = event.asStartElement();
                    String tagName = tag.getName().getLocalPart();
                    if ("code".equals(tagName)) {
                        XMLEventReaderUtil.nextTag(xml);
                        order.put("code", xml.getElementText());
                        continue;
                    }
                    if ("guid".equals(tagName)) {
                        XMLEventReaderUtil.nextTag(xml);
                        order.put("guid", xml.getElementText());
                        continue;
                    }
                    if ("placed".equals(tagName)) {
                        XMLEventReaderUtil.nextTag(xml);
                        order.put("placed", xml.getElementText());
                        continue;
                    }
                    if ("statusDisplay".equals(tagName)) {
                        XMLEventReaderUtil.nextTag(xml);
                        order.put("statusDisplay", xml.getElementText());
                        continue;
                    }
                    if ("total".equals(tagName)) {
                        XMLEventReaderUtil.nextTag(xml);
                        while (!XMLEventReaderUtil.isNextEndElement(xml, "total")) {
                            XMLEvent event2 = xml.peek();
                            if (!event2.isStartElement()) continue;
                            StartElement tag2 = event2.asStartElement();
                            String tagName2 = tag2.getName().getLocalPart();
                            if ("formattedValue".equals(tagName2)) {
                                XMLEventReaderUtil.nextTag(xml);
                                order.put("total", xml.getElementText());
                                continue;
                            }
                            XMLEventReaderUtil.skipElement(xml, tagName2);
                        }
                        XMLEventReaderUtil.skipElement(xml, "total");
                        continue;
                    }
                    XMLEventReaderUtil.skipElement(xml, tagName);
                }
                XMLEventReaderUtil.skipElement(xml, "order");
                if (order.isEmpty()) continue;
                orderList.add(order);
            }
            XMLEventReaderUtil.skipElement(xml, "orders");
        }
        return orderList;
    }

    @Override
    public Map<String, Object> parseOrder(XMLEventReader xml) throws Exception {
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "order")) {
            XMLEventReaderUtil.nextTag(xml);
            while (!XMLEventReaderUtil.isNextEndElement(xml, "order")) {
                Map<String, Object> entry;
                ArrayList<Map<String, Object>> entries;
                XMLEvent event = xml.peek();
                if (!event.isStartElement()) continue;
                StartElement tag = event.asStartElement();
                String tagName = tag.getName().getLocalPart();
                if ("code".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    orderMap.put("code", xml.getElementText());
                    continue;
                }
                if ("guid".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    orderMap.put("guid", xml.getElementText());
                    continue;
                }
                if ("created".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    orderMap.put("created", this.parseHybrisDate(xml.getElementText()));
                    continue;
                }
                if ("statusDisplay".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    orderMap.put("statusDisplay", xml.getElementText());
                    continue;
                }
                if ("deliveryAddress".equals(tagName)) {
                    orderMap.put("deliveryAddress", this.parseAddress(xml));
                    continue;
                }
                if ("paymentInfo".equals(tagName)) {
                    orderMap.put("paymentInfo", this.parsePaymentInfo(xml));
                    continue;
                }
                if ("subTotal".equals(tagName)) {
                    orderMap.put("subTotal", this.parsePrice(xml, "subTotal"));
                    continue;
                }
                if ("deliveryCost".equals(tagName)) {
                    orderMap.put("deliveryCost", this.parsePrice(xml, "deliveryCost"));
                    continue;
                }
                if ("totalTax".equals(tagName)) {
                    orderMap.put("totalTax", this.parsePrice(xml, "totalTax"));
                    continue;
                }
                if ("totalPriceWithTax".equals(tagName)) {
                    orderMap.put("totalPriceWithTax", this.parsePrice(xml, "totalPriceWithTax"));
                    continue;
                }
                if ("entries".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "entries")) {
                        entryList.add(this.parseCartEntry(xml));
                    }
                    XMLEventReaderUtil.skipElement(xml, "entries");
                    orderMap.put("entries", entryList);
                    continue;
                }
                if ("appliedProductPromotions".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList<Map<String, Object>>();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "appliedProductPromotions")) {
                        entry = this.parseAppliedPromotionEntry(xml);
                        entries.add(entry);
                    }
                    XMLEventReaderUtil.skipElement(xml, "appliedProductPromotions");
                    orderMap.put("appliedProductPromotions", entries);
                    continue;
                }
                if ("appliedOrderPromotions".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "appliedOrderPromotions")) {
                        entry = this.parseAppliedPromotionEntry(xml);
                        entries.add(entry);
                    }
                    XMLEventReaderUtil.skipElement(xml, "appliedOrderPromotions");
                    orderMap.put("appliedOrderPromotions", entries);
                    continue;
                }
                if ("appliedVouchers".equals(tagName)) {
                    XMLEventReaderUtil.nextTag(xml);
                    entries = new ArrayList();
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "appliedVouchers")) {
                        entry = this.parseAppliedVoucherEntry(xml);
                        entries.add(entry);
                    }
                    XMLEventReaderUtil.skipElement(xml, "appliedVouchers");
                    orderMap.put("appliedVouchers", entries);
                    continue;
                }
                XMLEventReaderUtil.skipElement(xml, tagName);
            }
        }
        XMLEventReaderUtil.skipElement(xml, "order");
        return orderMap;
    }

    @Override
    public Set<String> parseExpressUpdate(XMLEventReader xml) throws Exception {
        HashSet<String> productCodes = new HashSet<String>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "expressUpdate")) {
            xml.nextTag();
            while (!XMLEventReaderUtil.isNextEndElement(xml, "expressUpdate")) {
                if (!XMLEventReaderUtil.isNextStartElement(xml, "productExpressUpdateElements")) continue;
                xml.nextTag();
                while (!XMLEventReaderUtil.isNextEndElement(xml, "productExpressUpdateElements")) {
                    if (XMLEventReaderUtil.isNextStartElement(xml, "product")) {
                        XMLEventReaderUtil.nextTag(xml);
                        while (!XMLEventReaderUtil.isNextEndElement(xml, "product")) {
                            XMLEvent event = xml.peek();
                            if (!event.isStartElement()) {
                                XMLEventReaderUtil.nextTag(xml);
                                continue;
                            }
                            StartElement tag = event.asStartElement();
                            String tagName = tag.getName().getLocalPart();
                            if ("code".equals(tagName)) {
                                XMLEventReaderUtil.nextTag(xml);
                                String elementText = xml.getElementText();
                                if (elementText == null || (elementText = elementText.trim()).length() <= 0) continue;
                                productCodes.add(elementText);
                                continue;
                            }
                            XMLEventReaderUtil.skipElement(xml, tagName);
                        }
                    }
                    XMLEventReaderUtil.skipElement(xml, "product");
                }
                XMLEventReaderUtil.skipElement(xml, "productExpressUpdateElements");
            }
            XMLEventReaderUtil.skipElement(xml, "productExpressUpdate");
        }
        return productCodes;
    }

    @Override
    public List<Map<String, Object>> parsePromotions(XMLEventReader xml) throws Exception {
        ArrayList<Map<String, Object>> promotionList = new ArrayList<Map<String, Object>>();
        if (XMLEventReaderUtil.isNextStartElement(xml, "promotions")) {
            xml.nextTag();
            while (!XMLEventReaderUtil.isNextEndElement(xml, "promotions")) {
                if (XMLEventReaderUtil.isNextStartElement(xml, "promotion")) {
                    XMLEventReaderUtil.nextTag(xml);
                    HashMap<String, Object> promotion = new HashMap<String, Object>();
                    promotionList.add(promotion);
                    while (!XMLEventReaderUtil.isNextEndElement(xml, "promotion")) {
                        XMLEvent event = xml.peek();
                        if (!event.isStartElement()) {
                            XMLEventReaderUtil.nextTag(xml);
                            continue;
                        }
                        StartElement tag = event.asStartElement();
                        String tagName = tag.getName().getLocalPart();
                        if ("code".equals(tagName)) {
                            XMLEventReaderUtil.nextTag(xml);
                            promotion.put("code", xml.getElementText());
                            continue;
                        }
                        if ("promotionType".equals(tagName)) {
                            XMLEventReaderUtil.nextTag(xml);
                            promotion.put("promotionType", xml.getElementText());
                            continue;
                        }
                        if ("description".equals(tagName)) {
                            XMLEventReaderUtil.nextTag(xml);
                            promotion.put("description", xml.getElementText());
                            continue;
                        }
                        if ("endDate".equals(tagName)) {
                            XMLEventReaderUtil.nextTag(xml);
                            promotion.put("endDate", this.parseHybrisDate(xml.getElementText()));
                            continue;
                        }
                        XMLEventReaderUtil.skipElement(xml, tagName);
                    }
                }
                XMLEventReaderUtil.skipElement(xml, "promotion");
            }
            XMLEventReaderUtil.skipElement(xml, "promotions");
        }
        return promotionList;
    }

    protected <T> void putValue(Map<String, Object> values, String key, T value) {
        if (values.containsKey(key)) {
            Object current = values.get(key);
            if (current instanceof List) {
                ((List)current).add(value);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(current);
                list.add(value);
                values.put(key, list);
            }
        } else {
            values.put(key, value);
        }
    }

    @Override
    public Set<String> getConfiguredProductAttributes(boolean variant) {
        return this.productAttributes;
    }

    private Date parseHybrisDate(String dateString) {
        try {
            int lastColonPos = dateString.lastIndexOf(58);
            if (lastColonPos > 18) {
                dateString = dateString.substring(0, lastColonPos).concat(dateString.substring(lastColonPos + 1));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            return format.parse(dateString);
        }
        catch (ParseException x) {
            LOGGER.error("Invalid date format: " + dateString);
            return null;
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.productAttributes = new HashSet<String>();
        Collections.addAll(this.productAttributes, PropertiesUtil.toStringArray(ctx.getProperties().get(PRODUCT_OPTIONS)));
        this.additionalAttributeMapping = this.setupMapping(ADDITIONAL_ATTRIBUTE_MAPPING, ctx);
        this.addressMapping = this.setupMapping(ADDRESS_MAPPING, ctx);
        this.paymentInfoMapping = this.setupMapping(PAYMENT_INFO_MAPPING, ctx);
        this.profileMapping = this.setupMapping(PROFILE_MAPPING, ctx);
        this.hybris5Enabled = PropertiesUtil.toBoolean(ctx.getProperties().get(HYBRIS_5_ENABLED), (boolean)false);
    }

    private Map<String, String> setupMapping(String configKey, ComponentContext ctx) {
        String[] mapping;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : mapping = PropertiesUtil.toStringArray(ctx.getProperties().get(configKey))) {
            String[] components = s.split(";");
            result.put(components[0], components[1]);
        }
        return result;
    }
}

