/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.importer;

import com.adobe.cq.commerce.hybris.HybrisUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterContext {
    private Resource baseResource;
    private ResourceResolver resolver;
    private String baseStore;
    private String catalog;
    private String catalogVersion;
    private String language;
    private String damPath;
    private int unsavedProducts;
    private PrintWriter writer;
    private boolean hasErrors;
    private Map<String, String> categoryCache;
    private Map<String, String> parentCategoryMapping;
    private Map<String, String> productCache;
    private Map<String, String> baseProductMapping;
    private Map<String, String> tagsCache;
    private Map<String, Set<ValueMap>> orphans;

    public ImporterContext(Resource base, String store, String catalog, String catalogVersion, String language, PrintWriter writer) {
        this.baseResource = base;
        this.resolver = base.getResourceResolver();
        this.baseStore = store;
        this.catalog = catalog;
        this.catalogVersion = catalogVersion;
        this.language = language;
        this.unsavedProducts = 0;
        this.writer = writer;
        this.hasErrors = false;
        this.categoryCache = new HashMap<String, String>();
        this.productCache = new HashMap<String, String>();
        this.tagsCache = new HashMap<String, String>();
        this.parentCategoryMapping = new HashMap<String, String>();
        this.baseProductMapping = new HashMap<String, String>();
        this.orphans = new HashMap<String, Set<ValueMap>>();
    }

    public ImporterContext(Resource base, String store, String catalog, String catalogVersion, String language, String damPath, PrintWriter writer) {
        this(base, store, catalog, catalogVersion, language, writer);
        this.damPath = damPath;
    }

    public Resource getBaseResource() {
        return this.baseResource;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public String getBaseStore() {
        return this.baseStore;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getCatalogVersion() {
        return this.catalogVersion;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDAMPath() {
        return this.damPath;
    }

    public int getUnsavedProducts() {
        return this.unsavedProducts;
    }

    public void resetUnsavedProducts() {
        this.unsavedProducts = 0;
    }

    public void addCategory(String code, String parentCode, String path) {
        this.categoryCache.put(code, path);
        if (parentCode != null) {
            this.parentCategoryMapping.put(code, parentCode);
        }
    }

    public String getCategoryPath(String code) {
        return this.categoryCache.get(code);
    }

    public List<String> getParentCategories(String code) {
        ArrayList<String> result = new ArrayList<String>();
        String c = code;
        while (this.parentCategoryMapping.containsKey(c)) {
            c = this.parentCategoryMapping.get(c);
            result.add(c);
        }
        return result;
    }

    public void addProduct(String code, String path) {
        ++this.unsavedProducts;
        this.productCache.put(code, path);
    }

    public void addProduct(String code, String path, List<String> variants) {
        ++this.unsavedProducts;
        this.productCache.put(code, path);
        if (variants != null) {
            for (String v : variants) {
                this.baseProductMapping.put(v, code);
            }
        }
    }

    public String getProductPath(String code) {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            if (this.productCache.containsKey(code) && session.nodeExists(this.productCache.get(code))) {
                return this.productCache.get(code);
            }
            String basePath = this.productCache.containsKey(code) ? Text.getRelativeParent((String)this.productCache.get(code), (int)1) : this.baseResource.getPath();
            Resource productResource = HybrisUtil.findProductInBucket(this.resolver.getResource(basePath), code);
            if (productResource != null) {
                this.productCache.put(code, productResource.getPath());
                return productResource.getPath();
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public String getBaseProduct(String code) {
        return this.baseProductMapping.get(code);
    }

    public void addTag(String categoryCode, String tagID) {
        this.tagsCache.put(categoryCode, tagID);
    }

    public String getTagID(String categoryCode) {
        return this.tagsCache.get(categoryCode);
    }

    public void addOrphan(String baseProductCode, ValueMap vm) {
        Set<Object> productOrphans;
        if (this.orphans.containsKey(baseProductCode)) {
            productOrphans = this.orphans.get(baseProductCode);
        } else {
            productOrphans = new HashSet();
            this.orphans.put(baseProductCode, productOrphans);
        }
        productOrphans.add(vm);
    }

    public Set<ValueMap> getOrphans(String baseProductCode) {
        return this.orphans.get(baseProductCode);
    }

    public void pruneOrphans(String baseProductCode) {
        this.orphans.remove(baseProductCode);
    }

    public boolean hasOrphans() {
        return !this.orphans.isEmpty();
    }

    public Set<String> getOrphanBaseProductCodes() {
        return this.orphans.keySet();
    }

    public void info(String op, String msg) {
        if (this.writer != null) {
            this.writer.append(op).append(" ").append(msg).append("\n");
            this.writer.flush();
        }
    }

    public void error(String msg) {
        if (this.writer != null) {
            this.writer.append("E ").append(msg).append("\n");
            this.writer.flush();
        }
        this.hasErrors = true;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }
}

