/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.hybris.importer;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class XMLEventReaderUtil {
    private static final XMLInputFactory xmlFactory = XMLInputFactory.newInstance();

    public static XMLEventReader createReader(InputStream is) throws XMLStreamException {
        return xmlFactory.createXMLEventReader(is);
    }

    public static XMLEvent nextTag(XMLEventReader xml) throws XMLStreamException {
        while (xml.hasNext()) {
            XMLEvent ev = xml.nextEvent();
            if (!ev.isStartElement() && !ev.isEndElement()) continue;
            return ev;
        }
        return null;
    }

    public static boolean isStartElement(XMLEvent event, String localName) throws XMLStreamException {
        return event.isStartElement() && event.asStartElement().getName().getLocalPart().equalsIgnoreCase(localName);
    }

    public static boolean isEndElement(XMLEvent tag, String localName) throws XMLStreamException {
        return tag == null || tag.isEndElement() && tag.asEndElement().getName().getLocalPart().equalsIgnoreCase(localName);
    }

    public static boolean isNextStartElement(XMLEventReader xml, String localName) throws XMLStreamException {
        XMLEventReaderUtil.skipNonElementEvents(xml);
        return XMLEventReaderUtil.isStartElement(xml.peek(), localName);
    }

    public static boolean isNextEndElement(XMLEventReader xml, String localName) throws XMLStreamException {
        XMLEventReaderUtil.skipNonElementEvents(xml);
        return XMLEventReaderUtil.isEndElement(xml.peek(), localName);
    }

    public static void skipElement(XMLEventReader xml, String localName) throws XMLStreamException {
        XMLEvent ev;
        while (!(!xml.hasNext() || (ev = xml.nextEvent()).isEndElement() && ev.asEndElement().getName().getLocalPart().equalsIgnoreCase(localName))) {
        }
    }

    public static void skipNonElementEvents(XMLEventReader xml) throws XMLStreamException {
        while (xml.peek() != null && !xml.peek().isStartElement() && !xml.peek().isEndElement()) {
            xml.nextEvent();
        }
    }

    public static XMLEvent findFirstTag(XMLEventReader xml, String localName) throws XMLStreamException {
        while (xml.hasNext()) {
            XMLEvent ev = xml.nextEvent();
            if (!ev.isStartElement() || !ev.asStartElement().getName().getLocalPart().equalsIgnoreCase(localName)) continue;
            return ev;
        }
        return null;
    }

    public static XMLEvent findFirstTag(XMLEventReader xml, String localName, String parentLocalName) throws XMLStreamException {
        XMLEvent peek;
        while (!(!xml.hasNext() || (peek = xml.peek()).isEndElement() && peek.asEndElement().getName().getLocalPart().equalsIgnoreCase(parentLocalName))) {
            XMLEvent ev = xml.nextEvent();
            if (!ev.isStartElement() || !ev.asStartElement().getName().getLocalPart().equalsIgnoreCase(localName)) continue;
            return ev;
        }
        return null;
    }

    public static String getAttributeValue(XMLEvent event, String attributeName) {
        if (event.isStartElement()) {
            QName attributeQName = new QName(attributeName);
            Attribute attribute = event.asStartElement().getAttributeByName(attributeQName);
            if (attribute != null) {
                return attribute.getValue();
            }
        }
        return null;
    }
}

