/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Name;
import com.adobe.qe.toughday.api.annotations.labels.NotNull;
import com.adobe.qe.toughday.api.core.AbstractTestRunner;
import com.adobe.qe.toughday.api.core.TestId;
import com.adobe.qe.toughday.api.core.benchmark.Benchmark;
import com.adobe.qe.toughday.api.core.config.GlobalArgs;
import com.adobe.qe.toughday.internal.core.UUIDTestId;
import com.adobe.qe.toughday.internal.core.benckmark.BenchmarkImpl;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractTest {
    protected static List<Thread> extraThreads = Collections.synchronizedList(new ArrayList());
    private static final SimpleDateFormat TIME_STAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    @NotNull
    private TestId id = new UUIDTestId();
    private String name;
    private AbstractTest parent;
    private GlobalArgs globalArgs;
    protected File workspace = new File("workspace");
    private Logger logger;
    private BenchmarkImpl benchmark;
    private boolean showSteps = false;

    public AbstractTest() {
        this.workspace.mkdirs();
        this.benchmark = new BenchmarkImpl();
        this.name = this.getClass().getSimpleName();
        if (this.getClass().isAnnotationPresent(Name.class)) {
            Name d = this.getClass().getAnnotation(Name.class);
            this.name = d.name();
        }
    }

    public static List<Thread> getExtraThreads() {
        return extraThreads;
    }

    public static void addExtraThread(Thread thread) {
        extraThreads.add(thread);
    }

    @ConfigArgGet
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.parent != null ? this.parent.getFullName() + "." + this.getName() : this.getName();
    }

    @ConfigArgSet(required=false, desc="The name of this test")
    public AbstractTest setName(String name) {
        this.name = name;
        return this;
    }

    @ConfigArgSet(required=false, defaultValue="false", desc="Show test steps in the aggregated publish. (They are always shown in the detailed publish)")
    public AbstractTest setShowSteps(String showTestSteps) {
        this.showSteps = Boolean.parseBoolean(showTestSteps);
        return this;
    }

    @ConfigArgGet
    public boolean getShowSteps() {
        return this.showSteps;
    }

    public boolean getShowStepsResolved() {
        return this.getShowSteps() || (this.getParent() != null ? this.getParent().getShowStepsResolved() : this.getGlobalArgs().getShowSteps());
    }

    public void setWorkspace(File workspace) {
        this.workspace = workspace;
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public Benchmark benchmark() {
        return this.benchmark;
    }

    @NotNull
    public final TestId getId() {
        return this.id;
    }

    public final void setID(TestId id) {
        this.id = id;
    }

    public AbstractTest getParent() {
        return this.parent;
    }

    public void setParent(AbstractTest parent) {
        this.parent = parent;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object other) {
        if (!(other instanceof AbstractTest)) {
            return false;
        }
        return ((AbstractTest)other).getId().equals(this.id);
    }

    public AbstractTest clone() {
        AbstractTest newInstance = this.newInstance();
        newInstance.setID(this.id);
        newInstance.setName(this.getName());
        newInstance.setGlobalArgs(this.getGlobalArgs());
        newInstance.logger = this.logger();
        newInstance.benchmark = this.benchmark.clone();
        newInstance.setShowSteps(Boolean.toString(this.getShowSteps()));
        return newInstance;
    }

    private static Logger createLogger(AbstractTest test) {
        String testName = test.getFullName();
        Class<?> clazz = test.getClass();
        String clazzLoggerName = clazz.getName() + "#" + testName;
        Level logLevel = System.getProperty("toughday.log.level") != null ? Level.valueOf(System.getProperty("toughday.log.level")) : Level.INFO;
        String timestamp = TIME_STAMP_FORMAT.format(new Date());
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.createLayout("%d{yyyy-MM-dd HH:mm:ss.SSS} %-5p %c{1}:%L - %m%n", null, config, null, null, true, false, null, null);
        FileAppender appender = FileAppender.createAppender(String.format("logs/toughday_%s_%s.log", testName, timestamp), "true", "false", "File", "true", "false", "false", "-1", layout, null, "false", null, config);
        appender.start();
        config.addAppender(appender);
        AppenderRef ref = AppenderRef.createAppenderRef("File", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger("false", logLevel, clazzLoggerName, "true", refs, null, config, null);
        loggerConfig.addAppender(appender, null, null);
        config.addLogger(clazzLoggerName, loggerConfig);
        ctx.updateLoggers();
        Logger logger = LogManager.getLogger(clazzLoggerName);
        logger.info("Created logger {}", (Object)logger);
        return logger;
    }

    public Logger logger() {
        if (this.logger == null) {
            this.logger = AbstractTest.createLogger(this);
        }
        return this.logger;
    }

    public AbstractTest setGlobalArgs(GlobalArgs globalArgs) {
        this.globalArgs = globalArgs;
        for (AbstractTest child : this.getChildren()) {
            child.setGlobalArgs(globalArgs);
        }
        return this;
    }

    public GlobalArgs getGlobalArgs() {
        return this.globalArgs;
    }

    public abstract List<AbstractTest> getChildren();

    public boolean includeChildren() {
        return true;
    }

    public abstract Class<? extends AbstractTestRunner> getTestRunnerClass();

    public abstract AbstractTest newInstance();

    protected void communicate(String key, Object message) {
        if (this.parent != null) {
            this.parent.communicate(key, message);
        }
    }

    protected <T> T getCommunication(String key, T defaultValue) {
        if (this.parent != null) {
            return this.parent.getCommunication(key, defaultValue);
        }
        return defaultValue;
    }

    public boolean isAncestorOf(AbstractTest test) {
        for (AbstractTest p = test; p != null; p = p.getParent()) {
            if (!this.equals(p)) continue;
            return true;
        }
        return false;
    }
}

