/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.CloneSetup;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AssumptionUtils;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.api.core.SkippedTestException;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

public abstract class AbstractTestRunner<T extends AbstractTest> {
    private volatile boolean cloneSetupExecuted = true;
    private Method[] setupMethods;
    private Method[] beforeMethods;
    private Method[] afterMethods;

    public AbstractTestRunner(Class<? extends AbstractTest> testClass) {
        LinkedList<Method> setupMethodList = new LinkedList<Method>();
        LinkedList<Method> beforeMethodList = new LinkedList<Method>();
        LinkedList<Method> afterMethodList = new LinkedList<Method>();
        Class<? extends AbstractTest> currentClass = testClass;
        while (!currentClass.getName().equals(AbstractTest.class.getName())) {
            for (Method method : currentClass.getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (annotation.annotationType() == CloneSetup.class) {
                        AssumptionUtils.validateAnnotatedMethod(method, CloneSetup.class);
                        setupMethodList.addFirst(method);
                        method.setAccessible(true);
                        this.cloneSetupExecuted = false;
                        continue;
                    }
                    if (annotation.annotationType() == Before.class) {
                        AssumptionUtils.validateAnnotatedMethod(method, Before.class);
                        method.setAccessible(true);
                        beforeMethodList.addFirst(method);
                        continue;
                    }
                    if (annotation.annotationType() != After.class) continue;
                    AssumptionUtils.validateAnnotatedMethod(method, After.class);
                    method.setAccessible(true);
                    afterMethodList.addLast(method);
                }
            }
            currentClass = currentClass.getSuperclass();
        }
        if (setupMethodList.size() > 0) {
            this.setupMethods = setupMethodList.toArray(new Method[setupMethodList.size()]);
        }
        if (beforeMethodList.size() > 0) {
            this.beforeMethods = beforeMethodList.toArray(new Method[beforeMethodList.size()]);
        }
        if (afterMethodList.size() > 0) {
            this.afterMethods = afterMethodList.toArray(new Method[afterMethodList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean executeCloneSetup(AbstractTest testObject, RunMap runMap) throws Throwable {
        if (this.cloneSetupExecuted) return true;
        AbstractTestRunner abstractTestRunner = this;
        synchronized (abstractTestRunner) {
            if (this.cloneSetupExecuted) return true;
            try {
                this.executeMethods(testObject, this.setupMethods, CloneSetup.class);
                this.cloneSetupExecuted = true;
                return true;
            }
            catch (Throwable e) {
                boolean bl;
                try {
                    testObject.logger().error("Failure in @CloneSetup: ", e);
                    if (testObject.getParent() != null) {
                        throw e;
                    }
                    bl = false;
                    this.cloneSetupExecuted = true;
                }
                catch (Throwable throwable) {
                    this.cloneSetupExecuted = true;
                    throw throwable;
                }
                return bl;
            }
        }
    }

    private void executeBefore(AbstractTest testObject, RunMap runMap) throws Throwable {
        if (this.beforeMethods != null) {
            try {
                this.executeMethods(testObject, this.beforeMethods, Before.class);
            }
            catch (Throwable e) {
                Object testResult = new TestResult(testObject).markAsSkipped(new SkippedTestException(e));
                runMap.record((TestResult)testResult);
                testObject.logger().debug("Failure in @Before: ", e);
                throw e;
            }
        }
    }

    private void executeAfter(AbstractTest testObject) {
        if (this.afterMethods != null) {
            try {
                this.executeMethods(testObject, this.afterMethods, After.class);
            }
            catch (Throwable e) {
                testObject.logger().debug("Failure in @After: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTest(AbstractTest testObject, RunMap runMap) throws Throwable {
        testObject.benchmark().setRunMap(runMap);
        if (!this.executeCloneSetup(testObject, runMap)) {
            return;
        }
        Throwable throwable = null;
        try {
            this.executeBefore(testObject, runMap);
            this.run(testObject, runMap);
        }
        catch (Throwable e) {
            throwable = e;
        }
        finally {
            this.executeAfter(testObject);
        }
        if (throwable != null) {
            if (testObject.getParent() != null) {
                throw throwable;
            }
            testObject.logger().debug("Test failed with error:", throwable);
        }
    }

    protected abstract void run(T var1, RunMap var2) throws Throwable;

    private void executeMethods(AbstractTest testObject, Method[] methods, Class<? extends Annotation> annotation) throws Throwable {
        for (Method method : methods) {
            try {
                method.invoke((Object)testObject, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

