/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core;

import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AbstractTestRunner;
import com.adobe.qe.toughday.api.core.TestId;
import com.adobe.qe.toughday.api.core.config.GlobalArgs;
import com.adobe.qe.toughday.api.runners.CompositeTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class CompositeTest
extends AbstractTest {
    private List<AbstractTest> children;
    private HashMap<String, Object> communications = new HashMap();

    @Override
    protected <T> T getCommunication(String key, T defaultValue) {
        Object value = this.communications.get(key);
        return (T)(value != null ? value : (this.getParent() != null ? this.getParent().getCommunication(key, defaultValue) : defaultValue));
    }

    @Override
    protected void communicate(String key, Object message) {
        this.communications.put(key, message);
    }

    public CompositeTest() {
        this.children = new ArrayList<AbstractTest>();
    }

    @Override
    public List<AbstractTest> getChildren() {
        return this.children;
    }

    protected AbstractTest addChild(AbstractTest child) {
        child.setParent(this);
        child.setGlobalArgs(this.getGlobalArgs());
        this.children.add(child);
        return this;
    }

    public AbstractTest getChild(TestId id) {
        for (AbstractTest child : this.children) {
            if (!child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    @Override
    public Class<? extends AbstractTestRunner> getTestRunnerClass() {
        return CompositeTestRunner.class;
    }

    private void setChildren(List<AbstractTest> children) {
        this.children = children;
    }

    @Override
    public AbstractTest clone() {
        CompositeTest newComposite = (CompositeTest)super.clone();
        ArrayList<AbstractTest> clonedChildren = new ArrayList<AbstractTest>();
        for (AbstractTest test : this.children) {
            AbstractTest newTest = test.clone();
            newTest.setParent(newComposite);
            clonedChildren.add(newTest);
        }
        newComposite.setChildren(clonedChildren);
        return newComposite;
    }

    @Override
    public CompositeTest setGlobalArgs(GlobalArgs globalArgs) {
        super.setGlobalArgs(globalArgs);
        for (AbstractTest test : this.children) {
            test.setGlobalArgs(globalArgs);
        }
        return this;
    }
}

