/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core;

import com.adobe.qe.toughday.api.core.benchmark.signatures.Callable;
import com.adobe.qe.toughday.api.core.benchmark.signatures.VoidCallable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class FluentLogging {
    private Logger logger;
    private List<LogEntry> before = new ArrayList<LogEntry>();
    private List<LogEntry> after = new ArrayList<LogEntry>();
    private List<LogEntry> success = new ArrayList<LogEntry>();
    private List<ThrowableLogEntry> throwable = new ArrayList<ThrowableLogEntry>();

    public FluentLogging(Logger logger) {
        this.logger = logger;
    }

    public static FluentLogging create(Logger logger) {
        return new FluentLogging(logger);
    }

    public FluentLogging before(Level level, String message, Object ... objects) {
        this.before.add(new LogEntry(level, message, objects));
        return this;
    }

    public FluentLogging after(Level level, String message, Object ... objects) {
        this.after.add(new LogEntry(level, message, objects));
        return this;
    }

    public FluentLogging onThrowable(Level level, String message, Object ... objects) {
        this.throwable.add(new ThrowableLogEntry(level, message, objects));
        return this;
    }

    public FluentLogging onThrowable(Level level, String message, boolean includeStackTrace) {
        this.throwable.add(new ThrowableLogEntry(level, message, includeStackTrace));
        return this;
    }

    public FluentLogging onThrowable(Level level, String message) {
        return this.onThrowable(level, message, false);
    }

    public FluentLogging onSuccess(Level level, String message, Object ... objects) {
        this.success.add(new LogEntry(level, message, objects));
        return this;
    }

    public <T> T run(Callable<T> callable) throws Throwable {
        Iterator<LogEntry> iterator;
        for (LogEntry entry : this.before) {
            this.logger.log(entry.level, entry.message, entry.objects);
        }
        try {
            T result = callable.call();
            for (LogEntry logEntry : this.success) {
                this.logger.log(logEntry.level, logEntry.message, logEntry.objects);
            }
            iterator = result;
        }
        catch (Throwable e) {
            try {
                for (ThrowableLogEntry throwableLogEntry : this.throwable) {
                    if (throwableLogEntry.includeStackTrace) {
                        this.logger.log(throwableLogEntry.level, throwableLogEntry.message, e);
                        continue;
                    }
                    this.logger.log(throwableLogEntry.level, throwableLogEntry.message, throwableLogEntry.objects);
                }
                throw e;
            }
            catch (Throwable throwable) {
                for (LogEntry entry : this.after) {
                    this.logger.log(entry.level, entry.message, entry.objects);
                }
                throw throwable;
            }
        }
        for (LogEntry entry : this.after) {
            this.logger.log(entry.level, entry.message, entry.objects);
        }
        return (T)iterator;
    }

    public void run(VoidCallable callable) throws Throwable {
        this.run(() -> {
            callable.call();
            return null;
        });
    }

    private static class ThrowableLogEntry
    extends LogEntry {
        public final boolean includeStackTrace;

        public ThrowableLogEntry(Level level, String message, Object[] objects) {
            super(level, message, objects);
            this.includeStackTrace = false;
        }

        public ThrowableLogEntry(Level level, String message, boolean includeStackTrace) {
            super(level, message, null);
            this.includeStackTrace = includeStackTrace;
        }
    }

    private static class LogEntry {
        public final Level level;
        public final String message;
        public final Object[] objects;

        public LogEntry(Level level, String message, Object[] objects) {
            this.level = level;
            this.message = message;
            this.objects = objects;
        }
    }
}

