/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.core.MetricResult;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class Publisher {
    private String name = this.getClass().getSimpleName();
    private boolean rawPublish = true;
    private boolean aggregatedPublish = true;

    @ConfigArgGet
    public String getName() {
        return this.name;
    }

    @ConfigArgSet(required=false, desc="The name of this publisher")
    public void setName(String name) {
        this.name = name;
    }

    @ConfigArgSet(required=false, defaultValue="true", desc="Enable the raw result publishing")
    public void setRawPublish(String rawPublish) {
        this.rawPublish = Boolean.parseBoolean(rawPublish);
    }

    @ConfigArgGet
    public boolean getRawPublish() {
        return this.rawPublish;
    }

    @ConfigArgSet(required=false, defaultValue="true", desc="Enable the aggregated result publishing")
    public void setAggregatedPublish(String aggregatedPublish) {
        this.aggregatedPublish = Boolean.parseBoolean(aggregatedPublish);
    }

    @ConfigArgGet
    public boolean getAggregatedPublish() {
        return this.aggregatedPublish;
    }

    public void publishAggregatedIntermediate(Map<String, List<MetricResult>> results) {
        if (this.aggregatedPublish) {
            this.doPublishAggregatedIntermediate(results);
        }
    }

    public void publishAggregatedFinal(Map<String, List<MetricResult>> results) {
        if (this.aggregatedPublish) {
            this.doPublishAggregatedFinal(results);
        }
    }

    public void publishRaw(Collection<TestResult> testResults) {
        if (this.rawPublish) {
            this.doPublishRaw(testResults);
        }
    }

    protected abstract void doPublishAggregatedIntermediate(Map<String, List<MetricResult>> var1);

    protected abstract void doPublishAggregatedFinal(Map<String, List<MetricResult>> var1);

    protected abstract void doPublishRaw(Collection<TestResult> var1);

    public abstract void finish();
}

