/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core;

import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AbstractTestRunner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnersContainer {
    private static final Logger LOG = LoggerFactory.getLogger(RunnersContainer.class);
    private static RunnersContainer instance = new RunnersContainer();
    private HashMap<AbstractTest, AbstractTestRunner> testRunners = new HashMap();

    public static RunnersContainer getInstance() {
        return instance;
    }

    private RunnersContainer() {
    }

    public void addRunner(AbstractTest test) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        if (!this.testRunners.containsKey(test)) {
            Class<? extends AbstractTestRunner> runnerClass = test.getTestRunnerClass();
            try {
                Constructor<? extends AbstractTestRunner> constructor = runnerClass.getConstructor(Class.class);
                this.testRunners.put(test, constructor.newInstance(test.getClass()));
            }
            catch (NoSuchMethodException e) {
                LOG.error("Cannot run test " + test.getFullName() + " because the runner doesn't have the appropriate constructor");
                throw new NoSuchMethodException("Test runners must have a constructor with only one parameter, the test Class");
            }
        }
    }

    public AbstractTestRunner getRunner(AbstractTest test) {
        return this.testRunners.get(test);
    }
}

