/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.api.core.benchmark;

import com.adobe.qe.toughday.api.annotations.labels.Nullable;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.api.core.SkippedTestException;
import java.util.Date;

public class TestResult<K> {
    private AbstractTest test;
    private String testFullName;
    private long startMillis = -1L;
    private long startNano = -1L;
    private long endMillis = -1L;
    private String threadName;
    private long threadId;
    private boolean showInAggregatedView = true;
    @Nullable
    private K data;
    private double duration = Double.NaN;
    @Nullable
    private SkippedTestException skippedCause;
    @Nullable
    private Throwable failCause;
    private Status status = Status.PASSED;

    public TestResult(AbstractTest test) {
        this.withThread(Thread.currentThread());
        this.test = test;
        this.testFullName = test.getFullName();
    }

    public AbstractTest getTest() {
        return this.test;
    }

    public String getTestFullName() {
        return this.testFullName;
    }

    public double getDuration() {
        return this.duration;
    }

    @Nullable
    public SkippedTestException getSkippedCause() {
        return this.skippedCause;
    }

    @Nullable
    public Throwable getFailCause() {
        return this.failCause;
    }

    public String getFormattedStartTimestamp() {
        return RunMap.TIME_STAMP_FORMAT.format(new Date(this.startMillis));
    }

    public String getFormattedEndTimestamp() {
        return RunMap.TIME_STAMP_FORMAT.format(new Date(this.endMillis));
    }

    public long getStartTimestamp() {
        return this.startMillis;
    }

    public long getEndTimestamp() {
        return this.endMillis;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    @Nullable
    public K getData() {
        return this.data;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isShowInAggregatedView() {
        return this.showInAggregatedView;
    }

    public <T extends TestResult<K>> T withShowInAggregatedView(boolean showInAggregatedView) {
        this.showInAggregatedView = showInAggregatedView;
        return (T)this;
    }

    public <T extends TestResult<K>> T withThread(Thread t) {
        this.threadName = t.getName();
        this.threadId = t.getId();
        return (T)this;
    }

    public <T extends TestResult<K>> T markAsPassed() {
        this.status = Status.PASSED;
        return (T)this;
    }

    public <T extends TestResult<K>> T markAsFailed(Throwable e) {
        this.failCause = e;
        this.status = Status.FAILED;
        return (T)this;
    }

    public <T extends TestResult<K>> T markAsFailed() {
        return this.markAsFailed(null);
    }

    public <T extends TestResult<K>> T markAsSkipped(SkippedTestException e) {
        this.skippedCause = e;
        this.status = Status.SKIPPED;
        return (T)this;
    }

    public <T extends TestResult<K>> T markAsSkipped() {
        return this.markAsSkipped(null);
    }

    public <T extends TestResult<K>> T withData(K data) {
        this.data = data;
        return (T)this;
    }

    public <T extends TestResult<K>> T beginBenchmark() {
        this.withThread(Thread.currentThread());
        this.withStartTimestamp(System.currentTimeMillis());
        this.startNano = System.nanoTime();
        return (T)this;
    }

    public <T extends TestResult<K>> T endBenchmark() {
        if (this.startNano == -1L) {
            throw new IllegalStateException("beginBenchmark() was not called");
        }
        this.withEndTimestamp(System.currentTimeMillis());
        this.withDuration(TestResult.milliDurationFromNano(this.startNano, System.nanoTime()));
        return (T)this;
    }

    private void withDuration(double duration) {
        this.duration = duration;
    }

    private void withStartTimestamp(long startMillis) {
        this.startMillis = startMillis;
    }

    private void withEndTimestamp(long endMillis) {
        this.endMillis = endMillis;
    }

    public static double milliDurationFromNano(long start, long end) {
        return (end - start) / 1000000L;
    }

    public static enum Status {
        PASSED,
        FAILED,
        SKIPPED;

    }
}

