/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core;

import com.adobe.qe.toughday.api.annotations.Internal;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.internal.core.SuiteSetup;
import com.adobe.qe.toughday.internal.core.engine.PublishMode;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import com.adobe.qe.toughday.metrics.Metric;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class ReflectionsContainer {
    private static final Pattern toughdayContentPackagePattern = Pattern.compile("toughday_sample-.*.zip");
    private static Reflections reflections = new Reflections("", new Scanner[0]);
    private static ReflectionsContainer instance = new ReflectionsContainer();
    private HashMap<String, Class<? extends AbstractTest>> testClasses;
    private HashMap<String, Class<? extends Publisher>> publisherClasses;
    private HashMap<String, Class<? extends SuiteSetup>> suiteSetupClasses;
    private HashMap<String, Class<? extends PublishMode>> publishModeClasses;
    private HashMap<String, Class<? extends RunMode>> runModeClasses;
    private HashMap<String, Class<? extends Metric>> metricClasses;
    private Set<String> classRegister;
    private String toughdayContentPackage;

    public static ReflectionsContainer getInstance() {
        return instance;
    }

    private static boolean excludeClass(Class klass) {
        return Modifier.isAbstract(klass.getModifiers()) || !Modifier.isPublic(klass.getModifiers()) || klass.isAnnotationPresent(Internal.class);
    }

    private ReflectionsContainer() {
        this.updateContainerContent();
        Reflections reflections = new Reflections("", new ResourcesScanner());
        Iterator<String> iterator = reflections.getResources(toughdayContentPackagePattern).iterator();
        if (iterator.hasNext()) {
            this.toughdayContentPackage = iterator.next();
        }
    }

    private void updateContainerContent() {
        String identifier;
        this.testClasses = new HashMap();
        this.publisherClasses = new HashMap();
        this.suiteSetupClasses = new HashMap();
        this.publishModeClasses = new HashMap();
        this.runModeClasses = new HashMap();
        this.metricClasses = new HashMap();
        this.classRegister = new HashSet<String>();
        for (Class<AbstractTest> clazz : reflections.getSubTypesOf(AbstractTest.class)) {
            if (ReflectionsContainer.excludeClass(clazz)) continue;
            this.addToClassRegister(clazz.getName());
            this.testClasses.put(clazz.getName(), clazz);
            if (this.testClasses.containsKey(clazz.getSimpleName())) {
                this.testClasses.put(clazz.getSimpleName(), null);
                continue;
            }
            this.testClasses.put(clazz.getSimpleName(), clazz);
        }
        for (Class<Object> clazz : reflections.getSubTypesOf(Publisher.class)) {
            if (ReflectionsContainer.excludeClass(clazz)) continue;
            this.addToClassRegister(clazz.getName());
            this.publisherClasses.put(clazz.getName(), clazz);
            if (this.publisherClasses.containsKey(clazz.getSimpleName())) {
                this.publisherClasses.put(clazz.getSimpleName(), null);
                continue;
            }
            this.publisherClasses.put(clazz.getSimpleName(), clazz);
        }
        for (Class<Object> clazz : reflections.getSubTypesOf(SuiteSetup.class)) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            if (this.suiteSetupClasses.containsKey(clazz.getSimpleName())) {
                throw new IllegalStateException("A suite class with this name already exists here: " + this.suiteSetupClasses.get(clazz.getSimpleName()).getName());
            }
            this.addToClassRegister(clazz.getSimpleName());
            this.suiteSetupClasses.put(clazz.getSimpleName(), clazz);
        }
        for (Class<Object> clazz : reflections.getSubTypesOf(PublishMode.class)) {
            if (ReflectionsContainer.excludeClass(clazz)) continue;
            identifier = clazz.getSimpleName().toLowerCase();
            if (this.publishModeClasses.containsKey(identifier)) {
                throw new IllegalStateException("A publish mode class with this name already exists here: " + this.publishModeClasses.get(identifier).getName());
            }
            this.addToClassRegister(identifier);
            this.publishModeClasses.put(identifier, clazz);
        }
        for (Class<Object> clazz : reflections.getSubTypesOf(RunMode.class)) {
            if (ReflectionsContainer.excludeClass(clazz)) continue;
            identifier = clazz.getSimpleName().toLowerCase();
            if (this.runModeClasses.containsKey(identifier)) {
                throw new IllegalStateException("A run mode class with this name already exists here: " + this.runModeClasses.get(identifier).getName());
            }
            this.addToClassRegister(identifier);
            this.runModeClasses.put(identifier, clazz);
        }
        for (Class<Object> clazz : reflections.getSubTypesOf(Metric.class)) {
            if (ReflectionsContainer.excludeClass(clazz)) continue;
            this.addToClassRegister(clazz.getName());
            this.metricClasses.put(clazz.getName(), clazz);
            if (this.metricClasses.containsKey(clazz.getSimpleName())) {
                this.metricClasses.put(clazz.getSimpleName(), null);
                continue;
            }
            this.metricClasses.put(clazz.getSimpleName(), clazz);
        }
    }

    private void addToClassRegister(String classIdentifier) {
        if (this.classRegister.contains(classIdentifier)) {
            throw new IllegalArgumentException("A class with this name already exists. Please provide a different name for your class.");
        }
        this.classRegister.add(classIdentifier);
    }

    public boolean isTestClass(String testClass) {
        return this.testClasses.containsKey(testClass);
    }

    public Class<? extends AbstractTest> getTestClass(String testClass) {
        if (this.isTestClass(testClass)) {
            if (this.testClasses.get(testClass) == null) {
                throw new IllegalArgumentException("There is more than one test named: " + testClass + ". Please use the fully qualified domain name.");
            }
            return this.testClasses.get(testClass);
        }
        throw new IllegalArgumentException("Unknown test: " + testClass);
    }

    public HashMap<String, Class<? extends AbstractTest>> getTestClasses() {
        return this.testClasses;
    }

    public boolean isPublisherClass(String publisherClass) {
        return this.publisherClasses.containsKey(publisherClass);
    }

    public Class<? extends Publisher> getPublisherClass(String publisherClass) {
        if (this.isPublisherClass(publisherClass)) {
            if (this.publisherClasses.get(publisherClass) == null) {
                throw new IllegalArgumentException("There is more than one publisher named: " + publisherClass + ". Please use the fully qualified domain name.");
            }
            return this.publisherClasses.get(publisherClass);
        }
        throw new IllegalArgumentException("Unknown publisher: " + publisherClass);
    }

    public HashMap<String, Class<? extends Publisher>> getPublisherClasses() {
        return this.publisherClasses;
    }

    public HashMap<String, Class<? extends SuiteSetup>> getSuiteSetupClasses() {
        return this.suiteSetupClasses;
    }

    public Map<String, Class<? extends PublishMode>> getPublishModeClasses() {
        return this.publishModeClasses;
    }

    public String getToughdayContentPackage() {
        return this.toughdayContentPackage;
    }

    public HashMap<String, Class<? extends RunMode>> getRunModeClasses() {
        return this.runModeClasses;
    }

    public boolean isMetricClass(String metricClass) {
        return this.metricClasses.containsKey(metricClass);
    }

    public Class<? extends Metric> getMetricClass(String metricClass) {
        if (this.isMetricClass(metricClass)) {
            if (this.metricClasses.get(metricClass) == null) {
                throw new IllegalArgumentException("There is more than one metric named: " + metricClass + ". Please use the fully qualified domain name.");
            }
            return this.metricClasses.get(metricClass);
        }
        throw new IllegalArgumentException("Unknown metric: " + metricClass);
    }

    public HashMap<String, Class<? extends Metric>> getMetricClasses() {
        return this.metricClasses;
    }

    public boolean containsClass(String className) {
        return this.classRegister.contains(className);
    }

    public void merge(Reflections reflections) {
        ReflectionsContainer.reflections = reflections;
        this.updateContainerContent();
    }

    public static <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return reflections.getSubTypesOf(type);
    }
}

